/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspOpenedFilesService;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImplKt;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0002DEB\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016J%\u0010\u001f\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b%J'\u0010&\u001a\u0004\u0018\u00010\u00152\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0(H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b)J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150+2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!H\u0016J\u001b\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150+2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u001d\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001cH\u0002J\u001d\u00107\u001a\u00020\u00172\u0006\u00101\u001a\u0002082\u0006\u00109\u001a\u00020.H\u0000\u00a2\u0006\u0002\b:J\u000e\u0010;\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010<J\r\u0010=\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!H\u0016J\u0018\u0010@\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!H\u0016J\u0015\u0010A\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bBJ\u0018\u0010C\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\f0\f0\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006F"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl;", "Lcom/intellij/platform/lsp/api/LspServerManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "CLOSE_FILES_COALESCE_OBJECT", "", "START_SERVER_COALESCE_OBJECT", "eventBroadcaster", "Lcom/intellij/platform/lsp/api/LspServerManagerListener;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "highlightingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "lspServers", "", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "o", "", "addLspServerManagerListener", "listener", "parentDisposable", "sendEventsForExistingServers", "", "h", "dispose", "ensureServerStarted", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "ensureServerStarted$intellij_platform_lsp_impl", "findRunningServer", "condition", "Lkotlin/Function1;", "findRunningServer$intellij_platform_lsp_impl", "getServersForProvider", "", "getServersWithThisFileOpen", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getServersWithThisFileOpen$intellij_platform_lsp_impl", "handleMaybeUnexpectedServerStop", "lspServer", "serverOutput", "", "handleMaybeUnexpectedServerStop$intellij_platform_lsp_impl", "o", "explicitStop", "onDiagnosticsReceived", "Lcom/intellij/platform/lsp/api/LspServer;", "virtualFile", "onDiagnosticsReceived$intellij_platform_lsp_impl", "onProjectRootsChanged", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleClosingFilesThatAreNotOfInterest", "scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl", "startServersIfNeeded", "stopAndRestartIfNeeded", "stopRunningServer", "stopRunningServer$intellij_platform_lsp_impl", "stopServers", "Companion", "LspServerStarterImpl", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,343:1\n1#2:344\n766#3:345\n857#3,2:346\n766#3:348\n857#3,2:349\n1747#3,3:351\n1855#3,2:354\n1855#3,2:357\n1855#3,2:359\n1747#3,2:361\n1749#3:365\n1747#3,2:366\n1749#3:370\n103#4:356\n12474#5,2:363\n12474#5,2:368\n*S KotlinDebug\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl\n*L\n71#1:345\n71#1:346,2\n74#1:348\n74#1:349,2\n128#1:351,3\n146#1:354,2\n219#1:357,2\n315#1:359,2\n98#1:361,2\n98#1:365\n105#1:366,2\n105#1:370\n219#1:356\n99#1:363,2\n106#1:368,2\n*E\n"})
public final class LspServerManagerImpl
implements LspServerManager,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Collection<LspServerImpl> lspServers;
    @NotNull
    private final MergingUpdateQueue highlightingQueue;
    @NotNull
    private final EventDispatcher<LspServerManagerListener> eventDispatcher;
    @NotNull
    private final LspServerManagerListener eventBroadcaster;
    @NotNull
    private final Object START_SERVER_COALESCE_OBJECT;
    @NotNull
    private final Object CLOSE_FILES_COALESCE_OBJECT;

    public LspServerManagerImpl(@NotNull Project project, @NotNull CoroutineScope cs2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs");
        this.project = project;
        this.cs = cs2;
        boolean bl2 = bl = !this.project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "LspServerManager doesn't make sense for the default project";
            throw new AssertionError((Object)string);
        }
        this.o();
        this.h();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.lspServers = list;
        this.highlightingQueue = new MergingUpdateQueue("LSP highlighting queue", 100, true, null, (Disposable)this, null, true);
        EventDispatcher eventDispatcher = EventDispatcher.create(LspServerManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.eventBroadcaster = new LspServerManagerListener(this){
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverStateChanged(@NotNull LspServer lspServer) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).serverStateChanged(lspServer);
            }

            public void fileOpened(@NotNull LspServer lspServer, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).fileOpened(lspServer, file2);
            }

            public void diagnosticsReceived(@NotNull LspServer lspServer, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).diagnosticsReceived(lspServer, file2);
            }
        };
        this.START_SERVER_COALESCE_OBJECT = new Object();
        this.CLOSE_FILES_COALESCE_OBJECT = new Object();
    }

    @NotNull
    public Collection<LspServerImpl> getServersForProvider(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Iterable iterable = this.lspServers;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl3 = false;
            if (!Intrinsics.areEqual(lspServerImpl.getProviderClass(), providerClass)) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    @NotNull
    public final Collection<LspServerImpl> getServersWithThisFileOpen$intellij_platform_lsp_impl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Iterable iterable = this.lspServers;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl3 = false;
            if (!lspServerImpl.isFileOpened$intellij_platform_lsp_impl(file2)) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    @Nullable
    public final LspServerImpl findRunningServer$intellij_platform_lsp_impl(@NotNull Function1<? super LspServerImpl, Boolean> condition) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            boolean bl = false;
            Iterable iterable = this.lspServers;
            for (Object t2 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl2 = false;
                if (!(lspServerImpl.getState() == LspServerState.Running && (Boolean)condition.invoke((Object)lspServerImpl) != false)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void startServersIfNeeded(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        LspServerSupportProvider lspServerSupportProvider = (LspServerSupportProvider)LspServerSupportProvider.Companion.getEP_NAME().findExtension(providerClass);
        if (lspServerSupportProvider == null) {
            LspServerManagerImplKt.access$getLogger$p().error(providerClass.getName() + " is not loaded");
            return;
        }
        Object[] objectArray = new Object[]{providerClass, this.START_SERVER_COALESCE_OBJECT};
        ReadAction.nonBlocking(() -> LspServerManagerImpl.o(this, providerClass, lspServerSupportProvider)).expireWith((Disposable)this).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerManagerImpl.o((Function1)new Function1<List<? extends LspServerDescriptor>, Unit>(this, providerClass){
            final /* synthetic */ LspServerManagerImpl this$0;
            final /* synthetic */ Class<? extends LspServerSupportProvider> $providerClass;
            {
                this.this$0 = $receiver;
                this.$providerClass = $providerClass;
                super(1);
            }

            public final void invoke(@NotNull List<? extends LspServerDescriptor> descriptorsToStart) {
                Intrinsics.checkNotNullParameter(descriptorsToStart, (String)"descriptorsToStart");
                Iterable iterable = descriptorsToStart;
                LspServerManagerImpl lspServerManagerImpl = this.this$0;
                Class<? extends LspServerSupportProvider> clazz = this.$providerClass;
                boolean bl = false;
                for (T t2 : iterable) {
                    LspServerDescriptor lspServerDescriptor = (LspServerDescriptor)t2;
                    boolean bl2 = false;
                    lspServerManagerImpl.ensureServerStarted$intellij_platform_lsp_impl(clazz, lspServerDescriptor);
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresEdt
    public final void ensureServerStarted$intellij_platform_lsp_impl(@NotNull Class<? extends LspServerSupportProvider> providerClass, @NotNull LspServerDescriptor descriptor) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Iterable iterable = this.lspServers;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t2 : iterable) {
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl3 = false;
                    boolean bl4 = Intrinsics.areEqual(lspServerImpl.getProviderClass(), providerClass) && Arrays.equals(lspServerImpl.getDescriptor().getRoots(), descriptor.getRoots());
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (this.lspServers.size() >= 10) {
            LspServerManagerImplKt.access$getLogger$p().error(this.lspServers.size() + " LSP servers are already running and one more wants to start.To save system resources, this request will be ignored: " + descriptor);
            return;
        }
        WriteAction.run(() -> LspServerManagerImpl.o(providerClass, descriptor, this));
    }

    @Override
    public void stopServers(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Iterable iterable = this.getServersForProvider(providerClass);
        boolean bl = false;
        for (Object t2 : iterable) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl2 = false;
            this.stopRunningServer$intellij_platform_lsp_impl(lspServerImpl);
        }
    }

    public final void stopRunningServer$intellij_platform_lsp_impl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        lspServer.ensureServerStopped$intellij_platform_lsp_impl(true, (Function0<Unit>)((Function0)new Function0<Unit>(this, lspServer){
            final /* synthetic */ LspServerManagerImpl this$0;
            final /* synthetic */ LspServerImpl $lspServer;
            {
                this.this$0 = $receiver;
                this.$lspServer = $lspServer;
                super(0);
            }

            public final void invoke() {
                LspServerManagerImpl.access$handleServerStop(this.this$0, this.$lspServer, true);
            }
        }));
    }

    public final void handleMaybeUnexpectedServerStop$intellij_platform_lsp_impl(@NotNull LspServerImpl lspServer, @NotNull String serverOutput) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)serverOutput, (String)"serverOutput");
        lspServer.ensureServerStopped$intellij_platform_lsp_impl(false, (Function0<Unit>)((Function0)new Function0<Unit>(lspServer, serverOutput, this){
            final /* synthetic */ LspServerImpl $lspServer;
            final /* synthetic */ String $serverOutput;
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.$lspServer = $lspServer;
                this.$serverOutput = $serverOutput;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$lspServer.getState() != LspServerState.ShutdownNormally) {
                    this.$lspServer.appendServerErrorOutput$intellij_platform_lsp_impl(this.$serverOutput);
                }
                LspServerManagerImpl.access$handleServerStop(this.this$0, this.$lspServer, false);
            }
        }));
    }

    private final void o(LspServerImpl lspServerImpl, boolean bl) {
        LspServerState[] lspServerStateArray = new LspServerState[]{LspServerState.Initializing, LspServerState.Running};
        if (ArraysKt.contains((Object[])lspServerStateArray, (Object)((Object)lspServerImpl.getState())) && !this.lspServers.contains(lspServerImpl)) {
            LspServerManagerImplKt.access$getLogger$p().error("LspServerManager doesn't know the server that it is asked to stop: " + lspServerImpl);
        }
        if (bl) {
            this.lspServers.remove(lspServerImpl);
        }
        if (lspServerImpl.getState() == LspServerState.Running) {
            this.highlightingQueue.queue(Update.create((Object)this, () -> LspServerManagerImpl.o(this)));
        }
    }

    @Override
    public void stopAndRestartIfNeeded(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        this.stopServers(providerClass);
        this.startServersIfNeeded(providerClass);
    }

    @Override
    @ApiStatus.Internal
    public void addLspServerManagerListener(@NotNull LspServerManagerListener listener, @NotNull Disposable parentDisposable, boolean sendEventsForExistingServers) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)listener, parentDisposable);
        if (sendEventsForExistingServers) {
            for (LspServerImpl lspServerImpl : this.lspServers) {
                if (lspServerImpl.getState() == LspServerState.ShutdownUnexpectedly) {
                    ((LspServerManagerListener)this.eventDispatcher.getMulticaster()).serverStateChanged(lspServerImpl);
                }
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl = false;
                Iterable iterable = LspServerImpl.access$getOpenedFiles$p(lspServerImpl2);
                boolean bl2 = false;
                for (Object t2 : iterable) {
                    VirtualFile virtualFile = (VirtualFile)t2;
                    boolean bl3 = false;
                    ((LspServerManagerListener)this.eventDispatcher.getMulticaster()).fileOpened(lspServerImpl, virtualFile);
                }
            }
        }
    }

    public final void onDiagnosticsReceived$intellij_platform_lsp_impl(@NotNull LspServer lspServer, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ReadAction.run(() -> LspServerManagerImpl.o(this, virtualFile, lspServer));
    }

    public final void scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl() {
        if (this.lspServers.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{this.CLOSE_FILES_COALESCE_OBJECT};
        ReadAction.nonBlocking(() -> LspServerManagerImpl.o(this)).expireWith((Disposable)this).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerManagerImpl.h(scheduleClosingFilesThatAreNotOfInterest.2.INSTANCE, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void o() {
        LspServerSupportProvider.Companion.getEP_NAME().getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LspServerSupportProvider>(this){
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(@NotNull LspServerSupportProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.this$0.startServersIfNeeded(extension.getClass());
            }

            public void extensionRemoved(@NotNull LspServerSupportProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.this$0.stopServers(extension.getClass());
            }
        }, false, (Disposable)this);
    }

    private final void h() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = WorkspaceModel.Companion.getInstance(LspServerManagerImpl.access$getProject$p(this.this$0)).getEventLog().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ LspServerManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull VersionedStorageChange event, @NotNull Continuation<? super Unit> $completion) {
                                if (!((Collection)event.getChanges(ContentRootEntity.class)).isEmpty()) {
                                    Object object = this.this$0.onProjectRootsChanged($completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object onProjectRootsChanged(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Object[] objectArray = FileEditorManager.getInstance((Project)LspServerManagerImpl.access$getProject$p(this.this$0)).getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
                Object[] objectArray2 = objectArray;
                Document[] documentArray = FileDocumentManager.getInstance().getUnsavedDocuments();
                Intrinsics.checkNotNullExpressionValue((Object)documentArray, (String)"getUnsavedDocuments(...)");
                Object[] objectArray3 = documentArray;
                boolean bl = false;
                Object[] objectArray4 = objectArray3;
                Collection collection = new ArrayList<E>();
                boolean bl2 = false;
                Object[] objectArray5 = objectArray4;
                boolean bl3 = false;
                int n10 = objectArray5.length;
                for (int i2 = 0; i2 < n10; ++i2) {
                    VirtualFile virtualFile;
                    Object object;
                    Object object2 = object = objectArray5[i2];
                    boolean bl4 = false;
                    Document document = (Document)object2;
                    boolean bl5 = false;
                    if (FileDocumentManager.getInstance().getFile(document) == null) continue;
                    boolean bl6 = false;
                    collection.add(virtualFile);
                }
                List list = (List)collection;
                LspOpenedFilesService.Companion.getInstance(LspServerManagerImpl.access$getProject$p(this.this$0)).processOpenedFiles(CollectionsKt.plus((Collection)list, (Object[])objectArray2));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void dispose() {
        Iterable iterable = this.lspServers;
        boolean bl = false;
        for (Object t2 : iterable) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl2 = false;
            this.stopRunningServer$intellij_platform_lsp_impl(lspServerImpl);
        }
    }

    private static final List o(LspServerManagerImpl lspServerManagerImpl, Class clazz, LspServerSupportProvider lspServerSupportProvider) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"$providerClass");
        Collection<LspServerImpl> collection = lspServerManagerImpl.getServersForProvider(clazz);
        List list = new ArrayList();
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)lspServerManagerImpl.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        for (VirtualFile virtualFile : virtualFileArray) {
            boolean bl;
            Object object;
            block12: {
                boolean bl2;
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                int n10;
                int n11;
                boolean bl3;
                VirtualFile[] virtualFileArray2;
                boolean bl4;
                Object object2;
                Object t2;
                Iterator iterator;
                boolean bl5;
                boolean bl6;
                block10: {
                    ProgressManager.checkCanceled();
                    if (!virtualFile.isInLocalFileSystem() || !ProjectFileIndex.getInstance((Project)lspServerManagerImpl.project).isInContent(virtualFile)) continue;
                    object = collection;
                    bl6 = false;
                    if (object instanceof Collection && ((Collection)object).isEmpty()) {
                        bl5 = false;
                    } else {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            boolean bl7;
                            block9: {
                                t2 = iterator.next();
                                object2 = (LspServerImpl)t2;
                                bl4 = false;
                                virtualFileArray2 = ((LspServerImpl)object2).getDescriptor().getRoots();
                                bl3 = false;
                                n11 = virtualFileArray2.length;
                                for (n10 = 0; n10 < n11; ++n10) {
                                    virtualFile2 = virtualFile3 = virtualFileArray2[n10];
                                    bl2 = false;
                                    if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)true)) continue;
                                    bl7 = true;
                                    break block9;
                                }
                                bl7 = false;
                            }
                            if (!bl7) continue;
                            bl5 = true;
                            break block10;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) continue;
                object = list;
                bl6 = false;
                if (object instanceof Collection && ((Collection)object).isEmpty()) {
                    bl = false;
                } else {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        boolean bl8;
                        block11: {
                            t2 = iterator.next();
                            object2 = (LspServerDescriptor)t2;
                            bl4 = false;
                            virtualFileArray2 = ((LspServerDescriptor)object2).getRoots();
                            bl3 = false;
                            n11 = virtualFileArray2.length;
                            for (n10 = 0; n10 < n11; ++n10) {
                                virtualFile2 = virtualFile3 = virtualFileArray2[n10];
                                bl2 = false;
                                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)true)) continue;
                                bl8 = true;
                                break block11;
                            }
                            bl8 = false;
                        }
                        if (!bl8) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            object = new LspServerStarterImpl();
            Project project = lspServerManagerImpl.project;
            Intrinsics.checkNotNull((Object)virtualFile);
            lspServerSupportProvider.fileOpened(project, virtualFile, (LspServerSupportProvider.LspServerStarter)object);
            UtilKt.addIfNotNull((List)list, (Object)((LspServerStarterImpl)object).getDescriptor());
        }
        return list;
    }

    private static final void o(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void o(Class clazz, LspServerDescriptor lspServerDescriptor, LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"$providerClass");
        Intrinsics.checkNotNullParameter((Object)lspServerDescriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        LspServerImpl lspServerImpl = new LspServerImpl(clazz, lspServerDescriptor, lspServerManagerImpl.eventBroadcaster);
        lspServerImpl.start$intellij_platform_lsp_impl();
        lspServerManagerImpl.lspServers.add(lspServerImpl);
    }

    private static final void o(LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        DaemonCodeAnalyzer.getInstance((Project)lspServerManagerImpl.project).restart();
    }

    private static final void h(LspServerManagerImpl lspServerManagerImpl, VirtualFile virtualFile, LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"$lspServer");
        if (!FileEditorManager.getInstance((Project)lspServerManagerImpl.project).isFileOpen(virtualFile)) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)lspServerManagerImpl.project).findFile(virtualFile);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        DaemonCodeAnalyzer.getInstance((Project)lspServerManagerImpl.project).restart(psiFile2);
        lspServerManagerImpl.eventBroadcaster.diagnosticsReceived(lspServer, virtualFile);
    }

    private static final void o(LspServerManagerImpl lspServerManagerImpl, VirtualFile virtualFile, LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"$lspServer");
        if (lspServerManagerImpl.project.isDisposed()) {
            return;
        }
        if (!FileEditorManager.getInstance((Project)lspServerManagerImpl.project).isFileOpen(virtualFile)) {
            return;
        }
        if (PsiManager.getInstance((Project)lspServerManagerImpl.project).findFile(virtualFile) == null) {
            LspServerManagerImplKt.access$getLogger$p().debug("Unable to find a PsiFile for " + virtualFile);
            return;
        }
        lspServerManagerImpl.highlightingQueue.queue(Update.create((Object)virtualFile, () -> LspServerManagerImpl.h(lspServerManagerImpl, virtualFile, lspServer)));
    }

    private static final MultiMap o(LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        MultiMap multiMap = new MultiMap();
        for (LspServerImpl lspServerImpl : lspServerManagerImpl.lspServers) {
            Collection<VirtualFile> collection = lspServerImpl.getFilesToClose$intellij_platform_lsp_impl();
            if (collection.isEmpty()) continue;
            multiMap.put((Object)lspServerImpl, collection);
        }
        return multiMap;
    }

    private static final void h(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ void access$handleServerStop(LspServerManagerImpl $this, LspServerImpl lspServer, boolean explicitStop) {
        $this.o(lspServer, explicitStop);
    }

    public static final /* synthetic */ Project access$getProject$p(LspServerManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LspServerManagerImpl $this) {
        return $this.eventDispatcher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion;", "", "()V", "forEachRunningServerInEachProject", "", "action", "Lkotlin/Function1;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "forEachRunningServerInEachProject$intellij_platform_lsp_impl", "getInstanceImpl", "Lcom/intellij/platform/lsp/impl/LspServerManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "isAnyServerRunning", "", "isAnyServerRunning$intellij_platform_lsp_impl", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n13309#2:344\n13310#2:347\n12474#2:348\n12475#2:352\n1855#3,2:345\n1747#3,3:349\n*S KotlinDebug\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n*L\n331#1:344\n331#1:347\n338#1:348\n338#1:352\n332#1:345,2\n339#1:349,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LspServerManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LspServerManager lspServerManager = LspServerManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)lspServerManager, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.impl.LspServerManagerImpl");
            return (LspServerManagerImpl)lspServerManager;
        }

        public final void forEachRunningServerInEachProject$intellij_platform_lsp_impl(@NotNull Function1<? super LspServerImpl, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean bl = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] objectArray = projectArray;
            boolean bl2 = false;
            for (Object object : objectArray) {
                Project project = (Project)object;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)project);
                Iterable iterable = Companion.getInstanceImpl(project).lspServers;
                boolean bl4 = false;
                for (Object t2 : iterable) {
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl5 = false;
                    if (lspServerImpl.getState() != LspServerState.Running) continue;
                    action.invoke((Object)lspServerImpl);
                }
            }
        }

        public final boolean isAnyServerRunning$intellij_platform_lsp_impl() {
            boolean bl;
            block5: {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] objectArray = projectArray;
                boolean bl2 = false;
                for (Object object : objectArray) {
                    boolean bl3;
                    block4: {
                        Project project = (Project)object;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)project);
                        Iterable iterable = Companion.getInstanceImpl(project).lspServers;
                        boolean bl5 = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object t2 : iterable) {
                                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                                boolean bl6 = false;
                                if (!(lspServerImpl.getState() == LspServerState.Running)) continue;
                                bl3 = true;
                                break block4;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl$LspServerStarterImpl;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "()V", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "getDescriptor", "()Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "setDescriptor", "(Lcom/intellij/platform/lsp/api/LspServerDescriptor;)V", "ensureServerStarted", "", "intellij.platform.lsp.impl"})
    public static final class LspServerStarterImpl
    implements LspServerSupportProvider.LspServerStarter {
        @Nullable
        private LspServerDescriptor descriptor;

        @Nullable
        public final LspServerDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final void setDescriptor(@Nullable LspServerDescriptor lspServerDescriptor) {
            this.descriptor = lspServerDescriptor;
        }

        @Override
        public void ensureServerStarted(@NotNull LspServerDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.descriptor = descriptor;
        }
    }
}

