/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.inlay;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.ParameterNameHintsSuppressor;
import com.intellij.lang.Language;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProvider;
import com.intellij.microservices.url.inlay.UrlPathInlaySettingsIntention;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/url/inlay/UrlPathInlayParameterNameHintSuppressor;", "Lcom/intellij/codeInsight/hints/ParameterNameHintsSuppressor;", "()V", "isSuppressedFor", "", "file", "Lcom/intellij/psi/PsiFile;", "inlayInfo", "Lcom/intellij/codeInsight/hints/InlayInfo;", "intellij.microservices"})
public final class UrlPathInlayParameterNameHintSuppressor
implements ParameterNameHintsSuppressor {
    public boolean isSuppressedFor(@NotNull PsiFile file2, @NotNull InlayInfo inlayInfo) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)inlayInfo, (String)"inlayInfo");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!UrlPathInlayHintsProvider.Companion.isUrlPathInlaysEnabledForLanguage$intellij_microservices(language)) {
            return false;
        }
        PsiElement psiElement = file2.findElementAt(inlayInfo.getOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        return UrlPathInlaySettingsIntention.Companion.shouldHaveUrlPathInlayAroundOffset$intellij_microservices(psiElement2, inlayInfo.getOffset(), 3);
    }
}

