/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.HelperUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u001a\b\u0004\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00150\u0014H\u0082\bJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\fJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u001e\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u000f0\u001dR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/microservices/url/UrlResolverManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "all", "", "Lcom/intellij/microservices/url/UrlResolver;", "meaningfulResolvers", "getMeaningfulResolvers$intellij_microservices", "()Ljava/util/List;", "supportedSchemes", "", "getSupportedSchemes", "o", "", "T", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "call", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "getAuthorityHints", "Lcom/intellij/microservices/url/Authority$Exact;", "schema", "getVariants", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "action", "Lkotlin/Function2;", "Companion", "UrlTargetInfoDistinctKey", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlResolverManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlResolverManager.kt\ncom/intellij/microservices/url/UrlResolverManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n25#1,7:106\n25#1,7:113\n25#1,7:120\n1603#2,9:90\n1855#2:99\n1856#2:101\n1612#2:102\n766#2:103\n857#2,2:104\n1#3:100\n*S KotlinDebug\n*F\n+ 1 UrlResolverManager.kt\ncom/intellij/microservices/url/UrlResolverManager\n*L\n35#1:106,7\n40#1:113,7\n58#1:120,7\n10#1:90,9\n10#1:99\n10#1:101\n10#1:102\n12#1:103\n12#1:104,2\n10#1:100\n*E\n"})
public final class UrlResolverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UrlResolver> all;
    @NotNull
    private final List<UrlResolver> meaningfulResolvers;

    public UrlResolverManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = UrlResolverFactory.EP_NAME.getExtensionList();
        UrlResolverManager urlResolverManager = this;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Object object = iterable3.iterator();
        while (object.hasNext()) {
            UrlResolver urlResolver;
            Object t2;
            Object t3 = t2 = object.next();
            boolean bl4 = false;
            UrlResolverFactory urlResolverFactory = (UrlResolverFactory)t3;
            boolean bl5 = false;
            if (urlResolverFactory.forProject(project) == null) continue;
            boolean bl6 = false;
            collection.add(urlResolver);
        }
        urlResolverManager.all = (List)collection;
        iterable = this.all;
        urlResolverManager = this;
        bl = false;
        iterable2 = iterable;
        collection = new ArrayList();
        bl2 = false;
        for (Object e2 : iterable2) {
            object = (UrlResolver)e2;
            boolean bl7 = false;
            if (!(object.getClass().getAnnotation(HelperUrlResolver.class) == null)) continue;
            collection.add(e2);
        }
        urlResolverManager.meaningfulResolvers = (List)collection;
    }

    @NotNull
    public final List<UrlResolver> getMeaningfulResolvers$intellij_microservices() {
        return this.meaningfulResolvers;
    }

    @NotNull
    public final List<Authority.Exact> getAuthorityHints(@Nullable String schema) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends Authority.Exact>>(schema){
            final /* synthetic */ String $schema;
            {
                this.$schema = $schema;
                super(1);
            }

            @NotNull
            public final Sequence<Authority.Exact> invoke(@NotNull UrlResolver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.asSequence((Iterable)it.getAuthorityHints(this.$schema));
            }
        }))));
    }

    @NotNull
    public final List<String> getSupportedSchemes() {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), (Function1)supportedSchemes.1.INSTANCE)));
    }

    private final <T> Iterable<T> o(UrlResolveRequest urlResolveRequest, Function1<? super UrlResolver, ? extends Sequence<? extends T>> function1) {
        boolean bl = false;
        List list = CollectionsKt.listOfNotNull((Object)urlResolveRequest.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), (Function1)new Function1<UrlResolver, Sequence<? extends T>>(list, function1){
            final /* synthetic */ List<String> $schemeHint;
            final /* synthetic */ Function1<UrlResolver, Sequence<T>> $call;
            {
                this.$schemeHint = $schemeHint;
                this.$call = $call;
                super(1);
            }

            @NotNull
            public final Sequence<T> invoke(@NotNull UrlResolver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), (Collection<String>)this.$schemeHint) ? (Sequence)this.$call.invoke((Object)it) : SequencesKt.emptySequence();
            }
        }));
    }

    @NotNull
    public final Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request, @NotNull Function2<? super UrlResolver, ? super UrlResolveRequest, ? extends Iterable<? extends UrlTargetInfo>> action) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        UrlResolverManager urlResolverManager = this;
        boolean bl = false;
        List list = CollectionsKt.listOfNotNull((Object)request.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)urlResolverManager.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(list, action, request){
            final /* synthetic */ List $schemeHint;
            final /* synthetic */ Function2 $action$inlined;
            final /* synthetic */ UrlResolveRequest $request$inlined;
            {
                this.$schemeHint = $schemeHint;
                this.$action$inlined = function2;
                this.$request$inlined = urlResolveRequest;
                super(1);
            }

            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    UrlResolver urlResolver = it;
                    boolean bl = false;
                    sequence = CollectionsKt.asSequence((Iterable)((Iterable)this.$action$inlined.invoke((Object)urlResolver, (Object)this.$request$inlined)));
                } else {
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        })));
    }

    @NotNull
    public final Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UrlResolverManager urlResolverManager = this;
        boolean bl = false;
        List list = CollectionsKt.listOfNotNull((Object)request.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)urlResolverManager.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(list, request){
            final /* synthetic */ List $schemeHint;
            final /* synthetic */ UrlResolveRequest $request$inlined;
            {
                this.$schemeHint = $schemeHint;
                this.$request$inlined = urlResolveRequest;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    sequence = SequencesKt.emptySequence();
                    return sequence;
                }
                UrlResolver urlResolver = it;
                boolean bl = false;
                Sequence sequence2 = CollectionsKt.asSequence(urlResolver.resolve(this.$request$inlined));
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)UrlPath.Companion.getEMPTY(), (Object)this.$request$inlined.getPath())) {
                    Application application = ApplicationManager.getApplication();
                    boolean bl3 = false;
                    boolean bl4 = application.isUnitTestMode() || application.isInternal();
                    if (bl4) {
                        sequence = SequencesKt.map((Sequence)sequence2, (Function1)((Function1)new Function1<UrlTargetInfo, UrlTargetInfo>(this.$request$inlined, urlResolver){
                            final /* synthetic */ UrlResolveRequest $request;
                            final /* synthetic */ UrlResolver $urlResolver;
                            {
                                this.$request = $request;
                                this.$urlResolver = $urlResolver;
                                super(1);
                            }

                            @NotNull
                            public final UrlTargetInfo invoke(@NotNull UrlTargetInfo it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                UrlTargetInfo urlTargetInfo = it;
                                UrlResolveRequest urlResolveRequest = this.$request;
                                UrlResolver urlResolver = this.$urlResolver;
                                UrlTargetInfo urlTargetInfo2 = urlTargetInfo;
                                boolean bl = false;
                                if (urlTargetInfo2.getPath() == urlResolveRequest.getPath()) {
                                    boolean bl2 = false;
                                    Logger logger = Logger.getInstance(UrlResolverManager.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    logger.error("urlResolver of class " + urlResolver.getClass() + " returned the UrlPath(" + urlTargetInfo2.getPath() + ") identical to the requested it is suspicious, because UrlResolvers are expected to return UrlPath built from sources, not the requested one");
                                }
                                return urlTargetInfo;
                            }
                        }));
                        return sequence;
                    }
                }
                sequence = sequence2;
                return sequence;
            }
        })));
    }

    @NotNull
    public final Iterable<UrlTargetInfo> getVariants(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UrlResolverManager urlResolverManager = this;
        boolean bl = false;
        List list = CollectionsKt.listOfNotNull((Object)request.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)urlResolverManager.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(list){
            final /* synthetic */ List $schemeHint;
            {
                this.$schemeHint = $schemeHint;
                super(1);
            }

            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    UrlResolver urlResolver = it;
                    boolean bl = false;
                    sequence = SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence(urlResolver.getVariants()), (Function1)getVariants.1.1.INSTANCE);
                } else {
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        })));
    }

    @JvmStatic
    @NotNull
    public static final UrlResolverManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/microservices/url/UrlResolverManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/microservices/url/UrlResolverManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlResolverManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationManager.getApplication().assertReadAccessAllowed();
            return new UrlResolverManager(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/url/UrlResolverManager$UrlTargetInfoDistinctKey;", "", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "(Lcom/intellij/microservices/url/UrlTargetInfo;)V", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "equals", "", "other", "hashCode", "", "intellij.microservices"})
    private static final class UrlTargetInfoDistinctKey {
        @NotNull
        private final UrlTargetInfo targetInfo;

        public UrlTargetInfoDistinctKey(@NotNull UrlTargetInfo targetInfo) {
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            this.targetInfo = targetInfo;
        }

        @NotNull
        public final UrlTargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlResolverManager.UrlTargetInfoDistinctKey");
            UrlTargetInfoDistinctKey cfr_ignored_0 = (UrlTargetInfoDistinctKey)other;
            if (!Intrinsics.areEqual(this.targetInfo.getMethods(), ((UrlTargetInfoDistinctKey)other).targetInfo.getMethods())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetInfo.getPath(), (Object)((UrlTargetInfoDistinctKey)other).targetInfo.getPath());
        }

        public int hashCode() {
            return Objects.hashCode(this.targetInfo.getPath()) + 31 * Objects.hashCode(this.targetInfo.getMethods());
        }
    }
}

