/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.gotosymbol;

import com.intellij.microservices.gotosymbol.MyConstantRangesMinusculeMatcher;
import com.intellij.microservices.gotosymbol.SegmentMatchResult;
import com.intellij.microservices.gotosymbol.UrlPathMatchResult;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/gotosymbol/ResultFromUrlMatcher;", "Lcom/intellij/microservices/gotosymbol/UrlPathMatchResult;", "score", "", "segments", "", "Lcom/intellij/microservices/gotosymbol/SegmentMatchResult;", "(ILjava/util/List;)V", "getScore", "()I", "getSegments", "()Ljava/util/List;", "compareTo", "other", "toPresentationMatcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "urlPath", "Lcom/intellij/microservices/url/UrlPath;", "intellij.microservices"})
final class ResultFromUrlMatcher
implements UrlPathMatchResult {
    private final int score;
    @NotNull
    private final List<SegmentMatchResult> segments;

    public ResultFromUrlMatcher(int score, @NotNull List<SegmentMatchResult> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.score = score;
        this.segments = segments;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @NotNull
    public final List<SegmentMatchResult> getSegments() {
        return this.segments;
    }

    @Override
    public int compareTo(@NotNull UrlPathMatchResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.getScore(), (int)other.getScore());
    }

    @Override
    @NotNull
    public MinusculeMatcher toPresentationMatcher(@NotNull UrlPath urlPath) {
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull(urlPath.getSegments());
        int n10 = (pathSegment != null ? pathSegment.isEmpty() : false) ? 0 : 1;
        int n11 = 0;
        FList fList = FList.emptyList();
        int n12 = urlPath.getSegments().size();
        for (int i2 = 0; i2 < n12 && n11 <= CollectionsKt.getLastIndex(this.segments); ++i2) {
            if (i2 == this.segments.get(n11).getSegmentIndex()) {
                for (TextRange textRange : this.segments.get(n11).getRangesInSegment()) {
                    fList = fList.prepend((Object)textRange.shiftRight(n10));
                }
                ++n11;
            }
            n10 += UrlPath.FULL_PATH_VARIABLE_PRESENTATION.patternMatch(urlPath.getSegments().get(i2)).length() + 1;
        }
        FList fList2 = FList.createFromReversed((Iterable)((Iterable)fList));
        Intrinsics.checkNotNullExpressionValue((Object)fList2, (String)"createFromReversed(...)");
        return new MyConstantRangesMinusculeMatcher((FList<TextRange>)fList2, "/" + urlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION));
    }
}

