/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.ide.o.c.ew;
import com.intellij.ide.o.y;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.BrowserLink;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ls.responses.ObtainUserIdResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.o.o.k;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloudConfigLoginDialog
extends DialogWrapper {
    private static final Logger LOG;
    private final JTextField myLoginField;
    private final JTextField myPasswordField;
    private final BrowserLink myForgotLink;
    private final JProgressBar myProgress;
    private final String myInitialLogin;
    private @NlsContexts.DialogMessage String myServerError;
    private ProgressIndicator myIndicator;
    private static final long a;

    public CloudConfigLoginDialog(boolean checkChangeName) {
        long l2 = a ^ 0x7E6B528D65EAL;
        long l3 = l2 ^ 0x268F820EFC35L;
        super(false);
        this.myLoginField = new JTextField(18);
        this.myPasswordField = new JPasswordField(18);
        this.myForgotLink = new BrowserLink(y.o("label.forgot", l3, new Object[0]), "https://account.jetbrains.com/secured/ForgotPasswordForm");
        this.myProgress = new JProgressBar(0);
        this.setTitle(y.o("dialog.title.log.in.to.jetbrains.account", l3, new Object[0]));
        this.getOKAction().putValue("Name", y.o("button.log.in", l3, new Object[0]));
        this.getOKAction().setEnabled(false);
        String string = CloudConfigClientUtil.getUserLogin();
        this.myInitialLogin = checkChangeName ? StringUtil.defaultIfEmpty((String)string, null) : null;
        this.myLoginField.setText(string);
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    1.o(0);
                }
                CloudConfigLoginDialog.this.myPasswordField.getDocument().removeDocumentListener((DocumentListener)((Object)this));
                CloudConfigLoginDialog.this.initValidation();
                CloudConfigLoginDialog.this.getOKAction().setEnabled(!CloudConfigLoginDialog.this.myPasswordField.getText().isEmpty());
            }

            private static /* synthetic */ void o(int n10) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/idea/cloudConfig/CloudConfigLoginDialog$1", "textChanged"));
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myProgress);
        this.myProgress.setIndeterminate(true);
        this.myProgress.setVisible(false);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        long l2 = a ^ 0x72729CCE3342L;
        long l3 = l2 ^ 0x2A964C4DAA9DL;
        FormBuilder formBuilder = FormBuilder.createFormBuilder();
        formBuilder.addLabeledComponent(y.o("label.username", l3, new Object[0]), (JComponent)this.myLoginField);
        formBuilder.addLabeledComponent(y.o("label.password", l3, new Object[0]), (JComponent)this.myPasswordField);
        formBuilder.addComponent((JComponent)this.myForgotLink);
        formBuilder.addComponent((JComponent)this.myProgress);
        return formBuilder.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLoginField.getText().isEmpty() ? this.myLoginField : this.myPasswordField;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        long l2 = a ^ 0x7315F1792CFBL;
        long l3 = l2 ^ 0x2BF121FAB524L;
        ArrayList<ValidationInfo> arrayList = new ArrayList<ValidationInfo>();
        String string = this.myLoginField.getText();
        if (StringUtil.isEmpty((String)string)) {
            arrayList.add(new ValidationInfo(y.o("validation.message.username.cannot.be.empty", l3, new Object[0]), (JComponent)this.myLoginField));
        } else if (this.myInitialLogin != null && !this.myInitialLogin.equals(string)) {
            arrayList.add(new ValidationInfo(y.o("validation.message.change.the.username", l3, new Object[0]), (JComponent)this.myLoginField).asWarning());
        }
        if (this.myPasswordField.getText().isEmpty()) {
            arrayList.add(new ValidationInfo(y.o("validation.message.password.cannot.be.empty", l3, new Object[0]), (JComponent)this.myPasswordField));
        }
        if (this.myServerError != null) {
            arrayList.add(new ValidationInfo(this.myServerError).withOKEnabled());
        }
        ArrayList<ValidationInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CloudConfigLoginDialog.o(0);
        }
        return arrayList2;
    }

    protected void doOKAction() {
        long l2 = a ^ 0x2094A6864581L;
        long l3 = l2 ^ 0x78707605DC5EL;
        final String string = this.myLoginField.getText();
        final String string2 = this.myPasswordField.getText();
        final boolean bl = this.myLoginField.isEditable();
        this.myLoginField.setEditable(false);
        this.myPasswordField.setEditable(false);
        this.myForgotLink.setEnabled(false);
        this.myProgress.setVisible(true);
        this.getOKAction().setEnabled(false);
        this.myServerError = null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, y.o("task.title.authorization.to.jetbrains.account", l3, new Object[0])){
            @NlsContexts.DialogMessage String error;

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.o(0);
                }
                CloudConfigLoginDialog.this.o(indicator2);
                this.error = CloudConfigLoginDialog.o(string, string2);
            }

            public void onFinished() {
                CloudConfigLoginDialog.this.o(null);
                CloudConfigLoginDialog.this.myProgress.setVisible(false);
                CloudConfigLoginDialog.this.myLoginField.setEditable(bl);
                CloudConfigLoginDialog.this.myPasswordField.setEditable(true);
                CloudConfigLoginDialog.this.myForgotLink.setEnabled(true);
                CloudConfigLoginDialog.this.getOKAction().setEnabled(true);
                if (this.error == null) {
                    CloudConfigLoginDialog.super.doOKAction();
                } else {
                    CloudConfigLoginDialog.this.myServerError = this.error;
                }
            }

            private static /* synthetic */ void o(int n10) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/idea/cloudConfig/CloudConfigLoginDialog$2", "run"));
            }
        });
    }

    public void doCancelAction() {
        ProgressIndicator progressIndicator = this.o();
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        super.doCancelAction();
    }

    @Nullable
    private synchronized ProgressIndicator o() {
        return this.myIndicator;
    }

    private synchronized void o(@Nullable ProgressIndicator progressIndicator) {
        this.myIndicator = progressIndicator;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String o(@NotNull String string, @NotNull String string2) {
        long l2;
        long l3 = l2 = a ^ 0x3DCB082EB741L;
        long l4 = l3 ^ 0x17BFA1B92CD0L;
        long l5 = l3 ^ 0x652FD8AD2E9EL;
        if (string == null) {
            CloudConfigLoginDialog.o(1);
        }
        if (string2 == null) {
            CloudConfigLoginDialog.o(2);
        }
        try {
            ObtainUserIdResponse obtainUserIdResponse = k.o(string, l4, string2);
            if (obtainUserIdResponse.getResponseCode() == ResponseCode.OK) {
                CloudConfigClientUtil.setUserAndId(string, obtainUserIdResponse.getUserId());
                return null;
            }
            return y.o("dialog.message.authorization.failed", l5, obtainUserIdResponse.getMessage());
        }
        catch (Exception exception) {
            LOG.info((Throwable)exception);
            return y.o("dialog.message.jetbrains.account.communication.error", l5, exception.getMessage());
        }
    }

    static {
        a = ew.a(-6246906065859394295L, 8683374377289883935L, MethodHandles.lookup().lookupClass()).a(237138143603978L);
        LOG = Logger.getInstance(CloudConfigLoginDialog.class);
    }

    private static /* synthetic */ void o(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/cloudConfig/CloudConfigLoginDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "login";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/cloudConfig/CloudConfigLoginDialog";
                break;
            }
        }
        switch (n10) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUserId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

