/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;

@ApiStatus.Internal
public final class JpsGlobalSettingsLoading {
    public static final String SDK_TABLE_COMPONENT_NAME = "ProjectJdkTable";
    private static final JpsGlobalExtensionSerializer[] SERIALIZERS = new JpsGlobalExtensionSerializer[]{new GlobalLibrariesSerializer(), new SdkTableSerializer(), JpsGlobalLoader.FILE_TYPES_SERIALIZER};

    private JpsGlobalSettingsLoading() {
    }

    public static void loadGlobalSettings(JpsGlobal global, String optionsPath) throws IOException {
        JpsGlobalLoader.configurePathMapper(global);
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        Map<String, String> pathVariables = JpsGlobalSettingsLoading.loadPathVariables(global, optionsDir);
        JpsGlobalSettingsLoading.createInstance(global, pathVariables).load(optionsDir);
    }

    @NotNull
    private static JpsGlobalLoader createInstance(JpsGlobal global, Map<String, String> pathVariables) {
        return new JpsGlobalLoader(new JpsMacroExpander(pathVariables), global, SERIALIZERS);
    }

    public static Map<String, String> loadPathVariables(JpsGlobal global, Path optionsDir) {
        JpsGlobalSettingsLoading.createInstance(global, Collections.emptyMap()).loadGlobalComponents(optionsDir, optionsDir.resolve("other.xml"), new JpsGlobalLoader.PathVariablesSerializer());
        return JpsModelSerializationDataService.computeAllPathVariables(global);
    }

    public static Map<String, String> computeAllPathVariables(@NotNull String optionsPath) {
        if (optionsPath == null) {
            JpsGlobalSettingsLoading.$$$reportNull$$$0(0);
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        return JpsGlobalSettingsLoading.loadPathVariables(model.getGlobal(), optionsDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsPath", "org/jetbrains/jps/model/serialization/JpsGlobalSettingsLoading", "computeAllPathVariables"));
    }

    public static final class GlobalLibrariesSerializer
    extends JpsGlobalExtensionSerializer {
        public GlobalLibrariesSerializer() {
            super("applicationLibraries.xml", "libraryTable");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                GlobalLibrariesSerializer.$$$reportNull$$$0(1);
            }
            JpsLibraryTableSerializer.loadLibraries(componentTag, global.getPathMapper(), global.getLibraryCollection());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "global";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/serialization/JpsGlobalSettingsLoading$GlobalLibrariesSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class SdkTableSerializer
    extends JpsGlobalExtensionSerializer {
        public SdkTableSerializer() {
            super("jdk.table.xml", JpsGlobalSettingsLoading.SDK_TABLE_COMPONENT_NAME);
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                SdkTableSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                SdkTableSerializer.$$$reportNull$$$0(1);
            }
            JpsSdkTableSerializer.loadSdks(componentTag, global.getLibraryCollection(), global.getPathMapper());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "global";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/serialization/JpsGlobalSettingsLoading$SdkTableSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

