/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeLauncher;
import com.jetbrains.cidr.cpp.execution.ExplicitBuildTargetHolder;
import com.jetbrains.cidr.cpp.execution.testing.CMakeTestRunConfiguration;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestProjectTestsUpdater;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestUtil;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestCommandLineState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestConsoleProperties;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.ElevationOptions;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData<?>> FACTORY = CidrCTestRunConfigurationData::new;
    @NonNls
    public static final String FRAMEWORK_ID = "CTest";
    private final HashMap<String, CMakeAppRunConfiguration> myTestName2Config;
    @Nullable
    private volatile transient List<CidrCTestProjectTestInfo> myInfos;
    private static final String[] FILTER_OPTIONS = new String[]{"-L", "--label-regex", "-R", "--tests-regex", "-E", "--exclude-regex", "-LE", "--label-exclude"};

    public CidrCTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myTestName2Config = new HashMap();
    }

    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        String string = this.myTestName;
        if (string == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        String scopePattern = scope.getPattern();
        if (this.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN) {
            return Objects.equals(this.getTestPattern(), scopePattern);
        }
        if (this.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST) {
            return Objects.equals(CidrTestScopeElementImpl.createTestScopeElementForSuiteAndTest((String)this.myTestSuite, (String)this.myTestName, CTestUtil.GENERATOR).getPattern(), scope.getPattern());
        }
        return false;
    }

    public void checkData() {
        Project project = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn((Project)project)) {
            return;
        }
        if (this.myTestName == null && this.myTestSuite == null) {
            return;
        }
    }

    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    @Nullable
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        if (env == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && executor instanceof DefaultDebugExecutor) {
            List<Object> testList;
            Project project = this.myConfiguration.getProject();
            CidrCTestProjectState service = (CidrCTestProjectState)project.getService(CidrCTestProjectState.class);
            if (!service.hasValidTestDescriptors()) {
                testList = Collections.emptyList();
            } else if (failedTests != null) {
                testList = failedTests.getAsPatternList();
            } else {
                CidrTestRunConfigurationData data = this.myConfiguration.getTestData();
                if (data.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST) {
                    testList = data.getTestName() == null ? CidrCTestRunConfigurationData.getAllTests(service) : Collections.singletonList(data.getTestName());
                } else {
                    String pattern = data.getTestPattern();
                    if (pattern == null) {
                        testList = CidrCTestRunConfigurationData.getAllTests(service);
                    } else {
                        CidrTestScope scope = CidrCTestCommandLineState.EMPTY_TEST_SCOPE_PRODUCER.get();
                        scope.addPattern(pattern);
                        testList = scope.getAsPatternList();
                    }
                }
            }
            RelativePoint point = (RelativePoint)CTestProjectTestsUpdater.DEBUG_TEST_SELECTION_DLG_POINT.get((UserDataHolder)project);
            CTestProjectTestsUpdater.DEBUG_TEST_SELECTION_DLG_POINT.set((UserDataHolder)project, null);
            String testForDebug = testList.size() == 1 ? testList.get(0) : CidrCTestRunConfigurationData.selectTestInModalLoop(testList, point);
            if (testForDebug != null) {
                return this.createDebugCommandLineState(env, testForDebug);
            }
            return null;
        }
        return new CidrCTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @NotNull
    private static List<String> getAllTests(@NotNull CidrCTestProjectState service) {
        if (service == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.map(service.getTests(), CidrCTestProjectTestInfo::getTestName);
        if (list == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static String selectTestInModalLoop(@NotNull List<String> testList, @Nullable RelativePoint point) {
        if (testList == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        Ref selected = Ref.create();
        boolean ignoreSelection = testList.isEmpty();
        if (ignoreSelection) {
            testList = Collections.singletonList(CidrCTestBundle.message("ctest.no.available.tests.for.debug", new Object[0]));
        }
        JBPopup dlg = JBPopupFactory.getInstance().createPopupChooserBuilder(testList).setSelectionMode(0).setTitle(CidrCTestBundle.message("popup.title.select.test.for.debug", new Object[0])).setAutoselectOnMouseMove(false).setMovable(true).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemChosenCallback(arg_0 -> ((Ref)selected).set(arg_0)).setModalContext(true).createPopup();
        if (point == null) {
            dlg.showInFocusCenter();
        } else {
            dlg.show(point);
        }
        while (!dlg.isDisposed()) {
            IdeEventQueue.getInstance().flushQueue();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return ignoreSelection ? null : (String)selected.get();
    }

    @NotNull
    private CidrCommandLineState createDebugCommandLineState(@NotNull ExecutionEnvironment env, @NotNull String testName) {
        if (env == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(8);
        }
        if (testName == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(9);
        }
        CMakeAppRunConfiguration debugConfiguration = this.getOrCreateDebugConfiguration(testName);
        CMakeLauncher launcher = new CMakeLauncher(env, debugConfiguration);
        return new CidrCommandLineState(env, (CidrLauncher)launcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CMakeAppRunConfiguration getOrCreateDebugConfiguration(@NotNull String testName) {
        if (testName == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(10);
        }
        CidrTestRunConfiguration configuration = this.myConfiguration;
        HashMap<String, CMakeAppRunConfiguration> hashMap = this.myTestName2Config;
        // MONITORENTER : hashMap
        CMakeAppRunConfiguration dbgConf = this.myTestName2Config.get(testName);
        if (dbgConf == null) {
            String explicitTarget;
            BuildTargetAndConfigurationData data;
            dbgConf = (CMakeAppRunConfiguration)CMakeAppRunConfigurationType.getInstance().getFactory().createTemplateConfiguration(configuration.getProject());
            boolean foundBuildTarget = false;
            if (configuration instanceof CMakeAppRunConfiguration && (data = ((CMakeAppRunConfiguration)configuration).getTargetAndConfigurationData()) != null && data.target != null) {
                dbgConf.setTargetAndConfigurationData(data);
                foundBuildTarget = true;
            }
            if (!foundBuildTarget && configuration instanceof ExplicitBuildTargetHolder && (explicitTarget = ((ExplicitBuildTargetHolder)configuration).getExplicitBuildTargetName()) != null) {
                dbgConf.setExplicitBuildTargetName(explicitTarget);
                foundBuildTarget = true;
            }
            if (!foundBuildTarget) {
                dbgConf.setExplicitBuildTargetName("all");
            }
            dbgConf.setName(CidrCTestBundle.message("ctest.run.configuration.debug.pattern", testName));
            if (configuration instanceof ElevationOptions) {
                ElevationOptions elevationOptions = (ElevationOptions)configuration;
                dbgConf.setElevated(elevationOptions.isElevated());
            }
            if (configuration instanceof InputRedirectAware.InputRedirectOptions) {
                InputRedirectAware.InputRedirectOptions redirectOptions = (InputRedirectAware.InputRedirectOptions)configuration;
                dbgConf.setRedirectInput(redirectOptions.isRedirectInput());
                dbgConf.setRedirectInputPath(redirectOptions.getRedirectInputPath());
            }
            this.myTestName2Config.put(testName, dbgConf);
        }
        CMakeAppRunConfiguration cMakeAppRunConfiguration = dbgConf;
        // MONITOREXIT : hashMap
        if (cMakeAppRunConfiguration != null) return cMakeAppRunConfiguration;
        CidrCTestRunConfigurationData.$$$reportNull$$$0(11);
        return cMakeAppRunConfiguration;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (executor == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(12);
        }
        if (target == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(13);
        }
        return new CidrCTestConsoleProperties((RunConfiguration)this.myConfiguration, executor, target);
    }

    public void prepareTestList(@NotNull ExecutionTarget executionTarget, @NotNull ProgressIndicator progress) {
        CMakeTestRunConfiguration configuration;
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations;
        CidrTestRunConfiguration cidrTestRunConfiguration;
        if (executionTarget == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(14);
        }
        if (progress == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(15);
        }
        if ((cidrTestRunConfiguration = this.myConfiguration) instanceof CMakeTestRunConfiguration && (configurations = (configuration = (CMakeTestRunConfiguration)cidrTestRunConfiguration).getBuildAndRunConfigurations(executionTarget)) != null) {
            try {
                progress.setText2(CidrCTestBundle.message("test.before.run.prepare.list.start", new Object[0]));
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(CidrCTestRunConfigurationData.getRegexpParams(configuration));
                params.addAll(CidrCTestCommandLineState.getTestListParams(configuration, configurations.buildConfiguration));
                List<CidrCTestProjectTestInfo> infos = CTestUtil.getInfos(configuration.getProject(), progress, configurations.buildConfiguration, params);
                if (infos != null) {
                    this.updateDbgConfigures(infos);
                    progress.setText2(CidrCTestBundle.message("test.before.run.prepare.list.finished", new Object[0]));
                } else {
                    progress.setText2(CidrCTestBundle.message("test.before.run.prepare.list.failed", new Object[0]));
                }
                this.myInfos = infos;
            }
            catch (ExecutionException e) {
                progress.setText2(e.getMessage());
                progress.cancel();
            }
        }
    }

    @NotNull
    private static List<String> getRegexpParams(@NotNull CMakeTestRunConfiguration configuration) {
        String parameters;
        if (configuration == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(16);
        }
        if ((parameters = configuration.getProgramParameters()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CidrCTestRunConfigurationData.$$$reportNull$$$0(17);
            }
            return list;
        }
        List switches = ParametersListUtil.parse((String)parameters);
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < switches.size(); ++i) {
            String option = (String)switches.get(i);
            for (String filterOption : FILTER_OPTIONS) {
                if (!filterOption.equals(option) || i + 1 >= switches.size()) continue;
                params.add(option);
                params.add((String)switches.get(++i));
            }
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDbgConfigures(@NotNull List<CidrCTestProjectTestInfo> infos) {
        if (infos == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(19);
        }
        HashMap<String, CMakeAppRunConfiguration> hashMap = this.myTestName2Config;
        synchronized (hashMap) {
            if (this.myTestName2Config.isEmpty()) {
                return;
            }
            for (CidrCTestProjectTestInfo info : infos) {
                String testName = info.getTestName();
                CMakeAppRunConfiguration dbgConf = this.myTestName2Config.get(testName);
                if (dbgConf == null) continue;
                GeneralCommandLine command = info.getCommand();
                if (command != null) {
                    CidrCTestRunConfigurationData.updateDbgConfig(dbgConf, command);
                }
                this.myTestName2Config.remove(testName);
                if (!this.myTestName2Config.isEmpty()) continue;
                return;
            }
            this.myTestName2Config.clear();
        }
    }

    private static void updateDbgConfig(@NotNull CMakeAppRunConfiguration dbgConf, @NotNull GeneralCommandLine command) {
        if (dbgConf == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(20);
        }
        if (command == null) {
            CidrCTestRunConfigurationData.$$$reportNull$$$0(21);
        }
        dbgConf.setExecutableData(new ExecutableData(command.getExePath()));
        dbgConf.setProgramParameters(command.getParametersList().getParametersString());
        dbgConf.setWorkingDirectory(command.getWorkDirectory().getPath());
        dbgConf.getEnvs().putAll(command.getEnvironment());
    }

    @Nullable
    public List<CidrCTestProjectTestInfo> getTestListCopy() {
        return this.myInfos == null ? null : new ArrayList<CidrCTestProjectTestInfo>(this.myInfos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 11, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testList";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionTarget";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbgConf";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTests";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDebugConfiguration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegexpParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllTests";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectTestInModalLoop";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDebugCommandLineState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDebugConfiguration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRegexpParams";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateDbgConfigures";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateDbgConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 11, 17, 18 -> new IllegalStateException(string);
        };
    }
}

