/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.cmake.CMakeToolExecutableMacro;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.testing.CMakeTestRunConfiguration;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestProjectTestsUpdater;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestLocation;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonModel;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonModelUtil;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CTestUtil {
    public static final Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> GENERATOR = CidrTestScopeElementImpl.DefaultPropertiesGenerator::new;
    static final Logger LOG = Logger.getInstance(CTestProjectTestsUpdater.class);
    @NonNls
    private static final String TESTS_NO_FOUND = "No tests were found!!!";
    public static final Version API_MIN_CTEST_VERSION = new Version(3, 14, -1);

    private CTestUtil() {
    }

    public static PsiElement getCMakeListElement(@NotNull Project project, @NotNull String locationPath) {
        PsiFile psiFile;
        VirtualFile vcml;
        CidrCTestProjectTestLocation location;
        CidrCTestProjectTestInfo info;
        if (project == null) {
            CTestUtil.$$$reportNull$$$0(0);
        }
        if (locationPath == null) {
            CTestUtil.$$$reportNull$$$0(1);
        }
        if ((info = ((CidrCTestProjectState)project.getService(CidrCTestProjectState.class)).geTestInfo(locationPath)) != null && (location = info.getLocation()) != null && (vcml = VirtualFileManager.getInstance().findFileByNioPath(location.getFilePath())) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(vcml)) != null) {
            Document document = psiFile.getViewProvider().getDocument();
            if (document != null) {
                int offset;
                PsiElement at;
                int line = location.getLine();
                if (line >= document.getLineCount()) {
                    line = document.getLineCount() - 1;
                }
                if ((at = psiFile.findElementAt(offset = DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)line))) != null) {
                    return at;
                }
            }
            return psiFile;
        }
        Path path = CMakeWorkspace.getInstance((Project)project).getProjectPath().toAbsolutePath().resolve("CMakeLists.txt");
        vcml = VirtualFileManager.getInstance().findFileByNioPath(path);
        return PsiManager.getInstance((Project)project).findFile(vcml);
    }

    @NonNls
    @Contract(pure=true)
    @NotNull
    public static String getCTestWorkingDirectoryMacro() {
        return "$CMakeCurrentLocalGenerationDir$";
    }

    @Nullable
    public static List<CidrCTestProjectTestInfo> getInfos(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull CMakeConfiguration configuration, @NotNull List<String> params) throws ExecutionException {
        GeneralCommandLine commandLine;
        CMakeExecutableTool ctest;
        if (project == null) {
            CTestUtil.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            CTestUtil.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            CTestUtil.$$$reportNull$$$0(4);
        }
        if (params == null) {
            CTestUtil.$$$reportNull$$$0(5);
        }
        if ((ctest = CMakeToolExecutableMacro.getCMakeExecutableTool((CMakeConfiguration)configuration, (Project)project, (CMakeExecutableTool.ToolKind)CMakeExecutableTool.ToolKind.CTEST)) == null) {
            LOG.info("Cannot update CTest project, CTest not found.");
            return null;
        }
        ToolVersion version = ctest.readToolVersion();
        if (version == null || API_MIN_CTEST_VERSION.compareTo(version.versionNumber) > 0) {
            LOG.warn("Cannot update CTest project, CTest version must be at least 3.14. Current version is " + (Serializable)((Object)(version == null ? "undefined" : version.versionNumber)) + ".");
            return null;
        }
        CPPEnvironment env = ctest.getEnv();
        try {
            commandLine = new GeneralCommandLine().withParameters(new String[]{"--show-only=json-v1"}).withParameters(params).withWorkDirectory(MacroManager.getInstance().expandSilentMacros(CTestUtil.getCTestWorkingDirectoryMacro(), true, SimpleDataContext.getProjectContext((Project)project)));
            if (commandLine.getWorkDirectory() != null && !commandLine.getWorkDirectory().exists()) {
                LOG.warn(CidrCTestBundle.message("ctest.error.ctest.no.working.dir", new Object[0]));
                return null;
            }
        }
        catch (Macro.ExecutionCancelledException e) {
            LOG.warn(CidrCTestBundle.message("ctest.error.ctest.no.working.dir", new Object[]{e}));
            return null;
        }
        ProcessOutput output = ctest.executeWithOutput(commandLine, indicator, -1);
        if (output == null) {
            LOG.warn(CidrCTestBundle.message("ctest.error.ctest.execution", new Object[0]));
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.warn(CidrCTestBundle.message("ctest.error.bad.ctest.exit.code", output.getExitCode()));
            return null;
        }
        if (output.getStdout().contains(TESTS_NO_FOUND) || output.getStderr().contains(TESTS_NO_FOUND)) {
            return null;
        }
        CTestJsonModel model = CTestJsonModelUtil.parseModel(output.getStdout());
        if (model == null) {
            LOG.warn(CidrCTestBundle.message("ctest.error.json.parsing", new Object[0]));
            return null;
        }
        return ContainerUtil.map(CTestJsonModelUtil.getTestsInfo(model), test -> {
            CidrCTestProjectTestLocation location = test.getLocation();
            GeneralCommandLine command = test.getCommand();
            if (env.isCygwin() && command != null) {
                command.withExePath(env.toLocalPath(command.getExePath()));
                if (command.getWorkDirectory() != null) {
                    command.withWorkDirectory(env.toLocalPath(FileUtil.toSystemIndependentName((String)command.getWorkDirectory().toString())));
                }
            }
            return new CidrCTestProjectTestInfo(test.getTestNumber(), test.getTestName(), location == null ? null : new CidrCTestProjectTestLocation(env.toLocalPath(FileUtil.toSystemIndependentName((String)location.getFilePath().toString())), location.getLine()), command);
        });
    }

    static void createDefaultRunConfigurationForTests(@NotNull Project project) {
        String messageId;
        PropertiesComponent projectProperties;
        if (project == null) {
            CTestUtil.$$$reportNull$$$0(6);
        }
        if ((projectProperties = PropertiesComponent.getInstance((Project)project)).getBoolean(messageId = "ctest.advertisement.all.test.configuration.is.created")) {
            return;
        }
        projectProperties.setValue(messageId, true);
        RunManagerImpl runManager = (RunManagerImpl)RunManagerEx.getInstanceEx((Project)project);
        if (ContainerUtil.exists((Iterable)runManager.getAllConfigurationsList(), conf -> {
            if (conf instanceof CMakeTestRunConfiguration && CTestAppRunConfigurationType.getInstance() == conf.getType()) {
                CidrTestRunConfigurationData data = ((CMakeTestRunConfiguration)conf).getTestData();
                return data.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST && data.getTestSuite() == null && data.getTestName() == null;
            }
            return false;
        })) {
            return;
        }
        RunnerAndConfigurationSettings configuration = runManager.createConfiguration(CidrCTestBundle.message("test.defaultName.allTests", new Object[0]), CTestAppRunConfigurationType.getInstance().getFactory());
        runManager.addConfiguration(configuration);
    }

    private static void advertise(@NotNull Project project, @NlsContexts.Tooltip @NotNull String advertisement) {
        if (project == null) {
            CTestUtil.$$$reportNull$$$0(7);
        }
        if (advertisement == null) {
            CTestUtil.$$$reportNull$$$0(8);
        }
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project).addRequest(() -> {
            BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(advertisement));
            AnAction configuration = ActionManager.getInstance().getAction("RunConfiguration");
            if (configuration instanceof RunConfigurationsComboBoxAction) {
                try {
                    Field f = RunConfigurationsComboBoxAction.class.getDeclaredField("myButton");
                    f.setAccessible(true);
                    Object value = f.get(configuration);
                    if (value instanceof JComponent) {
                        JComponent anchor = (JComponent)value;
                        Balloon balloon = builder.setCalloutShift(anchor.getHeight() / 2).setDisposable((Disposable)project).setHideOnClickOutside(true).createBalloon();
                        balloon.showInCenterOf(anchor);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOG.warn("class RunConfigurationsComboBoxAction was changed", (Throwable)e);
                }
            }
        }, 500, ModalityState.nonModal());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "advertisement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCMakeListElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfos";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultRunConfigurationForTests";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "advertise";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

