/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.navigation.OCGotoClassContributor;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClassChooserDialog
extends AbstractTreeClassChooserDialog<OCSymbolHolderVirtualPsiElement> {
    private Condition<OCSymbol> mySymbolCondition;

    public OCClassChooserDialog(@NlsContexts.DialogTitle String title, Project project, TreeChooser.Filter<OCSymbolHolderVirtualPsiElement> filter, @Nullable OCSymbolHolderVirtualPsiElement initialClass, Condition<OCSymbol> symbolCondition) {
        super(title, project, OCSearchScope.getProjectSourcesScope(project), OCSymbolHolderVirtualPsiElement.class, filter, null, (PsiNamedElement)initialClass, false, false);
        this.mySymbolCondition = symbolCondition;
    }

    @Nullable
    protected OCSymbolHolderVirtualPsiElement getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile psiFile2 = (PsiFile)((PsiFileNode)userObject).getValue();
        OCSymbolDeclarator firstClass = psiFile2 instanceof OCFile ? ((OCFile)psiFile2).findFirstClass() : null;
        OCSymbol symbol = firstClass != null ? (OCSymbol)firstClass.getSymbol() : null;
        return symbol != null && this.mySymbolCondition.value(symbol) ? new OCSymbolHolderVirtualPsiElement(symbol, psiFile2.getProject()) : null;
    }

    @NotNull
    protected List<OCSymbolHolderVirtualPsiElement> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        Project project = this.getProject();
        GlobalSearchScope scope = searchScope.intersectWith(OCSearchScope.getGotoSymbolScope(project, checkBoxState));
        ArrayList<OCSymbolHolderVirtualPsiElement> result = new ArrayList<OCSymbolHolderVirtualPsiElement>();
        new OCGotoClassContributor().processSymbolsByName(name, (Processor<? super OCSymbolNavigationItem>)((Processor)o -> {
            OCSymbol symbol = o.getSymbol();
            result.add(new OCSymbolHolderVirtualPsiElement(symbol, this.getProject()));
            return true;
        }), project, scope, this.mySymbolCondition, true);
        ArrayList<OCSymbolHolderVirtualPsiElement> arrayList = result;
        if (arrayList == null) {
            OCClassChooserDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/ui/OCClassChooserDialog", "getClassesByName"));
    }
}

