/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructType
extends OCType {
    @NotNull
    private List<OCStructSymbol> myStructs;
    @Nullable
    private String myTypedefName;
    @Nullable
    private List<OCTypeArgument> myArguments;

    public OCStructType() {
    }

    public OCStructType(@NotNull OCStructSymbol structs) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(0);
        }
        this(structs, null);
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(1);
        }
        this.myStructs = structs;
        this.myTypedefName = null;
    }

    public OCStructType(@NotNull OCStructSymbol structs, @Nullable String typedefName) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(2);
        }
        this.myStructs = Collections.singletonList(structs);
        this.myTypedefName = typedefName;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, @Nullable List<OCTypeArgument> arguments) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(3);
        }
        this(structs, typedefName, false, false);
        this.myArguments = arguments;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile, @Nullable List<OCTypeArgument> arguments) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(4);
        }
        this(structs, typedefName, isConst, isVolatile);
        this.myArguments = arguments;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile) {
        if (structs == null) {
            OCStructType.$$$reportNull$$$0(5);
        }
        super(isConst, isVolatile);
        this.myStructs = structs;
        this.myTypedefName = typedefName;
    }

    @NotNull
    public Collection<OCSymbol> collectMethods(@NotNull String methodName, OCResolveContext context) {
        if (methodName == null) {
            OCStructType.$$$reportNull$$$0(6);
        }
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processMembers(methodName, (Processor<? super OCSymbol>)collector, context);
        Collection collection = collector.getResults();
        if (collection == null) {
            OCStructType.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCStructType.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCStructType.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCStructType.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructType f = (OCStructType)first;
        OCStructType s = (OCStructType)second;
        if (!Objects.equals(f.myTypedefName, s.myTypedefName)) {
            return false;
        }
        return c.equalLists(f.myStructs, s.myStructs);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myStructs.get(0).hashCode();
    }

    public List<OCStructSymbol> getStructs() {
        return this.myStructs;
    }

    @Nullable
    public String getTypedefName() {
        return this.myTypedefName;
    }

    @NotNull
    public OCStructSymbol getSymbol() {
        OCStructSymbol oCStructSymbol = this.myStructs.get(0);
        if (oCStructSymbol == null) {
            OCStructType.$$$reportNull$$$0(11);
        }
        return oCStructSymbol;
    }

    @Nullable
    public List<OCTypeArgument> getArguments() {
        return this.myArguments;
    }

    @Nullable
    public List<OCTypeArgument> getResolvedArguments(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(12);
        }
        if (this.myArguments == null) {
            return null;
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        for (OCTypeArgument myArgument : this.myArguments) {
            result.add(OCSimpleTypeSubstitution.resolveTypeArgument(myArgument, context));
        }
        return result;
    }

    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.myStructs.get(0).getKind();
        if (oCSymbolKind == null) {
            OCStructType.$$$reportNull$$$0(13);
        }
        return oCSymbolKind;
    }

    public boolean isEnumClass() {
        return this.myStructs.get(0).isEnumClass();
    }

    public boolean isEnum() {
        return this.myStructs.get(0).isEnum();
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitStructType(this);
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        for (OCStructSymbol struct : this.myStructs) {
            OCDeclaratorSymbol field = struct.findField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getFields() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myStructs.get(0).processFields((Processor<? super OCDeclaratorSymbol>)collector);
        List results = (List)collector.getResults();
        results.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
        List list = results;
        if (list == null) {
            OCStructType.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public FindConstructorResult findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, @Nullable PsiElement localContext, boolean allowImplicitConversions, @Nullable Supplier<Boolean> isExplicitCall, boolean isListInitialization) {
        if (arguments == null) {
            OCStructType.$$$reportNull$$$0(15);
        }
        if (context == null) {
            OCStructType.$$$reportNull$$$0(16);
        }
        FindConstructorResult findConstructorResult = this.getSymbol().findConstructor(arguments, context, localContext, allowImplicitConversions, isExplicitCall, isListInitialization, this);
        if (findConstructorResult == null) {
            OCStructType.$$$reportNull$$$0(17);
        }
        return findConstructorResult;
    }

    public boolean isEmpty(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(18);
        }
        return this.isEmpty(new HashSet<OCStructSymbol>(), context);
    }

    public boolean isEmpty(HashSet<OCStructSymbol> processed, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(19);
        }
        boolean[] result = new boolean[]{true};
        for (OCStructSymbol struct : this.myStructs) {
            if (processed.add(struct)) {
                if (struct.getKind() == OCSymbolKind.ENUM) {
                    return false;
                }
                struct.processFields((Processor<? super OCDeclaratorSymbol>)((Processor)symbol -> {
                    if (symbol.getKind() != OCSymbolKind.STRUCT_FIELD || symbol.isStatic()) {
                        return true;
                    }
                    OCType elementType = symbol.getResolvedType(context);
                    if (elementType instanceof OCArrayType) {
                        if (!((OCArrayType)elementType).isEmpty(processed, context)) {
                            result[0] = false;
                        }
                    } else if (elementType instanceof OCStructType) {
                        if (!((OCStructType)elementType).isEmpty(processed, context)) {
                            result[0] = false;
                        }
                    } else {
                        result[0] = false;
                    }
                    return true;
                }));
                processed.remove(struct);
                continue;
            }
            return false;
        }
        return result[0];
    }

    public boolean processFields(@Nullable String fieldName, Processor<? super OCDeclaratorSymbol> processor2, OCResolveContext context) {
        return this.processMembers(fieldName, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCDeclaratorSymbol) {
                return processor2.process((Object)((OCDeclaratorSymbol)ocSymbol));
            }
            return true;
        }), context);
    }

    public boolean isAbstract() {
        return !this.getSymbol().processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isPureVirtual()));
    }

    public boolean isUnnamed() {
        return this.myStructs.get(0).isUnnamed();
    }

    public boolean isPredeclaration() {
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredeclaration()) continue;
            return false;
        }
        return true;
    }

    public boolean isPOD(boolean checkInnerStructs, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(20);
        }
        return !ContainerUtil.exists(this.myStructs, symbol -> !symbol.isPOD(checkInnerStructs, context));
    }

    public static boolean processMembersInBaseTypes(@NotNull OCStructSymbol scope, @Nullable String memberName, boolean typesOnly, boolean goTransitive, @NotNull Condition<? super OCSymbol> condition, @NotNull Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context) {
        HashSet processedSet;
        if (scope == null) {
            OCStructType.$$$reportNull$$$0(21);
        }
        if (condition == null) {
            OCStructType.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            OCStructType.$$$reportNull$$$0(23);
        }
        if (context == null) {
            OCStructType.$$$reportNull$$$0(24);
        }
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack workset2 = new Stack();
        FilteringProcessor filteringProcessor = new FilteringProcessor(condition, processor2);
        if (!goTransitive && memberName == null) {
            processedSet = new HashSet();
            goTransitive = true;
        } else {
            processedSet = null;
        }
        processed.add(scope);
        workset2.add((Object)new Pair((Object)scope, processedSet));
        while (!workset2.isEmpty()) {
            ProgressManager.checkCanceled();
            Pair pair = (Pair)workset2.pop();
            Object object = pair.getFirst();
            if (!(object instanceof OCStructSymbol)) continue;
            OCStructSymbol structSymbol = (OCStructSymbol)object;
            boolean finalGoTransitive = goTransitive;
            if (structSymbol.processBaseClasses(context.useFor(scope), (symbol, visibility) -> {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && symbol.getName().equals(memberName) && !filteringProcessor.process((Object)symbol)) {
                    return false;
                }
                if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFinal()) {
                    return false;
                }
                HashSet<String> alreadyProcessed = pair.getSecond() != null ? new HashSet<String>((Collection)pair.getSecond()) : null;
                InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, finalGoTransitive, alreadyProcessed, scope.getSubstitution(), processed, (Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>>)workset2, processor2, condition, context);
                return resolver.process(symbol);
            })) continue;
            return false;
        }
        return true;
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookInsideUsings, boolean typesOnly, Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (namespace == null) {
            OCStructType.$$$reportNull$$$0(25);
        }
        if (context == null) {
            OCStructType.$$$reportNull$$$0(26);
        }
        return OCStructType.processMembersOfNamespace(namespace, memberName, true, lookInsideUsings, true, typesOnly, processor2, null, true, context);
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookForMembers, boolean lookInsideUsings, boolean lookIntoBaseClasses, boolean typesOnly, Processor<? super OCSymbol> processor2, @Nullable OCSymbolReference usageReference, boolean handleInjectedClasses, @NotNull OCResolveContext context) {
        if (namespace == null) {
            OCStructType.$$$reportNull$$$0(27);
        }
        if (context == null) {
            OCStructType.$$$reportNull$$$0(28);
        }
        ProgressManager.checkCanceled();
        class SomethingProcessedDetector
        implements Processor<OCSymbol> {
            private final Processor<? super OCSymbol> myProcessor;
            private boolean mySomethingProcessed = false;
            private boolean myNamespaceProcessed = false;

            SomethingProcessedDetector(Processor<? super OCSymbol> processor2) {
                this.myProcessor = processor2;
            }

            public boolean process(OCSymbol symbol) {
                if (symbol.getKind() != OCSymbolKind.SYMBOL_USING_SYMBOL) {
                    this.mySomethingProcessed = true;
                }
                if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.myNamespaceProcessed = true;
                }
                return this.myProcessor.process((Object)symbol);
            }
        }
        SomethingProcessedDetector detector = new SomethingProcessedDetector(processor2);
        FilteringProcessor filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, (Processor)detector);
        if (lookForMembers && !namespace.processMembers(memberName, new FriendsFilter(namespace, (Processor<? super OCSymbol>)filter))) {
            return false;
        }
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack workset2 = new Stack();
        processed.add(namespace);
        workset2.add((Object)new Pair((Object)namespace, null));
        Collection<OCNamespaceSymbol> inlineNamespaces = namespace.getInlineNamespaces();
        if (lookInsideUsings && inlineNamespaces != null && (!detector.myNamespaceProcessed || memberName == null)) {
            for (OCNamespaceSymbol inlineNamespace : inlineNamespaces) {
                OCStructType.processMembersOfNamespace(inlineNamespace, memberName, true, typesOnly, processor2, context);
            }
        }
        if (!(!lookInsideUsings || namespace.getNamespaceUsings() == null && inlineNamespaces == null || detector.myNamespaceProcessed && memberName != null)) {
            while (!workset2.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair pair = (Pair)workset2.pop();
                Collection<OCUsingSymbol> namespaceUsings = ((OCNamespaceLikeSymbol)pair.getFirst()).getNamespaceUsings();
                if (namespaceUsings == null) continue;
                for (OCUsingSymbol using : namespaceUsings) {
                    List<OCSymbol> list;
                    ProgressManager.checkCanceled();
                    InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, true, null, OCTypeSubstitution.ID, processed, (Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>>)workset2, processor2, (Condition<? super OCSymbol>)Conditions.alwaysTrue(), context);
                    OCSymbolReference reference = using.getSymbolReference();
                    if (usageReference != null && reference instanceof OCSymbolReference.GlobalReference) {
                        OCSymbolReference.GlobalReference globalReference = (OCSymbolReference.GlobalReference)reference;
                        if (usageReference.getOffset() != -1L && Comparing.equal((Object)globalReference.getVirtualFile(), (Object)usageReference.getVirtualFile()) && globalReference.getOffset() >= usageReference.getOffset()) continue;
                        List<String> usageName = usageReference.getQualifiedName().flatten();
                        List<String> usingName = reference.getQualifiedName().flatten();
                        if (ContainerUtil.startsWith(usingName, (List)usageName)) continue;
                        reference = new OCSymbolReference.UsingReference(globalReference.getQualifiedName(), globalReference.getSymbolContext(), usageReference.getVirtualFile(), usageReference.getOffset(), globalReference.getFilter(), globalReference.getVirtualFile(), globalReference.getOffset());
                    }
                    if ((list = context.resolveToSymbols(reference, false, typesOnly)).isEmpty() && context.isOriginallyProcessNonImported() && !context.isProcessNonImported()) {
                        context.setProcessNonImported(true);
                        list = context.resolveToSymbols(reference, false, typesOnly);
                        context.setProcessNonImported(false);
                    }
                    for (OCSymbol symbol : list) {
                        ProgressManager.checkCanceled();
                        if (resolver.process(symbol)) continue;
                        return false;
                    }
                }
            }
        }
        if (namespace instanceof OCStructSymbol) {
            OCStructSymbol struct = (OCStructSymbol)namespace;
            if (handleInjectedClasses && struct.getName().equals(memberName) && !processor2.process((Object)struct)) {
                return false;
            }
            boolean isAssignmentOperator = "operator=".equals(memberName);
            if (!typesOnly) {
                Processor msvcAnonymousStructureFinder;
                OCLanguageKind kind;
                OCStructType ownType;
                OCCppReferenceType constRefToOwnType;
                PsiFile file = struct.getContainingPsiFile(context.getProject());
                if (struct.getKind() == OCSymbolKind.STRUCT && isAssignmentOperator && struct.processMembers(memberName, (Processor<? super OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(constRefToOwnType = OCCppReferenceType.to((ownType = new OCStructType(struct)).cloneWithConstModifier(context.getProject())), context){
                    final /* synthetic */ OCCppReferenceType val$constRefToOwnType;
                    final /* synthetic */ OCResolveContext val$context;
                    {
                        this.val$constRefToOwnType = oCCppReferenceType;
                        this.val$context = oCResolveContext;
                    }

                    protected boolean accept(OCSymbol symbol) {
                        if (!(symbol instanceof OCFunctionSymbol)) {
                            return false;
                        }
                        List<OCType> args = ((OCFunctionSymbol)symbol).getType().getParameterTypes();
                        return args.size() == 1 && args.get(0).equalsAfterResolving(this.val$constRefToOwnType, this.val$context);
                    }
                }) && struct.processMembers("operator=", (Processor<? super OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
                    OCFunctionType functionType = new OCFunctionType(OCCppReferenceType.to(ownType), Collections.singletonList(constRefToOwnType));
                    int attributes = OCSymbolAttribute.EXPLICIT.getMask();
                    OCDeclaratorSymbolImpl paramSymbol = new OCDeclaratorSymbolImpl(null, -1L, null, OCQualifiedName.interned("<unnamed>"), Collections.emptyList(), constRefToOwnType, OCSymbolKind.PARAMETER, null, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
                    processor2.process((Object)new OCFunctionSymbol(struct.getContainingFile(), struct.getComplexOffset(), struct, OCQualifiedName.with(memberName), Collections.emptyList(), Collections.emptyList(), 0, attributes, Collections.emptyList(), functionType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, OCVisibility.PUBLIC));
                }
                if ((struct.getKind() == OCSymbolKind.STRUCT || struct.getKind() == OCSymbolKind.UNION) && (kind = OCPsiFile.getKind(file)) != null && context.isMsvcExtensionsCapable() && !kind.isCpp() && OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.MS_EXTENSIONS) && !namespace.processMembers(null, msvcAnonymousStructureFinder = memberSymbol -> {
                    OCStructSymbol symbol;
                    OCType type;
                    if (memberSymbol instanceof OCDeclaratorSymbol && memberSymbol.isUnnamed() && (type = memberSymbol.getType().resolve(context)) instanceof OCStructType && !(symbol = ((OCStructType)type).getSymbol()).isEnum()) {
                        return OCStructType.processMembersOfNamespace(symbol, memberName, false, false, processor2, context);
                    }
                    return true;
                })) {
                    return false;
                }
            }
            if (!(!lookIntoBaseClasses || isAssignmentOperator || detector.mySomethingProcessed && memberName != null || OCStructType.processMembersInBaseTypes(struct, memberName, typesOnly, true, (Condition<? super OCSymbol>)Conditions.alwaysTrue(), processor2, context))) {
                return false;
            }
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(29);
        }
        for (OCStructSymbol struct : this.myStructs) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, true, false, processor2, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubstructOf(OCStructSymbol struct, OCStructSymbol substruct, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(30);
        }
        return Comparing.equal((Object)struct, (Object)substruct) || !substruct.processAllBaseClasses(context, (symbol, visibility) -> !symbol.equals(struct), true);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(31);
        }
        return this.isMagicInside(context, true);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(32);
        }
        return this.isMagicInside(context, false);
    }

    public boolean isMagicInside(@NotNull OCResolveContext context, boolean checkTemplateArgs) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(33);
        }
        for (OCStructSymbol struct : this.myStructs) {
            if (checkTemplateArgs && OCResolveUtil.hasNonResolvedTemplateParameters(struct, context)) {
                return true;
            }
            if (struct.getBaseCppClasses(context).isEmpty() && this.myStructs.size() <= 1) {
                return false;
            }
            OCSymbolWithQualifiedName current = struct;
            boolean hasTemplateInParent = false;
            while (current instanceof OCStructSymbol) {
                OCStructSymbol currentStruct = current;
                if (!currentStruct.getTemplateParameters().isEmpty()) {
                    hasTemplateInParent = true;
                    break;
                }
                current = currentStruct.getResolvedOwner(context);
            }
            if (!hasTemplateInParent && this.myStructs.size() <= 1) {
                return false;
            }
            if (struct.processAllBaseClasses(context, (symbol, visibility) -> !(symbol instanceof OCTypeParameterSymbol), true)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeveralSpecializations() {
        int nonPredefsCnt = 0;
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredefinition()) continue;
            ++nonPredefsCnt;
        }
        return nonPredefsCnt > 1;
    }

    @Override
    public boolean isScalar() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(34);
        }
        return this.getKind() == OCSymbolKind.STRUCT && context.isCpp();
    }

    @Override
    public boolean isNumberCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(35);
        }
        return super.isNumberCompatible(context) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    public boolean isIntegerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(36);
        }
        return super.isIntegerCompatible(context, checkCppConvertible) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(37);
        }
        if (this.getKind() == OCSymbolKind.ENUM) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            this.myStructs.get(0).processFields((Processor<? super OCDeclaratorSymbol>)finder);
            if (finder.isFound()) {
                return this.getDefaultEnumValue((OCSymbol)finder.getFoundValue(), context);
            }
        } else if (this.getKind() == OCSymbolKind.STRUCT) {
            OCStructSymbol symbol = this.getSymbol();
            if (this.isCppStructType(context)) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(finder, (Condition<? super T>[])new Condition[]{symbol12 -> symbol12.canBeCalledWithoutArguments() && symbol12.getVisibility() == OCVisibility.PUBLIC, symbol1 -> symbol1.getVisibility() == OCVisibility.PUBLIC, Conditions.alwaysTrue()});
                symbol.processConstructors(orderedProcessor, context);
                orderedProcessor.finish();
                OCStructType nakedType = (OCStructType)this.cloneWithoutCVQualifiers(context.getProject());
                String typedefed = nakedType.getTypedefName();
                String aliased = nakedType.getAliasName();
                String hint = typedefed != null ? typedefed : aliased;
                String bestName = nakedType.getBestNameInContext(context, hint);
                StringBuilder builder2 = new StringBuilder(bestName);
                builder2.append("(");
                if (finder.isFound()) {
                    boolean isFirst = true;
                    for (OCDeclaratorSymbol parameter : ((OCFunctionSymbol)finder.getFoundValue()).getParameterSymbols()) {
                        OCType type;
                        if (parameter.hasInitializer()) break;
                        if (!isFirst) {
                            builder2.append(",");
                        }
                        if ((type = parameter.getResolvedType(context)).isCppStructType(context)) {
                            String name;
                            if (type instanceof OCCppReferenceType) {
                                type = ((OCCppReferenceType)type).getRefType();
                            }
                            if (type instanceof OCStructType) {
                                OCQualifiedName qualifiedName = ((OCStructType)type).getSymbol().getResolvedQualifiedName(context);
                                qualifiedName = qualifiedName != null ? qualifiedName : symbol.getQualifiedName();
                                name = qualifiedName.getNameWithParent();
                            } else {
                                name = type.getName();
                            }
                            builder2.append(name).append("()");
                        } else {
                            builder2.append(type.getDefaultValue(context));
                        }
                        isFirst = false;
                    }
                }
                builder2.append(")");
                String string = builder2.toString();
                if (string == null) {
                    OCStructType.$$$reportNull$$$0(38);
                }
                return string;
            }
        }
        return "result";
    }

    @Override
    @Nullable
    @NonNls
    public String getFormatString() {
        return this.getKind() == OCSymbolKind.ENUM ? "%d" : super.getFormatString();
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(39);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCStructType.$$$reportNull$$$0(40);
            }
            return oCUnknownType;
        }
        if (this.equals(type, context)) {
            OCStructType oCStructType = this;
            if (oCStructType == null) {
                OCStructType.$$$reportNull$$$0(41);
            }
            return oCStructType;
        }
        if (type instanceof OCMagicType) {
            OCStructType oCStructType = this;
            if (oCStructType == null) {
                OCStructType.$$$reportNull$$$0(42);
            }
            return oCStructType;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type.isPointerCompatible(context)) {
            OCIntType oCIntType = OCIntType.INT;
            if (oCIntType == null) {
                OCStructType.$$$reportNull$$$0(43);
            }
            return oCIntType;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            OCIntType oCIntType = OCIntType.INT;
            if (oCIntType == null) {
                OCStructType.$$$reportNull$$$0(44);
            }
            return oCIntType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCStructType.$$$reportNull$$$0(45);
        }
        return oCUnknownType;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructType.$$$reportNull$$$0(46);
        }
        for (OCTypeArgument argument : this.getSymbol().getTemplateArguments(context)) {
            if (!(argument instanceof OCType) || !((OCType)argument).isUnresolved(context)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private String getDefaultEnumValue(@NotNull OCSymbol defaultEnumValue, @NotNull OCResolveContext context) {
        if (defaultEnumValue == null) {
            OCStructType.$$$reportNull$$$0(47);
        }
        if (context == null) {
            OCStructType.$$$reportNull$$$0(48);
        }
        if (this.isEnumClass()) {
            String string = this.getName(context) + "::" + defaultEnumValue.getName();
            if (string == null) {
                OCStructType.$$$reportNull$$$0(49);
            }
            return string;
        }
        String bestNameInContext = this.getBestNameInContext(context);
        int namespaceIndex = bestNameInContext.lastIndexOf("::");
        String namespacePrefix = namespaceIndex >= 0 ? bestNameInContext.substring(0, namespaceIndex) : "";
        Object object = StringUtil.isNotEmpty((String)namespacePrefix) && !namespacePrefix.contains(" ") ? namespacePrefix + "::" + defaultEnumValue.getName() : defaultEnumValue.getName();
        if (object == null) {
            OCStructType.$$$reportNull$$$0(50);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 13, 14, 17, 38, 40, 41, 42, 43, 44, 45, 49, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCStructType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultEnumValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCStructType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstructor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEnumValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectMethods";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findConstructor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPOD";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInBaseTypes";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processMembersOfNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSubstructOf";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isMagicInside";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSubclassOfMagic";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCppStructType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isNumberCompatible";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerCompatible";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEnumValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 13, 14, 17, 38, 40, 41, 42, 43, 44, 45, 49, 50 -> new IllegalStateException(string);
        };
    }

    private static class FriendsFilter
    implements Processor<OCSymbol> {
        private final OCQualifiedName parentQualifiedName;
        private final Processor<? super OCSymbol> myProcessor;

        FriendsFilter(OCNamespaceLikeSymbol parent, Processor<? super OCSymbol> processor2) {
            this.parentQualifiedName = parent instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)((Object)parent)).getQualifiedName() : null;
            this.myProcessor = processor2;
        }

        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isFriend()) {
                OCQualifiedName qualifiedName;
                OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
                OCQualifiedName oCQualifiedName = qualifiedName = parent != null ? parent.getQualifiedName() : null;
                if (!Comparing.equal((Object)qualifiedName, (Object)this.parentQualifiedName)) {
                    return true;
                }
            }
            return this.myProcessor.process((Object)symbol);
        }
    }

    private static class InnerProcessor
    implements Processor<OCSymbol> {
        private final String myMemberName;
        private final boolean myTypesOnly;
        private final boolean myGoTransitive;
        private final Set<String> myAlreadyProcessed;
        private final OCTypeSubstitution mySubstitution;
        private final Set<? super OCNamespaceLikeSymbol> myProcessed;
        private final Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>> myWorkset;
        private final Processor<? super OCSymbol> myProcessor;
        private final Processor<OCSymbol> myFilteringProcessor;
        private final Condition<? super OCSymbol> myCondition;
        @NotNull
        private final OCResolveContext myContext;

        InnerProcessor(String memberName, boolean typesOnly, boolean goTransitive, Set<String> alreadyProcessed, OCTypeSubstitution substitution, Set<? super OCNamespaceLikeSymbol> processed, Stack<? super Pair<OCNamespaceLikeSymbol, Set<String>>> workset2, Processor<? super OCSymbol> processor2, Condition<? super OCSymbol> condition, @NotNull OCResolveContext context) {
            if (context == null) {
                InnerProcessor.$$$reportNull$$$0(0);
            }
            this.myMemberName = memberName;
            this.myTypesOnly = typesOnly;
            this.myGoTransitive = goTransitive;
            this.myAlreadyProcessed = alreadyProcessed;
            this.mySubstitution = substitution;
            this.myProcessed = processed;
            this.myWorkset = workset2;
            this.myProcessor = processor2;
            this.myFilteringProcessor = new FilteringProcessor(condition, processor2);
            this.myCondition = condition;
            this.myContext = context;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCStructSymbol && symbol.getName().equals(this.myMemberName) && !this.myProcessor.process((Object)symbol)) {
                return false;
            }
            if (symbol instanceof OCNamespaceSymbol && !this.myProcessed.contains(symbol)) {
                Ref processed;
                FilteringProcessor filter;
                OCNamespaceSymbol struct;
                this.myProcessed.add((OCNamespaceLikeSymbol)((Object)symbol));
                if (symbol instanceof OCStructSymbol) {
                    struct = (OCStructSymbol)symbol;
                    if (this.mySubstitution != OCTypeSubstitution.ID) {
                        symbol = struct.cloneWithSubstitution(OCTypeSubstitution.compose(((OCStructSymbol)struct).getSubstitution(), this.mySubstitution));
                    }
                }
                if (!(struct = (OCNamespaceSymbol)symbol).processMembers(this.myMemberName, new FriendsFilter(struct, (Processor<? super OCSymbol>)(filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, arg_0 -> this.lambda$process$0(processed = new Ref((Object)false), arg_0)))))) {
                    return false;
                }
                if (((Boolean)processed.get()).booleanValue() && !this.myGoTransitive) return true;
                this.myWorkset.push((Object)new Pair((Object)struct, this.myAlreadyProcessed));
                return true;
            }
            if (symbol instanceof OCDeclaratorSymbol && symbol.getKind().isTypedefOrAlias()) {
                OCType type = symbol.getType();
                if (type instanceof OCMagicType) {
                    if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, 0L, this.myMemberName, null, Collections.emptyList(), null, false, true, true, null))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbolImpl(this.myMemberName, new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                    return false;
                }
                if (type instanceof OCStructType) {
                    if (this.mySubstitution == OCTypeSubstitution.ID) {
                        return ContainerUtil.process(((OCStructType)type).getStructs(), (Processor)this);
                    }
                    for (OCStructSymbol struct : ((OCStructType)type).getStructs()) {
                        if (this.process(struct.cloneWithSubstitution(OCTypeSubstitution.compose(struct.getSubstitution(), this.mySubstitution)))) continue;
                        return false;
                    }
                    return true;
                } else {
                    if (!(type instanceof OCReferenceType)) return true;
                    return ContainerUtil.process(this.myContext.substitute(((OCReferenceType)type).getSubstitution()).resolveToSymbols(((OCReferenceType)type).getReference(this.myContext), true, true), (Processor)this);
                }
            }
            if (symbol instanceof OCTypeParameterSymbol) {
                OCTypeParameterTypeSymbol qualifierTypeParameter;
                OCTypeParameterTypeSymbol oCTypeParameterTypeSymbol = qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, 0L, this.myMemberName, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true, null))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbolImpl(this.myMemberName, new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER){});
                return false;
            }
            if (symbol instanceof OCUsingSymbol) {
                return ContainerUtil.process(this.myContext.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference(), true, this.myTypesOnly), (Processor)this);
            }
            if (!(symbol instanceof OCNamespaceAliasSymbol)) return true;
            return ContainerUtil.process(this.myContext.resolveToSymbols(((OCNamespaceAliasSymbol)symbol).getNamespaceReference(), true, this.myTypesOnly), (Processor)this);
        }

        private /* synthetic */ boolean lambda$process$0(Ref processed, OCSymbol symbol1) {
            String signature2;
            String string = signature2 = symbol1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol1).getSignatureWithoutParamNames() : symbol1.getName();
            if (this.myAlreadyProcessed != null && this.myAlreadyProcessed.contains(signature2)) {
                return true;
            }
            if (this.myCondition.value((Object)symbol1)) {
                processed.set((Object)true);
                if (this.myAlreadyProcessed != null) {
                    this.myAlreadyProcessed.add(signature2);
                }
                if (!this.myProcessor.process((Object)symbol1)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/OCStructType$InnerProcessor", "<init>"));
        }
    }
}

