/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Predicates;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ARCAttribute {
    STRONG(OCTokenTypes.STRONG_KEYWORD, "objc_ownership#strong"),
    WEAK(OCTokenTypes.WEAK_KEYWORD, "objc_ownership#weak"),
    UNSAFE_UNRETAINED(OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD, "objc_ownership#none"),
    AUTO_RELEASING(OCTokenTypes.AUTORELEASING_KEYWORD, "objc_ownership#autoreleasing");

    public static final ARCAttribute DEFAULT;
    private final OCElementType myTokenType;
    private final String myAttributeText;
    private static final Map<String, ARCAttribute> myArcTextToAttribute;
    private static final Map<OCElementType, ARCAttribute> myArcTokenTypeToAttribute;

    private ARCAttribute(OCElementType tokenType, String attributeText) {
        if (tokenType == null) {
            ARCAttribute.$$$reportNull$$$0(0);
        }
        if (attributeText == null) {
            ARCAttribute.$$$reportNull$$$0(1);
        }
        this.myTokenType = tokenType;
        this.myAttributeText = attributeText;
    }

    public String getTokenName() {
        return this.myTokenType.getName();
    }

    public OCPropertySymbol.PropertySemantics getPropertyCompatibleSemantics(OCType type, PsiElement context) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STRONG -> OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
            case WEAK -> OCPropertySymbol.PropertySemantics.WEAK;
            case UNSAFE_UNRETAINED, AUTO_RELEASING -> OCPropertySymbol.PropertySemantics.ASSIGN;
        };
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    @Nullable
    public static ARCAttribute parseArcAttribute(@Nullable List<String> attributes) {
        ARCAttribute result = null;
        if (attributes != null) {
            result = attributes.stream().map(myArcTextToAttribute::get).filter(Predicates.nonNull()).findFirst().orElse(null);
        }
        return result;
    }

    @NotNull
    OCElementType getTokenType() {
        OCElementType oCElementType = this.myTokenType;
        if (oCElementType == null) {
            ARCAttribute.$$$reportNull$$$0(2);
        }
        return oCElementType;
    }

    @Nullable
    public static ARCAttribute getAttributeByToken(@NotNull IElementType token) {
        if (token == null) {
            ARCAttribute.$$$reportNull$$$0(3);
        }
        if (token instanceof OCElementType) {
            return myArcTokenTypeToAttribute.get(token);
        }
        return null;
    }

    public static boolean isArcToken(@NotNull IElementType token) {
        if (token == null) {
            ARCAttribute.$$$reportNull$$$0(4);
        }
        return ARCAttribute.getAttributeByToken(token) != null;
    }

    static {
        DEFAULT = STRONG;
        myArcTextToAttribute = ContainerUtil.newMapFromValues((Iterator)ContainerUtil.iterate((Object[])ARCAttribute.values()), arcAttribute -> arcAttribute.myAttributeText);
        myArcTokenTypeToAttribute = ContainerUtil.newMapFromValues((Iterator)ContainerUtil.iterate((Object[])ARCAttribute.values()), arcAttribute -> arcAttribute.myTokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/ARCAttribute";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/ARCAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByToken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isArcToken";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

