/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.MetaData;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.PersistentByteStorage;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.PersistentSymbolMetadataStorage;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SerializationServiceImpl
implements SerializationService {
    private static final Logger LOG = Logger.getInstance(SerializationServiceImpl.class);
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute:";
    private final Stack<FileSymbolTableSerializer> mySerializerPool = new Stack();
    private final PersistentByteStorage myStorage = PersistentByteStorage.create(FileSymbolTableSerializationVersion.INSTANCE.getVersion());

    @Override
    public void serializeTables(@NotNull Project project, @NotNull String projectLocationHash, @NotNull Map<VirtualFile, FileSymbolTablesPack> tables, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(0);
        }
        if (projectLocationHash == null) {
            SerializationServiceImpl.$$$reportNull$$$0(1);
        }
        if (tables == null) {
            SerializationServiceImpl.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            SerializationServiceImpl.$$$reportNull$$$0(3);
        }
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue2 = new ConcurrentLinkedQueue<VirtualFile>(tables.keySet());
        String keyForSerialization = SerializationServiceImpl.getKeyForSerialization(projectLocationHash);
        String basePath = project.getBasePath();
        LOG.assertTrue(basePath != null);
        this.performAsynchronously(project, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)serializer -> {
            VirtualFile file;
            boolean ok = true;
            while (ok && (file = (VirtualFile)queue2.poll()) != null) {
                indicator.checkCanceled();
                VirtualFile finalFile = file;
                ok = (Boolean)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    if (!SerializationServiceImpl.shouldSerializeTable(finalFile)) {
                        return true;
                    }
                    try {
                        if (finalFile instanceof VirtualFileWithId) {
                            MetaData metaData = SerializationServiceImpl.readMetaData((NotNullLazyValue<FileSymbolTableSerializer>)serializer, finalFile);
                            metaData.registerProject(projectLocationHash, basePath);
                            SerializationServiceImpl.writeMetaData((FileSymbolTableSerializer)((Object)((Object)((Object)serializer.getValue()))), finalFile, metaData);
                            FileSymbolTablesPack pack = (FileSymbolTablesPack)tables.get(finalFile);
                            this.writePack(pack, finalFile, (FileSymbolTableSerializer)((Object)((Object)((Object)serializer.getValue()))), keyForSerialization);
                        } else {
                            this.writePackForLightFile(project, tables, finalFile, (FileSymbolTableSerializer)((Object)((Object)((Object)serializer.getValue()))));
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Can't serialize file symbol table", (Throwable)e);
                        return false;
                    }
                    return true;
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    @Override
    @NotNull
    public Map<VirtualFile, FileSymbolTablesPack> deserializeTables(@NotNull Project project, @NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(4);
        }
        if (projectLocationHash == null) {
            SerializationServiceImpl.$$$reportNull$$$0(5);
        }
        if (filesToLoad == null) {
            SerializationServiceImpl.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            SerializationServiceImpl.$$$reportNull$$$0(7);
        }
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project);
        HashSet processedFiles = new HashSet();
        Set notLoaded = ConcurrentCollectionFactory.createConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset2 = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ConcurrentCollectionFactory.createConcurrentSet();
        MultiMap importsMap = new MultiMap();
        ConcurrentHashMap<VirtualFile, FileSymbolTablesPack> result = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
        long total = notLoaded.size();
        this.performAsynchronously(project, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)serializer -> {
            try {
                SerializationSession session = new SerializationSession(projectLocationHash);
                while (true) {
                    VirtualFile file;
                    indicator.checkCanceled();
                    ArrayDeque arrayDeque = workset2;
                    synchronized (arrayDeque) {
                        if (workset2.isEmpty()) {
                            return;
                        }
                        file = (VirtualFile)workset2.pop();
                        if (!processedFiles.add(file)) {
                            continue;
                        }
                    }
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)ReadAction.compute(() -> {
                        FileSymbolTablesPack p;
                        indicator.checkCanceled();
                        if (!SerializationServiceImpl.shouldSerializeTable(file)) {
                            return null;
                        }
                        FileSymbolTablesPack fileSymbolTablesPack = p = file instanceof VirtualFileWithId ? this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer, session, file) : this.readTablesForLightFile(project, (NotNullLazyValue<FileSymbolTableSerializer>)serializer, file);
                        if (p == null) {
                            dirtySet.add(file);
                        }
                        return p;
                    });
                    if (pack == null) continue;
                    notLoaded.remove(file);
                    indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                    if (pack.isEmpty()) continue;
                    for (FileSymbolTable table : pack.tablesView()) {
                        table.processIncludes((Processor<? super OCSymbol>)((Processor)include -> {
                            ModuleMapManager.Cache cache;
                            ModuleMapSymbol module2;
                            QualifiedName moduleName;
                            indicator.checkCanceled();
                            if (include instanceof OCIncludeSymbol) {
                                VirtualFile targetFile;
                                OCIncludeSymbol inc = (OCIncludeSymbol)include;
                                if (inc.isSymbolTableUsed() && (targetFile = inc.getTargetFile()) != null) {
                                    ArrayDeque arrayDeque = workset2;
                                    synchronized (arrayDeque) {
                                        workset2.push(targetFile);
                                        importsMap.putValue((Object)targetFile, (Object)file);
                                    }
                                }
                            } else if (include instanceof OCModuleImportSymbol && (moduleName = ((OCModuleImportSymbol)include).getModuleName()) != null && (module2 = (ModuleMapSymbol)ReadAction.compute(() -> SerializationServiceImpl.lambda$deserializeTables$3(cache = moduleMapManager.getGlobalCache(), moduleName))) != null) {
                                ArrayDeque arrayDeque = workset2;
                                synchronized (arrayDeque) {
                                    for (VirtualFile header : module2.getIncludeHeaders()) {
                                        workset2.push(header);
                                        importsMap.putValue((Object)header, (Object)file);
                                    }
                                }
                            }
                            return true;
                        }));
                    }
                    result.put(file, pack);
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
                return;
            }
        }));
        workset2.addAll(dirtySet);
        while (!workset2.isEmpty()) {
            VirtualFile file = workset2.pop();
            for (VirtualFile dep : importsMap.get((Object)file)) {
                if (!dirtySet.add(dep)) continue;
                workset2.push(dep);
            }
        }
        for (VirtualFile file : dirtySet) {
            result.remove(file);
        }
        ConcurrentHashMap<VirtualFile, FileSymbolTablesPack> concurrentHashMap = result;
        if (concurrentHashMap == null) {
            SerializationServiceImpl.$$$reportNull$$$0(8);
        }
        return concurrentHashMap;
    }

    private void performAsynchronously(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Consumer<NotNullLazyValue<FileSymbolTableSerializer>> task2) {
        Application application;
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            SerializationServiceImpl.$$$reportNull$$$0(10);
        }
        if (task2 == null) {
            SerializationServiceImpl.$$$reportNull$$$0(11);
        }
        OCLog.LOG.assertTrue((application = ApplicationManager.getApplication()).isDispatchThread() || !application.isReadAccessAllowed() || indicator == ProgressManager.getInstance().getProgressIndicator());
        ArrayList futures = new ArrayList();
        OCBuildingActivityExecutionService executionService = OCBuildingActivityExecutionService.Companion.getInstance();
        ForkJoinPool executor = executionService.getExecutor();
        int threadCount = executionService.getThreadCount();
        for (int i = 0; i < threadCount; ++i) {
            futures.add(executor.submit(() -> {
                FileSymbolTableSerializer serializer = this.borrowSerializer(project);
                try {
                    task2.consume((Object)NotNullLazyValue.createConstantValue((Object)((Object)serializer)));
                }
                finally {
                    this.returnSerializer(serializer);
                }
            }));
        }
        SmartList exceptions = new SmartList();
        for (Future future : futures) {
            try {
                ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future, (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable t) {
                exceptions.add(t.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file) {
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(12);
        }
        return file.isValid() && !file.isDirectory();
    }

    @NotNull
    private static String getKeyForSerialization(@NotNull String projectLocationHash) {
        if (projectLocationHash == null) {
            SerializationServiceImpl.$$$reportNull$$$0(13);
        }
        String string = TABLES_KEY_PREFIX + projectLocationHash;
        if (string == null) {
            SerializationServiceImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private FileSymbolTablesPack readTablesForFile(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull SerializationSession session, @NotNull VirtualFile file) throws IOException {
        boolean metaDataChanged;
        String lastLocationHash;
        String keyForSerialization;
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(15);
        }
        if (session == null) {
            SerializationServiceImpl.$$$reportNull$$$0(16);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(17);
        }
        FileSymbolTablesPack pack = null;
        MetaData metaData = SerializationServiceImpl.readMetaData(serializer, file);
        boolean upToDate = metaData.isFileUpToDate();
        if (upToDate && (pack = this.readPack(serializer, keyForSerialization = SerializationServiceImpl.getKeyForSerialization(session.getProjectLocationHash()), file)) == null && (lastLocationHash = metaData.getMostRecentLocationHash()) != null && (pack = this.readPack(serializer, keyForSerialization = SerializationServiceImpl.getKeyForSerialization(lastLocationHash), file)) != null) {
            pack.markAsFallback();
        }
        if (metaDataChanged = metaData.evictProjects((projectKey, projectPath) -> {
            if (upToDate && session.projectExists(projectPath)) {
                return false;
            }
            this.myStorage.outputStream(file, projectKey).close();
            return true;
        })) {
            SerializationServiceImpl.writeMetaData((FileSymbolTableSerializer)((Object)serializer.getValue()), file, metaData);
        }
        return pack;
    }

    @Nullable
    private FileSymbolTablesPack readTablesForLightFile(@NotNull Project project, @NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull VirtualFile file) throws IOException {
        String keyForSerialization;
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(18);
        }
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(19);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(20);
        }
        if ((keyForSerialization = SerializationServiceImpl.getKeyForLightFileSerialization(file)) == null) {
            return null;
        }
        VirtualFile projectFile = SerializationServiceImpl.getStorageForLightFiles(project);
        if (projectFile == null) {
            return null;
        }
        FileSymbolTablesPack pack = SerializationServiceImpl.doReadPack(serializer, file, this.myStorage.inputStream(projectFile, keyForSerialization));
        return pack;
    }

    @Nullable
    private static VirtualFile getStorageForLightFiles(@NotNull Project project) {
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(21);
        }
        return ProjectUtil.guessProjectDir((Project)project);
    }

    @Nullable
    private FileSymbolTablesPack readPack(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull String keyForSerialization, @NotNull VirtualFile file) throws IOException {
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(22);
        }
        if (keyForSerialization == null) {
            SerializationServiceImpl.$$$reportNull$$$0(23);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(24);
        }
        return SerializationServiceImpl.doReadPack(serializer, file, this.myStorage.inputStream(file, keyForSerialization));
    }

    @Nullable
    private static FileSymbolTablesPack doReadPack(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull VirtualFile file, @Nullable DataInputStream stream) throws IOException {
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(25);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(26);
        }
        try (DataInputStream dis = stream;){
            if (dis == null || dis.available() == 0) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long metaIndicesVersion = dis.readLong();
            if (metaIndicesVersion != FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long savedTimestamp = dis.readLong();
            if (savedTimestamp != file.getTimeStamp()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            FileSymbolTablesPack fileSymbolTablesPack = ((FileSymbolTableSerializer)((Object)serializer.getValue())).readSymbolTables(dis, file);
            return fileSymbolTablesPack;
        }
    }

    private void writePack(@NotNull FileSymbolTablesPack pack, @NotNull VirtualFile finalFile, @NotNull FileSymbolTableSerializer serializer, @NotNull String keyForSerialization) throws IOException {
        if (pack == null) {
            SerializationServiceImpl.$$$reportNull$$$0(27);
        }
        if (finalFile == null) {
            SerializationServiceImpl.$$$reportNull$$$0(28);
        }
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(29);
        }
        if (keyForSerialization == null) {
            SerializationServiceImpl.$$$reportNull$$$0(30);
        }
        SerializationServiceImpl.doWritePack(pack, finalFile, serializer, this.myStorage.outputStream(finalFile, keyForSerialization));
    }

    private void writePackForLightFile(@NotNull Project project, @NotNull Map<VirtualFile, FileSymbolTablesPack> tables, @NotNull VirtualFile file, @NotNull FileSymbolTableSerializer serializer) throws IOException {
        String keyForSerialization;
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(31);
        }
        if (tables == null) {
            SerializationServiceImpl.$$$reportNull$$$0(32);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(33);
        }
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(34);
        }
        if ((keyForSerialization = SerializationServiceImpl.getKeyForLightFileSerialization(file)) == null) {
            return;
        }
        VirtualFile projectFile = SerializationServiceImpl.getStorageForLightFiles(project);
        if (projectFile == null) {
            return;
        }
        FileSymbolTablesPack pack = tables.get(file);
        SerializationServiceImpl.doWritePack(pack, file, serializer, this.myStorage.outputStream(projectFile, keyForSerialization));
    }

    @Nullable
    private static String getKeyForLightFileSerialization(@NotNull VirtualFile file) {
        String path;
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(35);
        }
        if ((path = CustomHeaderProvider.provideSerializationPathForFile(file)) == null) {
            return null;
        }
        return "cidr_light_file_serialization::" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWritePack(@NotNull FileSymbolTablesPack pack, @NotNull VirtualFile file, @NotNull FileSymbolTableSerializer serializer, @NotNull DataOutputStream dos) throws IOException {
        if (pack == null) {
            SerializationServiceImpl.$$$reportNull$$$0(36);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(37);
        }
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(38);
        }
        if (dos == null) {
            SerializationServiceImpl.$$$reportNull$$$0(39);
        }
        try (DataOutputStream dataOutputStream = dos;){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(file.getTimeStamp());
            Object object = pack.getTablesAccessLock();
            synchronized (object) {
                serializer.writeSymbolTables(dos, pack);
                pack.setSerialized();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static MetaData readMetaData(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull VirtualFile file) throws IOException {
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(40);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(41);
        }
        DataInputStream dis = PersistentSymbolMetadataStorage.inputStream(file);
        if (dis == null || dis.available() == 0) {
            MetaData metaData = new MetaData();
            MetaData metaData2 = metaData;
            if (metaData2 == null) {
                SerializationServiceImpl.$$$reportNull$$$0(42);
            }
            return metaData2;
        }
        long metaIndicesVersion = dis.readLong();
        long metaFileTimestamp = dis.readLong();
        boolean isUpToDate = metaIndicesVersion == FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion();
        isUpToDate = isUpToDate && metaFileTimestamp == file.getTimeStamp();
        MetaData metaData = ((FileSymbolTableSerializer)((Object)serializer.getValue())).readMetaData(dis);
        if (metaData == null) {
            MetaData metaData3 = new MetaData();
            MetaData metaData4 = metaData3;
            if (metaData4 == null) {
                SerializationServiceImpl.$$$reportNull$$$0(43);
            }
            return metaData4;
        }
        metaData.setFileUpToDate(isUpToDate);
        MetaData metaData5 = metaData;
        MetaData metaData6 = metaData5;
        if (metaData6 == null) {
            SerializationServiceImpl.$$$reportNull$$$0(44);
        }
        return metaData6;
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private static void writeMetaData(@NotNull FileSymbolTableSerializer serializer, @NotNull VirtualFile file, @NotNull MetaData metaData) throws IOException {
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(45);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(46);
        }
        if (metaData == null) {
            SerializationServiceImpl.$$$reportNull$$$0(47);
        }
        try (DataOutputStream dos = PersistentSymbolMetadataStorage.outputStream(file);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(file.getTimeStamp());
            serializer.writeMetaData(dos, metaData);
        }
    }

    @Override
    @Nullable
    public FileSymbolTablesPack deserializeTables(@NotNull Project project, @NotNull SerializationSession session, @NotNull VirtualFile file) {
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(48);
        }
        if (session == null) {
            SerializationServiceImpl.$$$reportNull$$$0(49);
        }
        if (file == null) {
            SerializationServiceImpl.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (FileSymbolTablesPack)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            NotNullLazyValue serializer = NotNullLazyValue.lazy(() -> this.borrowSerializer(project));
            try {
                FileSymbolTablesPack p = this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer, session, file);
                if (p != null && !p.isEmpty()) {
                    FileSymbolTablesPack fileSymbolTablesPack = p;
                    return fileSymbolTablesPack;
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
            }
            finally {
                if (serializer.isComputed()) {
                    this.returnSerializer((FileSymbolTableSerializer)((Object)((Object)serializer.getValue())));
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FileSymbolTableSerializer borrowSerializer(@NotNull Project project) {
        if (project == null) {
            SerializationServiceImpl.$$$reportNull$$$0(51);
        }
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        // MONITORENTER : stack
        FileSymbolTableSerializer result = (FileSymbolTableSerializer)((Object)this.mySerializerPool.tryPop());
        if (result == null) {
            result = new FileSymbolTableSerializer();
        }
        result.setProject(project);
        FileSymbolTableSerializer fileSymbolTableSerializer = result;
        // MONITOREXIT : stack
        if (fileSymbolTableSerializer != null) return fileSymbolTableSerializer;
        SerializationServiceImpl.$$$reportNull$$$0(52);
        return fileSymbolTableSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSerializer(@NotNull FileSymbolTableSerializer serializer) {
        if (serializer == null) {
            SerializationServiceImpl.$$$reportNull$$$0(53);
        }
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        synchronized (stack) {
            serializer.setProject(null);
            serializer.compact();
            this.mySerializerPool.push((Object)serializer);
        }
    }

    private static /* synthetic */ ModuleMapSymbol lambda$deserializeTables$3(ModuleMapManager.Cache cache, QualifiedName moduleName) throws RuntimeException {
        return cache.findModule(moduleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 14, 42, 43, 44, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocationHash";
                break;
            }
            case 2: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToLoad";
                break;
            }
            case 8: 
            case 14: 
            case 42: 
            case 43: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationServiceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 12: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 41: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 34: 
            case 38: 
            case 40: 
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 16: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyForSerialization";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dos";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationServiceImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeTables";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForSerialization";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "readMetaData";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "borrowSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serializeTables";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTables";
                break;
            }
            case 8: 
            case 14: 
            case 42: 
            case 43: 
            case 44: 
            case 52: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performAsynchronously";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldSerializeTable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForSerialization";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readTablesForFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readTablesForLightFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStorageForLightFiles";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readPack";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doReadPack";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writePack";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writePackForLightFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForLightFileSerialization";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doWritePack";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "writeMetaData";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "borrowSerializer";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "returnSerializer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 14, 42, 43, 44, 52 -> new IllegalStateException(string);
        };
    }
}

