/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.PersistentByteStorage;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationAttributeService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/AttributeBasedByteStorage;", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/PersistentByteStorage;", "version", "", "(I)V", "getFileCacheAttributeForProjectKey", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "key", "", "inputStream", "Ljava/io/DataInputStream;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "keyForSerialization", "outputStream", "Ljava/io/DataOutputStream;", "intellij.c"})
final class AttributeBasedByteStorage
implements PersistentByteStorage {
    private final int version;

    public AttributeBasedByteStorage(int version) {
        this.version = version;
    }

    @Override
    @Nullable
    public DataInputStream inputStream(@NotNull VirtualFile file, @NotNull String keyForSerialization) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)keyForSerialization, (String)"keyForSerialization");
        FileAttribute attribute = this.getFileCacheAttributeForProjectKey(keyForSerialization, this.version);
        return (DataInputStream)attribute.readFileAttribute(file);
    }

    @Override
    @NotNull
    public DataOutputStream outputStream(@NotNull VirtualFile file, @NotNull String keyForSerialization) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)keyForSerialization, (String)"keyForSerialization");
        FileAttribute attribute = this.getFileCacheAttributeForProjectKey(keyForSerialization, this.version);
        AttributeOutputStream attributeOutputStream = attribute.writeFileAttribute(file);
        Intrinsics.checkNotNullExpressionValue((Object)attributeOutputStream, (String)"writeFileAttribute(...)");
        return (DataOutputStream)attributeOutputStream;
    }

    private final FileAttribute getFileCacheAttributeForProjectKey(String key, int version) {
        return SerializationAttributeService.Companion.getInstance().getFileCacheAttributeForProjectKey(key, version);
    }
}

