/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSymbol
extends OCNamedSymbol {
    @Nullable
    private transient VirtualFile myTargetFile;
    private byte myFlags;
    @NotNull
    private IncludePath myIncludePath;
    private int myEndOffset;
    @NotNull
    private List<String> myNamespace;

    public OCIncludeSymbol() {
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCIncludeSymbol.$$$reportNull$$$0(0);
        }
        if (first == null) {
            OCIncludeSymbol.$$$reportNull$$$0(1);
        }
        if (second == null) {
            OCIncludeSymbol.$$$reportNull$$$0(2);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIncludeSymbol f = (OCIncludeSymbol)first;
        OCIncludeSymbol s = (OCIncludeSymbol)second;
        if (f.myFlags != s.myFlags) {
            return false;
        }
        if (f.myEndOffset != s.myEndOffset) {
            return false;
        }
        if (!Comparing.equal((Object)f.myIncludePath, (Object)s.myIncludePath)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myTargetFile, (Object)s.myTargetFile)) {
            return false;
        }
        return Comparing.equal(f.myNamespace, s.myNamespace);
    }

    /*
     * WARNING - void declaration
     */
    public OCIncludeSymbol(@Nullable VirtualFile file, long offset, @Nullable VirtualFile targetFile, @NotNull IncludePath path, boolean once, boolean next, int endOffset, @Nullable List<String> namespace, boolean bl) {
        void isSymbolTableUsed;
        if (path == null) {
            OCIncludeSymbol.$$$reportNull$$$0(3);
        }
        super(file, offset, path.getPath());
        this.myIncludePath = path;
        this.myTargetFile = targetFile;
        this.setFlag(Flag.ONCE, once);
        this.setFlag(Flag.NEXT, next);
        this.setFlag(Flag.SYM_TABLE_USED, (boolean)isSymbolTableUsed);
        this.myEndOffset = endOffset;
        this.myNamespace = ContainerUtil.isEmpty(namespace) ? Collections.emptyList() : new ArrayList<String>(namespace);
    }

    @Nullable
    public VirtualFile getTargetFile() {
        return this.myTargetFile;
    }

    public void updateTargetFile(@Nullable VirtualFile targetFile) {
        this.myTargetFile = targetFile;
    }

    public boolean isOnce() {
        return this.getFlag(Flag.ONCE);
    }

    public boolean isNext() {
        return this.getFlag(Flag.NEXT);
    }

    public boolean isSymbolTableUsed() {
        return this.getFlag(Flag.SYM_TABLE_USED);
    }

    private boolean getFlag(@NotNull Flag flag) {
        if (flag == null) {
            OCIncludeSymbol.$$$reportNull$$$0(4);
        }
        return (this.myFlags & flag.getMask()) != 0;
    }

    private void setFlag(@NotNull Flag flag, boolean value) {
        if (flag == null) {
            OCIncludeSymbol.$$$reportNull$$$0(5);
        }
        if (value != this.getFlag(flag)) {
            this.myFlags = (byte)(this.myFlags ^ flag.getMask());
        }
    }

    public String getRelativePath() {
        return this.getName();
    }

    public String getLastPathComponent() {
        String path = this.getRelativePath();
        int idx = path.lastIndexOf(47);
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.IMPORT;
        if (oCSymbolKind == null) {
            OCIncludeSymbol.$$$reportNull$$$0(6);
        }
        return oCSymbolKind;
    }

    @NotNull
    public IncludePath getIncludePath() {
        IncludePath includePath = this.myIncludePath;
        if (includePath == null) {
            OCIncludeSymbol.$$$reportNull$$$0(7);
        }
        return includePath;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void enterNamespace(@NotNull OCInclusionContext ctx) {
        if (ctx == null) {
            OCIncludeSymbol.$$$reportNull$$$0(8);
        }
        for (String name : this.myNamespace) {
            ctx.enterNamespace(name);
        }
    }

    public void exitNamespace(@NotNull OCInclusionContext ctx) {
        if (ctx == null) {
            OCIncludeSymbol.$$$reportNull$$$0(9);
        }
        for (String ignore : this.myNamespace) {
            ctx.exitNamespace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFlag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enterNamespace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exitNamespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class IncludePath {
        @NotNull
        private String myPath;
        private boolean myAngleBrackets;
        public static final IncludePath EMPTY = new EmptyIncludePath();
        public static final IncludePath FAKE = new FakeIncludePath();

        public IncludePath() {
        }

        public IncludePath(@NotNull String path, boolean angleBrackets) {
            if (path == null) {
                IncludePath.$$$reportNull$$$0(0);
            }
            this.myPath = path;
            this.myAngleBrackets = angleBrackets;
        }

        public String toString() {
            return this.myAngleBrackets ? "<" + this.myPath + ">" : "\"" + this.myPath + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IncludePath)) {
                return false;
            }
            IncludePath path = (IncludePath)o;
            if (this.myAngleBrackets != path.myAngleBrackets) {
                return false;
            }
            return this.myPath.equals(path.myPath);
        }

        public int hashCode() {
            int result = this.myPath.hashCode();
            result = 31 * result + (this.myAngleBrackets ? 1 : 0);
            return result;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                IncludePath.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAngleBrackets() {
            return this.myAngleBrackets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol$IncludePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol$IncludePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        private static final class EmptyIncludePath
        extends IncludePath {
            private EmptyIncludePath() {
                super("", false);
            }
        }

        private static final class FakeIncludePath
        extends IncludePath {
            private FakeIncludePath() {
                super("", false);
            }
        }
    }

    private static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag ONCE = new Flag();
        public static final /* enum */ Flag NEXT = new Flag();
        public static final /* enum */ Flag SYM_TABLE_USED = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String name) {
            return Enum.valueOf(Flag.class, name);
        }

        byte getMask() {
            int idx = this.ordinal();
            assert (idx < 7);
            return (byte)(1 << idx);
        }

        private static /* synthetic */ Flag[] $values() {
            return new Flag[]{ONCE, NEXT, SYM_TABLE_USED};
        }

        static {
            $VALUES = Flag.$values();
        }
    }
}

