/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.OCBestSymbolInSelectedConfiguration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase
implements OCSymbol,
MaybeVirtualFileOwner {
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@Nullable VirtualFile file, long complexOffset) {
        this.myFile = file;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        String string = symbol == null ? "<unnamed>" : symbol.getName();
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name = symbol.getPresentableName();
        if (name.startsWith(kind)) {
            String string = name.substring(kind.length());
            if (string == null) {
                OCSymbolBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project, @Nullable VirtualFile context) {
        if (symbolKind == null) {
            OCSymbolBase.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OCSymbolBase.$$$reportNull$$$0(4);
        }
        OCBestSymbolInSelectedConfiguration findBestInSelectedConfiguration = new OCBestSymbolInSelectedConfiguration(project, context);
        OCSymbolBase.findSymbolDefinition(name, symbolKind, project, context, findBestInSelectedConfiguration);
        return findBestInSelectedConfiguration.getBestCandidate();
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project, @Nullable VirtualFile context, @Nullable Condition<? super T> condition) {
        if (symbolKind == null) {
            OCSymbolBase.$$$reportNull$$$0(5);
        }
        if (project == null) {
            OCSymbolBase.$$$reportNull$$$0(6);
        }
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, name, (Condition<? super OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value(symbol))), context);
    }

    @Override
    public void init(@Nullable VirtualFile file) {
        this.myFile = file;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project) {
        if (project == null) {
            OCSymbolBase.$$$reportNull$$$0(7);
        }
        return OCSymbolBase.doLocateDefinition(this, project, this.getPsiElementClass());
    }

    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull OCSymbol symbol, @NotNull Project project, @NotNull Class<T> elementClass) {
        PsiFile file;
        if (symbol == null) {
            OCSymbolBase.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OCSymbolBase.$$$reportNull$$$0(9);
        }
        if (elementClass == null) {
            OCSymbolBase.$$$reportNull$$$0(10);
        }
        if ((file = symbol.getContainingPsiFile(project)) == null || !file.isValid()) {
            return null;
        }
        return OCSymbolBase.doLocateDefinition(elementClass, symbol.getComplexOffset(), file, symbol.isUnnamed());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull Class<T> elementClass, long symbolComplexOffset, PsiFile file, boolean bl) {
        PsiElement cur;
        if (elementClass == null) {
            OCSymbolBase.$$$reportNull$$$0(11);
        }
        if ((cur = file.findElementAt(OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset))) == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        do {
            long curComplexOffset;
            if ((curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur)) == symbolComplexOffset) {
                T definitionAtPrev;
                void unnamed;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (unnamed != false && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) == OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) continue;
            return null;
        } while ((cur = PsiTreeUtil.prevLeaf((PsiElement)cur)) != null);
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (elementClass == null) {
            OCSymbolBase.$$$reportNull$$$0(12);
        }
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    public String toString() {
        return this.getKind() + "[" + this.getPresentableName() + "]@" + (String)(this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Override
    public void setComplexOffset(long complexOffset) {
        this.myComplexOffset = complexOffset;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingOffset();
        result = 31 * result + (int)this.getComplexOffset();
        return result;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            OCSymbolBase.$$$reportNull$$$0(13);
        }
        return oCLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolBase";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagOfStructLike";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolBase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "locateDefinition";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doLocateDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findParentDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

