/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNameWithArguments
extends OCQualifiedName {
    @NotNull
    private List<OCTypeArgument> myArguments;

    public OCQualifiedNameWithArguments(@Nullable OCQualifiedName qualifier, @Nullable String name, @NotNull List<OCTypeArgument> arguments) {
        if (arguments == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(0);
        }
        super(qualifier, name);
        this.myArguments = arguments;
    }

    public OCQualifiedNameWithArguments() {
    }

    public OCQualifiedNameWithArguments(@NotNull OCQualifiedName qualifiedName, @NotNull List<OCTypeArgument> arguments) {
        if (qualifiedName == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(2);
        }
        this(qualifiedName.getQualifier(), qualifiedName.getName(), arguments);
    }

    @NotNull
    public List<OCTypeArgument> getArguments() {
        List<OCTypeArgument> list = this.myArguments;
        if (list == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public OCQualifiedName dropArguments() {
        return OCQualifiedName.with(this.myQualifier != null ? this.myQualifier.dropArguments() : null, this.myName);
    }

    @Override
    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return new OCQualifiedNameWithArguments(qualifier, this.myName, this.myArguments);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myArguments.hashCode();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (c == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(4);
        }
        if (first == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(5);
        }
        if (second == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(6);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCQualifiedNameWithArguments f = (OCQualifiedNameWithArguments)first;
        OCQualifiedNameWithArguments s = (OCQualifiedNameWithArguments)second;
        return c.equalLists(f.myArguments, s.myArguments);
    }

    @Override
    public final boolean canThisNamePartBeInterned() {
        return false;
    }

    @Override
    protected boolean resolvedEqualsStep(@NotNull OCQualifiedName other, @NotNull OCResolveContext context) {
        if (other == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(8);
        }
        if (!super.resolvedEqualsStep(other, context)) {
            return false;
        }
        assert (other instanceof OCQualifiedNameWithArguments);
        List<OCTypeArgument> otherArguments = ((OCQualifiedNameWithArguments)other).myArguments;
        if (this.myArguments.size() != otherArguments.size()) {
            return false;
        }
        for (Pair pair : ContainerUtil.zip(this.myArguments, otherArguments)) {
            if (((OCTypeArgument)pair.first).equals(pair.second, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        if (presentation == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(10);
        }
        return super.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + OCQualifiedNameWithArguments.getArgumentsText(this.myArguments, (Function<OCTypeArgument, String>)((Function)argument -> argument.getNameForPresentation(presentation, context, includeGlobalQualifier, templateDepth + 1)), templateDepth);
    }

    @Override
    public String getShortName(int templateDepth) {
        return super.getShortName(templateDepth) + OCQualifiedNameWithArguments.getArgumentsText(this.myArguments, (Function<OCTypeArgument, String>)((Function)argument -> argument.getShortName(templateDepth + 1)), templateDepth);
    }

    private static String getArgumentsText(List<OCTypeArgument> arguments, Function<OCTypeArgument, String> argFunc, int templateDepth) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append('<');
        if (templateDepth < 10) {
            Object args = StringUtil.join(arguments, argFunc, (String)", ");
            if (((String)args).startsWith("::")) {
                builder2.append(" ");
            }
            if (((String)args).length() > 300) {
                args = ((String)args).substring(0, 300) + "...";
            }
            builder2.append((String)args);
        } else {
            builder2.append("...");
        }
        builder2.append('>');
        return builder2.toString();
    }

    @Override
    public OCQualifiedName cloneWithOffset(@NotNull OCSymbolReference reference) {
        if (reference == null) {
            OCQualifiedNameWithArguments.$$$reportNull$$$0(11);
        }
        List arguments = ContainerUtil.map(this.myArguments, arg -> arg instanceof OCType ? OCTypeUtils.changeTypeReferences((OCType)arg, reference) : arg);
        return new OCQualifiedNameWithArguments(super.cloneWithOffset(reference), arguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCQualifiedNameWithArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolvedEqualsStep";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

