/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCPredefinedCodeStyleBase;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCQtCodeStyle
extends OCPredefinedCodeStyleBase {
    public OCQtCodeStyle() {
        super("Qt", "qt", OCLanguageUtils.getConfigLanguage());
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            OCQtCodeStyle.$$$reportNull$$$0(0);
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        OCQtCodeStyle.applyNamingConvention(ocSettings);
        commonSettings.KEEP_LINE_BREAKS = true;
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
        commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 1;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 2;
        commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 1;
        commonSettings.BLANK_LINES_BEFORE_IMPORTS = 0;
        commonSettings.BLANK_LINES_AFTER_IMPORTS = 0;
        commonSettings.BLANK_LINES_AROUND_CLASS = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD = 1;
        commonSettings.BLANK_LINES_AROUND_METHOD = 0;
        commonSettings.BLANK_LINES_BEFORE_METHOD_BODY = 0;
        commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
        ocSettings.BLANK_LINES_AROUND_NAMESPACE = 0;
        commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = false;
        commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS = false;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_AFTER_SEMICOLON = true;
        commonSettings.SPACE_BEFORE_SEMICOLON = false;
        commonSettings.SPACE_WITHIN_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.FINALLY_ON_NEW_LINE = true;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.WHILE_ON_NEW_LINE = true;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.FOR_BRACE_FORCE = 0;
        commonSettings.WHILE_BRACE_FORCE = 0;
        commonSettings.DOWHILE_BRACE_FORCE = 0;
        commonSettings.IF_BRACE_FORCE = 0;
        commonSettings.SPACE_WITHIN_BRACKETS = false;
        commonSettings.SPACE_WITHIN_BRACES = true;
        ocSettings.SPACE_WITHIN_EMPTY_BRACES = false;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
        commonSettings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES = false;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_CLASS_LBRACE = true;
        commonSettings.BINARY_OPERATION_WRAP = 1;
        commonSettings.ARRAY_INITIALIZER_WRAP = 1;
        commonSettings.ASSIGNMENT_WRAP = 1;
        commonSettings.TERNARY_OPERATION_WRAP = 1;
        commonSettings.METHOD_CALL_CHAIN_WRAP = 1;
        commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE = true;
        commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.FOR_STATEMENT_WRAP = 1;
        commonSettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = false;
        commonSettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = false;
        ocSettings.INDENT_NAMESPACE_MEMBERS = 0;
        ocSettings.INDENT_C_STRUCT_MEMBERS = 4;
        ocSettings.INDENT_CLASS_MEMBERS = 4;
        ocSettings.INDENT_VISIBILITY_KEYWORDS = 0;
        ocSettings.INDENT_INSIDE_CODE_BLOCK = 4;
        ocSettings.INDENT_PREPROCESSOR_DIRECTIVE = 0;
        ocSettings.KEEP_STRUCTURES_IN_ONE_LINE = true;
        commonSettings.BRACE_STYLE = 1;
        ocSettings.BLOCK_BRACE_PLACEMENT = 2;
        ocSettings.METHOD_BRACE_PLACEMENT = 2;
        ocSettings.FUNCTION_BRACE_PLACEMENT = 2;
        ocSettings.NAMESPACE_BRACE_PLACEMENT = 2;
        commonSettings.CLASS_BRACE_STYLE = 2;
        ocSettings.FUNCTION_PARAMETERS_WRAP = 5;
        ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
        ocSettings.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR = false;
        ocSettings.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR = false;
        ocSettings.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP = 5;
        ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
        ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = false;
        ocSettings.TEMPLATE_CALL_ARGUMENTS_WRAP = 5;
        ocSettings.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
        ocSettings.SPACE_BEFORE_SUPERCLASS_COLON = false;
        ocSettings.SPACE_AFTER_SUPERCLASS_COLON = true;
        ocSettings.SPACE_BEFORE_INIT_LIST_COLON = true;
        ocSettings.SPACE_AFTER_INIT_LIST_COLON = true;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE = true;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE = false;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON = 1;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON = 0;
        ocSettings.SPACE_BEFORE_TEMPLATE_CALL_LT = false;
        ocSettings.SPACE_WITHIN_TEMPLATE_CALL_LTGT = false;
        ocSettings.ALIGN_INIT_LIST_IN_COLUMNS = false;
        ocSettings.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE = false;
        ocSettings.SPACE_BEFORE_NAMESPACE_LBRACE = true;
        ocSettings.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_PROTOCOLS_BRACKETS = false;
        ocSettings.SPACE_BEFORE_INIT_LIST = false;
        ocSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS = false;
        ocSettings.SPACE_BEFORE_POINTER_IN_DECLARATION = true;
        ocSettings.SPACE_BEFORE_REFERENCE_IN_DECLARATION = true;
        ocSettings.SPACE_AFTER_POINTER_IN_DECLARATION = false;
        ocSettings.SPACE_AFTER_REFERENCE_IN_DECLARATION = false;
        ocSettings.SPACE_AFTER_REFERENCE_IN_RVALUE = false;
        ocSettings.SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR = false;
        ocSettings.SPACE_AROUND_PM_OPERATORS = false;
        assert (indentOptions != null);
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.TAB_SIZE = 4;
        indentOptions.KEEP_INDENTS_ON_EMPTY_LINES = false;
        super.apply(settings);
    }

    private static void applyNamingConvention(@NotNull OCCodeStyleSettings settings) {
        if (settings == null) {
            OCQtCodeStyle.$$$reportNull$$$0(1);
        }
        settings.HEADER_GUARD_STYLE_PATTERN = "${FILE_NAME}_${EXT}";
        settings.NAMING_CONVENTION_RULES = List.of(new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.NAMESPACE), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS, NamingConventionRule.EntityKind.ENUM, NamingConventionRule.EntityKind.UNION, NamingConventionRule.EntityKind.TYPEDEF), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.LOCAL_VARIABLE, NamingConventionRule.EntityKind.PARAMETER), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.CAMEL_CASE, ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/jetbrains/cidr/lang/settings/formatter/OCQtCodeStyle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNamingConvention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

