/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameFileProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCHeaderGuardUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class OCHeaderGuardRenameProcessor
extends RenamePsiElementProcessor
implements OCRenameProcessorExtension {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(0);
        }
        if (element instanceof OCFile) {
            return true;
        }
        OCSymbol symbolToRename = OCRenameUtil.getSymbolToRename(element);
        return symbolToRename != null && (symbolToRename instanceof OCStructSymbol || symbolToRename.getKind().isConstructorOrDestructor()) && OCRenameUtil.symbolHasSameNameWithFile(symbolToRename.getName(), symbolToRename.getKind(), element.getContainingFile()) && OCRenameUtil.shouldRenameSameClassOrFileEntity(element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        PsiFile file;
        if (element == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof OCFile) {
            OCHeaderGuardRenameProcessor.doPrepareRenaming((OCFile)element, allRenames, element.getProject());
            return;
        }
        OCSymbol symbolToRename = OCRenameUtil.getSymbolToRename(element);
        if (symbolToRename != null && (symbolToRename instanceof OCStructSymbol || symbolToRename.getKind().isConstructorOrDestructor()) && (file = element.getContainingFile()) instanceof OCFile) {
            OCHeaderGuardRenameProcessor.doPrepareRenaming((OCFile)file, allRenames, element.getProject());
        }
    }

    @Override
    public boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo) {
        PsiElement usageInfoElement;
        PsiFile file;
        if (elementToRename == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(4);
        }
        if (usageInfo == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(5);
        }
        PsiFile psiFile2 = file = (usageInfoElement = usageInfo.getElement()) != null ? usageInfoElement.getContainingFile() : null;
        if (file == null) {
            return false;
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findCachedHeaderGuard(file, false);
        return headerGuardInfo != null && usageInfoElement instanceof PsiComment && headerGuardInfo.getHeaderGuardName().equals(OCElementUtil.getCommentText((PsiComment)usageInfoElement).trim()) && headerGuardInfo.getEndifDirective() != null && PsiTreeUtil.isAncestor((PsiElement)headerGuardInfo.getEndifDirective(), (PsiElement)usageInfoElement, (boolean)true);
    }

    @Override
    public void findExtraVariants(@NotNull PsiFileSystemItem variant, @NotNull String newRootName, @NotNull OCRenameFileProcessor.VariantProcessor variantProcessor) {
        if (variant == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(6);
        }
        if (newRootName == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(7);
        }
        if (variantProcessor == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(8);
        }
    }

    private static void doPrepareRenaming(@NotNull OCFile file, @NotNull Map<PsiElement, String> allRenames, @NotNull Project project) {
        String newFilePath;
        OCFile headerFile;
        if (file == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(9);
        }
        if (allRenames == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(10);
        }
        if (project == null) {
            OCHeaderGuardRenameProcessor.$$$reportNull$$$0(11);
        }
        OCFile oCFile = headerFile = file.isHeader() ? file : file.getAssociatedFileWithSameName();
        if (headerFile == null) {
            return;
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findCachedHeaderGuard(headerFile, true);
        if (headerGuardInfo == null) {
            return;
        }
        String newHeaderName = allRenames.get(headerFile);
        if (newHeaderName == null) {
            return;
        }
        VirtualFile virtualFile = headerFile.getVirtualFile();
        String oldFilePath = virtualFile != null ? virtualFile.getPath() : file.getName();
        String string = newFilePath = virtualFile != null && virtualFile.getParent() != null ? FileUtil.join((String[])new String[]{virtualFile.getParent().getPath(), newHeaderName}) : newHeaderName;
        if (StringUtil.isEmpty((String)oldFilePath) || StringUtil.isEmpty((String)newFilePath)) {
            return;
        }
        String headerGuardStylePattern = ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
        if (!OCHeaderGuardUtil.headerGuardMatchesPattern((String)headerGuardInfo.getHeaderGuardName(), (String)headerGuardStylePattern, (String)oldFilePath, (Project)project)) {
            return;
        }
        String newHeaderGuardName = OCHeaderGuardUtil.buildHeaderGuardName((String)headerGuardStylePattern, (String)newFilePath, (Project)project);
        allRenames.put(headerGuardInfo.getDefineDirective(), newHeaderGuardName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRootName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCHeaderGuardRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "skipNonCodeUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findExtraVariants";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doPrepareRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

