/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.CVDecompositionResult;
import com.jetbrains.cidr.lang.quickfixes.CastStub;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionActionKt;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.quickfixes.RefTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0014J\b\u0010\u001a\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J*\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J#\u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0014H\u0096\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0007H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/quickfixes/OCInsertCastIntentionAction;", "Lcom/jetbrains/cidr/lang/quickfixes/OCPsiElementQuickFix;", "Lcom/jetbrains/cidr/lang/psi/OCExpression;", "expression", "type", "Lcom/jetbrains/cidr/lang/types/OCType;", "myInsertBridgeCast", "", "(Lcom/jetbrains/cidr/lang/psi/OCExpression;Lcom/jetbrains/cidr/lang/types/OCType;Z)V", "myNewType", "getCastStub", "Lcom/jetbrains/cidr/lang/quickfixes/CastStub;", "kind", "Lcom/jetbrains/cidr/lang/psi/OCCastKind;", "getCastText", "", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "getPreferredCastKind", "file", "project", "Lcom/intellij/openapi/project/Project;", "getTextInternal", "getTypeName", "insertBridgeCast", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "result", "Lcom/jetbrains/cidr/lang/psi/OCCastExpression;", "insertCast", "exprToCast", "invoke", "isEnum", "shouldCommitAllDocuments", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCInsertCastIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCInsertCastIntentionAction.kt\ncom/jetbrains/cidr/lang/quickfixes/OCInsertCastIntentionAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n11065#2:192\n11400#2,3:193\n1549#3:196\n1620#3,3:197\n*S KotlinDebug\n*F\n+ 1 OCInsertCastIntentionAction.kt\ncom/jetbrains/cidr/lang/quickfixes/OCInsertCastIntentionAction\n*L\n97#1:192\n97#1:193,3\n98#1:196\n98#1:197,3\n*E\n"})
public final class OCInsertCastIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private final boolean myInsertBridgeCast;
    @NotNull
    private final OCType myNewType;

    @JvmOverloads
    public OCInsertCastIntentionAction(@NotNull OCExpression expression, @NotNull OCType type, boolean myInsertBridgeCast) {
        OCType oCType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super((PsiElement)expression);
        this.myInsertBridgeCast = myInsertBridgeCast;
        if (type instanceof OCPointerType && type.isPointerToObject() && ((OCPointerType)type).getARCAttribute() != null) {
            OCPointerType oCPointerType = OCPointerType.to(((OCPointerType)type).getRefType());
            Intrinsics.checkNotNullExpressionValue((Object)oCPointerType, (String)"to(...)");
            oCType = oCPointerType;
        } else {
            oCType = type;
        }
        this.myNewType = oCType;
    }

    public /* synthetic */ OCInsertCastIntentionAction(OCExpression oCExpression, OCType oCType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(oCExpression, oCType, bl);
    }

    @Override
    @NotNull
    protected String getTextInternal() {
        Object[] objectArray = new Object[]{this.getTypeName()};
        String string = OCInspectionsBundle.message((String)"intention.name.cast.expression.to", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getTypeName() {
        OCExpression oCExpression = (OCExpression)this.myElementPtr.getElement();
        if (oCExpression == null) {
            String string = this.myNewType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        OCExpression expression = oCExpression;
        String string = this.myNewType.getName(OCResolveContext.forPsi(expression));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.cast.expression", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OCExpression oCExpression = (OCExpression)this.myElementPtr.getElement();
        if (oCExpression == null) {
            return;
        }
        OCExpression expression = oCExpression;
        this.insertCast(expression, this.getPreferredCastKind(file, expression, project), file, editor);
    }

    private final void insertCast(OCExpression exprToCast, OCCastKind kind, PsiFile file, Editor editor) {
        PsiElement psiElement;
        CastStub castStub = this.getCastStub(exprToCast, kind);
        OCCastExpression castExpr = castStub.component1();
        OCExpression operand = castStub.component2();
        OCTypeElement oCTypeElement = castExpr.getTypeElement();
        Intrinsics.checkNotNull((Object)oCTypeElement);
        oCTypeElement.replace(OCElementFactory.typeElementFromText(this.myNewType.getName(exprToCast), (PsiElement)file));
        PsiElement[] psiElementArray = exprToCast.getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        int index = ArraysKt.indexOf((Object[])psiElementArray, (Object)exprToCast);
        if (index == -1) {
            return;
        }
        PsiElement psiElement2 = exprToCast.getParent().copy().getChildren()[index];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"get(...)");
        PsiElement child = psiElement2;
        if (kind != OCCastKind.C_STYLE_CAST && child instanceof OCParenthesizedExpression) {
            OCExpression oCExpression = ((OCParenthesizedExpression)child).getOperand();
            if (oCExpression == null) {
                oCExpression = (OCExpression)child;
            }
            psiElement = oCExpression;
        } else {
            psiElement = child;
        }
        PsiElement toReplace = psiElement;
        OCChangeUtil.replaceHandlingMacros(operand, toReplace);
        PsiElement psiElement3 = OCChangeUtil.replaceHandlingMacros(exprToCast, castExpr);
        Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCCastExpression");
        OCCastExpression result = (OCCastExpression)psiElement3;
        if (this.myInsertBridgeCast && editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.insertBridgeCast(exprToCast, editor, result);
        }
    }

    private final CastStub getCastStub(OCExpression expression, OCCastKind kind) {
        OCExpression oCExpression;
        String castText = this.getCastText(kind);
        boolean addParens = kind != OCCastKind.C_STYLE_CAST || expression instanceof OCBinaryExpression || expression instanceof OCConditionalExpression;
        String operandText = addParens ? "(1)" : "1";
        OCExpression oCExpression2 = OCElementFactory.expressionFromText(castText + operandText, expression);
        Intrinsics.checkNotNull((Object)oCExpression2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCCastExpression");
        OCCastExpression castExpr = (OCCastExpression)oCExpression2;
        if (addParens && kind == OCCastKind.C_STYLE_CAST) {
            OCExpression oCExpression3 = castExpr.getOperand();
            Intrinsics.checkNotNull((Object)oCExpression3, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCParenthesizedExpression");
            OCExpression oCExpression4 = ((OCParenthesizedExpression)oCExpression3).getOperand();
            oCExpression = oCExpression4;
            Intrinsics.checkNotNull((Object)oCExpression4);
        } else {
            OCExpression oCExpression5 = castExpr.getOperand();
            oCExpression = oCExpression5;
            Intrinsics.checkNotNull((Object)oCExpression5);
        }
        OCExpression oCExpression6 = oCExpression;
        Intrinsics.checkNotNull((Object)oCExpression6);
        return new CastStub(castExpr, oCExpression6);
    }

    private final String getCastText(OCCastKind kind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1, 2, 3, 4 -> kind.getTokenText() + "<int>";
            case 5 -> {
                if (this.myInsertBridgeCast) {
                    yield "(__bridge int)";
                }
                yield "(int)";
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void insertBridgeCast(OCExpression expression, Editor editor, OCCastExpression result) {
        List list;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        IElementType[] types;
        PsiDocumentManager.getInstance((Project)expression.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement element = result.getNode().getChildren(OCTokenTypes.BRIDGE_CAST_KEYWORDS)[0].getPsi();
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(element);
        IElementType[] iElementTypeArray = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        IElementType[] $this$map$iv = types = iElementTypeArray;
        boolean $i$f$map = false;
        IElementType[] iElementTypeArray2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var16_19 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.parser.OCElementType");
            collection.add(((OCElementType)it).getName());
        }
        List typeNames = (List)destination$iv$iv;
        if (typeNames.size() <= 1) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = typeNames;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                it = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)p0));
            }
            list = (List)destination$iv$iv2;
        }
        List lookupElements = list;
        builder2.replaceElement(element, (Expression)new ConstantNode("__bridge").withLookupItems((Collection)lookupElements));
        builder2.run(editor, false);
    }

    private final OCCastKind getPreferredCastKind(PsiFile file, OCExpression expression, Project project) {
        if (this.myInsertBridgeCast || !(file instanceof OCFile) || !((OCFile)file).isCpp() || !((OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class)).USE_MODERN_CASTS) {
            return OCCastKind.C_STYLE_CAST;
        }
        OCResolveContext oCResolveContext = OCResolveContext.forPsi(expression);
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forPsi(...)");
        OCResolveContext context = oCResolveContext;
        OCType oldType = OCTypeUtils.decayType(expression.getResolvedType(context), project, false);
        Intrinsics.checkNotNull((Object)oldType);
        CVDecompositionResult oldDecomposed = OCInsertCastIntentionActionKt.access$decomposeCV(oldType, project);
        CVDecompositionResult newDecomposed = OCInsertCastIntentionActionKt.access$decomposeCV(this.myNewType, project);
        boolean isCastingAwayCV = !newDecomposed.getCv().isSuperset(oldDecomposed.getCv());
        RefTypes refDecomposed = OCInsertCastIntentionActionKt.access$getRefTypes(oldDecomposed.getType(), newDecomposed.getType(), expression, context);
        if (isCastingAwayCV && refDecomposed != null && refDecomposed.getOld().equals(refDecomposed.getNew(), context)) {
            return OCCastKind.CONST_CAST;
        }
        if (!isCastingAwayCV) {
            RefTypes refTypes = OCInsertCastIntentionActionKt.access$getRefTypes(oldType, this.myNewType, expression, context);
            boolean isDowncast = false;
            if (refTypes != null) {
                isDowncast = TypeProperties.IsDerivedFrom(refTypes.getNew(), refTypes.getOld(), context);
                if (isDowncast && OCTypeUtils.isPolymorphic(refTypes.getNew(), context)) {
                    return OCCastKind.DYNAMIC_CAST;
                }
            } else {
                isDowncast = false;
            }
            if (this.myNewType.isVoid() || refTypes != null && refTypes.isPointer() && (refTypes.getOld().isVoid() || refTypes.getNew().isVoid()) || isDowncast || this.isEnum(this.myNewType) && TypeProperties.isArithmeticType(oldType) || TypeProperties.isArithmeticType(this.myNewType) && this.isEnum(oldType) || !this.myNewType.checkCompatible(oldType, expression, expression, true, context).getState().isError(expression)) {
                return OCCastKind.STATIC_CAST;
            }
            if (oldType.isPointer() && TypeProperties.isIntegralType(this.myNewType, context) || TypeProperties.isIntegralType(oldType, context) && this.myNewType.isPointer() || oldType.isPointer() && this.myNewType.isPointer() || this.myNewType instanceof OCCppReferenceType && OCExprValueCategory.classify(expression, context).isLValue()) {
                return OCCastKind.REINTERPRET_CAST;
            }
        }
        return OCCastKind.C_STYLE_CAST;
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiElement psiElement = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCExpression");
        OCExpression expressionCopy = (OCExpression)psiElement;
        return (FileModifier)new OCInsertCastIntentionAction(expressionCopy, this.myNewType, this.myInsertBridgeCast);
    }

    private final boolean isEnum(OCType type) {
        return type instanceof OCStructType && ((OCStructType)type).isEnum();
    }

    @JvmOverloads
    public OCInsertCastIntentionAction(@NotNull OCExpression expression, @NotNull OCType type) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(expression, type, false, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OCCastKind.values().length];
            try {
                nArray[OCCastKind.STATIC_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCastKind.CONST_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCastKind.DYNAMIC_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCastKind.REINTERPRET_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCastKind.C_STYLE_CAST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

