/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0004\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/lang/quickfixes/OCAddFunctionSpecifierBase;", "", "myShouldInsert", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(ZLcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "mySpecifier", "Lcom/jetbrains/cidr/lang/parser/OCElementType;", "getMySpecifier", "()Lcom/jetbrains/cidr/lang/parser/OCElementType;", "getElementToInsert", "Lcom/intellij/psi/PsiElement;", "context", "project", "getInsertAfterAnchor", "element", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "getSpecifierElement", "invoke", "", "declarator", "Lcom/jetbrains/cidr/lang/psi/OCDeclarator;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddConstQualifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddConstexprSpecifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddExplicitSpecifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddNoexceptSpecifier;", "intellij.c"})
abstract class OCAddFunctionSpecifierBase {
    private final boolean myShouldInsert;
    @NotNull
    private final Project myProject;

    private OCAddFunctionSpecifierBase(boolean myShouldInsert, Project myProject) {
        this.myShouldInsert = myShouldInsert;
        this.myProject = myProject;
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected abstract OCElementType getMySpecifier();

    @Nullable
    public abstract PsiElement getSpecifierElement(@NotNull OCFunctionDeclaration var1);

    @Nullable
    public abstract PsiElement getInsertAfterAnchor(@NotNull OCFunctionDeclaration var1);

    @NotNull
    public PsiElement getElementToInsert(@NotNull PsiElement context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = OCElementFactory.createLeaf(PsiManager.getInstance((Project)project), this.getMySpecifier());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createLeaf(...)");
        return psiElement;
    }

    public final void invoke(@NotNull OCFunctionDeclaration element, @NotNull OCDeclarator declarator, @NotNull Project project) {
        boolean shouldDelete;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)declarator, (String)"declarator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement specifierElement = this.getSpecifierElement(element);
        boolean bl = shouldDelete = specifierElement != null && !this.myShouldInsert;
        if (specifierElement == null && this.myShouldInsert) {
            PsiElement nodeToInsert = this.getElementToInsert(element, project);
            PsiElement insertPt = this.getInsertAfterAnchor(element);
            if (insertPt == null) {
                PsiElement insertedElem = OCChangeUtil.addBefore(element, nodeToInsert, element.getTypeElement());
                OCChangeUtil.addAfter(element, OCElementFactory.spaceFromText(element), insertedElem);
            } else {
                OCChangeUtil.addAfter(declarator, nodeToInsert, insertPt);
                OCChangeUtil.addAfter(declarator, OCElementFactory.spaceFromText(element), insertPt);
            }
        } else if (shouldDelete) {
            OCChangeUtil.delete(specifierElement);
        }
    }

    public /* synthetic */ OCAddFunctionSpecifierBase(boolean myShouldInsert, Project myProject, DefaultConstructorMarker $constructor_marker) {
        this(myShouldInsert, myProject);
    }
}

