/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCDefineDirectiveImpl
extends OCDirectiveImpl
implements OCDefineDirective {
    public OCDefineDirectiveImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public String getName() {
        OCMacroSymbol def = this.getSymbol();
        String string = OCSymbolBase.getSymbolName(def);
        if (string == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public OCMacroSymbol getSymbol() {
        PsiElement identifier;
        if (this.isValid() && (identifier = this.getNameIdentifier()) != null) {
            int offset = identifier.getTextOffset() - super.getTextOffset();
            String text = this.getText();
            if (offset > 0 && offset < text.length()) {
                return OCMacroSymbol.parseFromDirectiveContent(text.substring(offset), OCFileUtil.getVirtualFile(this.getContainingOCFile()), OCSymbolOffsetUtil.getComplexOffset(identifier));
            }
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
    }

    @Override
    public OCMacroParameterList getMacroParameters() {
        return (OCMacroParameterList)this.findChildByType((IElementType)OCElementTypes.MACRO_PARAMETER_LIST);
    }

    @Override
    public int getTextOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getTextOffset();
        }
        return content.getNode().getStartOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset(content);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(2);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(3);
        }
        visitor.visitDefineDirective(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCDefineDirectiveImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCDefineDirectiveImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

