/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public final class OCSimpleIfEvaluator {
    public static Boolean evaluate(@NotNull CharSequence exprChars, @NotNull OCInclusionContext context) {
        Queue<Term> postfix;
        if (exprChars == null) {
            OCSimpleIfEvaluator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCSimpleIfEvaluator.$$$reportNull$$$0(1);
        }
        if ((postfix = OCSimpleIfEvaluator.parseToPostfix(exprChars, context)) == null) {
            return null;
        }
        return OCSimpleIfEvaluator.evaluate(postfix, context);
    }

    public static Queue<Term> parseToPostfix(@NotNull CharSequence exprChars, OCInclusionContext context) {
        if (exprChars == null) {
            OCSimpleIfEvaluator.$$$reportNull$$$0(2);
        }
        OCLexer lexer = new OCLexer(OCLanguageUtils.createLexerSettingsForContext(context));
        lexer.start(exprChars);
        LinkedList<Term> result = new LinkedList<Term>();
        Stack termStack = new Stack();
        boolean prevWasExpr = false;
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            String text = lexer.getTokenText();
            lexer.advance();
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) continue;
            if (OCTokenTypes.ALL_NUMERIC.contains(tt)) {
                if (prevWasExpr) {
                    return null;
                }
                result.add(new Term(tt, text));
                prevWasExpr = true;
                continue;
            }
            if (tt == OCTokenTypes.LPAR) {
                if (prevWasExpr) {
                    return null;
                }
                termStack.push((Object)new Term(tt, text));
                continue;
            }
            if (tt == OCTokenTypes.RPAR) {
                while (!termStack.isEmpty() && ((Term)termStack.peek()).type != OCTokenTypes.LPAR) {
                    result.add((Term)termStack.pop());
                }
                if (termStack.isEmpty() || ((Term)termStack.peek()).type != OCTokenTypes.LPAR) {
                    return null;
                }
                termStack.pop();
                prevWasExpr = true;
                continue;
            }
            if (OCSimpleIfEvaluator.isOp(tt)) {
                if (!prevWasExpr && !OCTokenTypes.UNARY_OPERATIONS.contains(tt)) {
                    return null;
                }
                boolean isBinary = OCTokenTypes.BINARY_OPERATIONS.contains(tt) && prevWasExpr;
                Term term = new Term(tt, text, isBinary);
                if (OCSimpleIfEvaluator.isOpOnTop((Stack<Term>)termStack) && isBinary) {
                    while (OCSimpleIfEvaluator.isOpOnTop((Stack<Term>)termStack) && ((Term)termStack.peek()).getPrecedence() <= term.getPrecedence()) {
                        result.add((Term)termStack.pop());
                    }
                }
                termStack.push((Object)term);
                prevWasExpr = false;
                continue;
            }
            return null;
        }
        while (!termStack.isEmpty()) {
            result.add((Term)termStack.pop());
        }
        return result;
    }

    public static Boolean evaluate(@NotNull Queue<Term> postfixExpr, @NotNull OCInclusionContext context) {
        if (postfixExpr == null) {
            OCSimpleIfEvaluator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCSimpleIfEvaluator.$$$reportNull$$$0(4);
        }
        OCExpressionEvaluator.ValueEvaluator evaluator = new OCExpressionEvaluator.ValueEvaluator((PsiElement)context.getRootFile());
        Stack valueStack = new Stack();
        while (!postfixExpr.isEmpty()) {
            Term term = postfixExpr.poll();
            OCElementType tt = term.type;
            if (OCSimpleIfEvaluator.isOp((IElementType)tt)) {
                if (OCSimpleIfEvaluator.evalOp(term, (Stack<Object>)valueStack, evaluator)) continue;
                return null;
            }
            Object value = OCElementUtil.getConstValue((IElementType)tt, term.text, null, context, context.getProject());
            valueStack.push(value);
        }
        if (valueStack.size() != 1) {
            return null;
        }
        Object eval = valueStack.pop();
        return OCExpressionEvaluator.singAsInC(eval) != 0;
    }

    public static boolean isOp(IElementType tt) {
        return OCTokenTypes.BINARY_OPERATIONS.contains(tt) || OCTokenTypes.UNARY_OPERATIONS.contains(tt);
    }

    private static boolean isOpOnTop(Stack<Term> termStack) {
        return !termStack.isEmpty() && ((Term)termStack.peek()).type != OCTokenTypes.LPAR;
    }

    private static boolean evalOp(Term op, Stack<Object> valueStack, OCExpressionEvaluator.ValueEvaluator evaluator) {
        Object result;
        if (valueStack.empty()) {
            return false;
        }
        Object arg1 = valueStack.pop();
        OCElementType tt = op.type;
        if (op.binaryOp) {
            if (valueStack.empty()) {
                return false;
            }
            Object arg2 = valueStack.pop();
            result = evaluator.evalBinary(tt, arg2, arg1);
        } else {
            result = evaluator.evalUnary(tt, arg1);
        }
        valueStack.push(result);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprChars";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpr";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCSimpleIfEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseToPostfix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Term {
        public final OCElementType type;
        public final String text;
        final boolean binaryOp;

        Term(IElementType type, String text) {
            this(type, text, false);
        }

        Term(IElementType type, String text, boolean binaryOp) {
            this.type = (OCElementType)type;
            this.text = text;
            this.binaryOp = binaryOp;
        }

        public int getPrecedence() {
            return this.binaryOp ? OCParenthesesUtils.getBinaryPrecedence(this.type) : OCParenthesesUtils.getPrecedence(this.type);
        }
    }
}

