/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.MapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCContextChanges;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class OCHeaderContextCache {
    private final Map<VirtualFile, OCImmutableInclusionContext> myCache = ContainerUtil.createConcurrentSoftValueMap();

    @NotNull
    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file, @Nullable OCLanguageKind languageKind) {
        PsiFile original;
        if (file == null) {
            OCHeaderContextCache.$$$reportNull$$$0(0);
        }
        if ((original = OCFileUtil.getOriginalFile(file)) == null) {
            OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file);
            if (oCInclusionContext == null) {
                OCHeaderContextCache.$$$reportNull$$$0(1);
            }
            return oCInclusionContext;
        }
        return OCHeaderContextCache.innerCalculateHeaderContext(original, languageKind);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file) {
        PsiFile original;
        if (file == null) {
            OCHeaderContextCache.$$$reportNull$$$0(2);
        }
        if ((original = OCFileUtil.getOriginalFile(file)) == null) {
            OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(null, file);
            if (oCInclusionContext == null) {
                OCHeaderContextCache.$$$reportNull$$$0(3);
            }
            return oCInclusionContext;
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(original);
        Map<VirtualFile, OCImmutableInclusionContext> cache = OCHeaderContextCache.getHeaderContextCache(project);
        OCImmutableInclusionContext cached = cache.get(virtualFile);
        if (cached != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = cached;
            if (oCImmutableInclusionContext == null) {
                OCHeaderContextCache.$$$reportNull$$$0(4);
            }
            return oCImmutableInclusionContext;
        }
        OCInclusionContext result = OCHeaderContextCache.innerCalculateHeaderContext(original, null);
        cache.put(virtualFile, result);
        OCInclusionContext oCInclusionContext = result;
        if (oCInclusionContext == null) {
            OCHeaderContextCache.$$$reportNull$$$0(5);
        }
        return oCInclusionContext;
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            OCHeaderContextCache.$$$reportNull$$$0(6);
        }
        MapUtil.removeExcept(OCHeaderContextCache.getHeaderContextCache(project), virtualFile);
        OCContextChanges.invalidateContextChangeCacheExcept(virtualFile, project);
    }

    @NotNull
    private static Map<VirtualFile, OCImmutableInclusionContext> getHeaderContextCache(@NotNull Project project) {
        if (project == null) {
            OCHeaderContextCache.$$$reportNull$$$0(7);
        }
        Map<VirtualFile, OCImmutableInclusionContext> map2 = ((OCHeaderContextCache)project.getService(OCHeaderContextCache.class)).myCache;
        if (map2 == null) {
            OCHeaderContextCache.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        if (original == null) {
            OCHeaderContextCache.$$$reportNull$$$0(9);
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(original);
        if (OCRootKind.getRootKind(virtualFile, project) == OCRootKind.Include) {
            PsiFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(virtualFile);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            PsiFile psiFile2 = importHolder = rootFile != null && rootFile.isValid() ? OCLanguageUtils.asFileWithOCResolve(project, rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile)) {
                OCResolveConfiguration config = rootAndConfiguration.getConfiguration();
                if (config != null) {
                    OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                    if (precompiledContext == null) {
                        OCLanguageKind importHolderKind = OCPsiFile.getKind(importHolder);
                        assert (importHolderKind != null) : "file without OC resolve";
                        precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolderKind, importHolder);
                    } else {
                        precompiledContext = precompiledContext.getParent();
                        assert (precompiledContext != null && precompiledContext.getParent() == null);
                    }
                    OCInclusionContext result = precompiledContext.derive(importHolder);
                    result.preprocessContextOf(importHolder, virtualFile);
                    OCInclusionContext oCInclusionContext = result;
                    if (oCInclusionContext == null) {
                        OCHeaderContextCache.$$$reportNull$$$0(10);
                    }
                    return oCInclusionContext;
                }
            } else if (kind == null) {
                kind = rootAndConfiguration.getKind();
            }
        }
        return OCHeaderContextCache.sourceFileContext(original, kind);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull PsiFile file, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        if (file == null) {
            OCHeaderContextCache.$$$reportNull$$$0(11);
        }
        if (kindOrNullForDefault == null) {
            OCLanguageKind kind = OCPsiFile.getKind(file);
            assert (kind != null) : "file without OC resolve";
            kindOrNullForDefault = kind;
        }
        if ((config = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)OCFileUtil.getVirtualFile(file), (Project)file.getProject())) != null) {
            OCInclusionContext oCInclusionContext = OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file);
            if (oCInclusionContext == null) {
                OCHeaderContextCache.$$$reportNull$$$0(12);
            }
            return oCInclusionContext;
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file);
        if (oCInclusionContext == null) {
            OCHeaderContextCache.$$$reportNull$$$0(13);
        }
        return oCInclusionContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 8, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCHeaderContextCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCHeaderContextCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHeaderContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "headerContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderContextCache";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "innerCalculateHeaderContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFileContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateHeaderContext";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "headerContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderContextsExcept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderContextCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "innerCalculateHeaderContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sourceFileContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 8, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

