/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.symbols.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.resolve.AppCodeModuleMapApplePlatformType;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleCacheBuilderStatisticsCollector;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleCacheBuilderStatisticsCollectorFactory;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleCacheBuilderStatisticsService;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.StatisticsDumper;
import com.jetbrains.cidr.lang.util.TeamCityLogApi;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J#\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\b\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\rR(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectors", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsCollector;", "getProject", "()Lcom/intellij/openapi/project/Project;", "deinit", "", "dumpDataAndCollectErrors", "", "", "platform", "Lcom/jetbrains/cidr/lang/modulemap/resolve/AppCodeModuleMapApplePlatformType;", "getCollector", "T", "key", "(Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsCollector;", "init", "Companion", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nModuleCacheBuilderStatisticsCollectorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleCacheBuilderStatisticsCollectorFactory.kt\ncom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,89:1\n8406#2,2:90\n9088#2,4:92\n1313#3,2:96\n*S KotlinDebug\n*F\n+ 1 ModuleCacheBuilderStatisticsCollectorFactory.kt\ncom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService\n*L\n51#1:90,2\n51#1:92,4\n64#1:96,2\n*E\n"})
public final class ModuleCacheBuilderStatisticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<Map<Key<? extends ModuleCacheBuilderStatisticsCollector>, ModuleCacheBuilderStatisticsCollector>> collectors;
    @NotNull
    private static final ExtensionPointName<ModuleCacheBuilderStatisticsCollectorFactory<?>> EP_NAME = ExtensionPointName.Companion.create("cidr.lang.moduleBuilder.statisticsCollectorFactory");

    public ModuleCacheBuilderStatisticsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.collectors = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void $this$associateTo$iv$iv;
        Object[] $this$associate$iv = EP_NAME.getExtensions();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        Object[] objectArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ModuleCacheBuilderStatisticsCollectorFactory it = (ModuleCacheBuilderStatisticsCollectorFactory)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getUniqueKey(), it.createCollector(this.project));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map collectors = destination$iv$iv;
        this.collectors.set(collectors);
    }

    public final void deinit() {
        this.collectors.set(null);
    }

    @NotNull
    public final List<String> dumpDataAndCollectErrors(@NotNull AppCodeModuleMapApplePlatformType platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Collection<ModuleCacheBuilderStatisticsCollector> collectors = this.collectors.get().values();
        TeamCityLogApi teamCityLogApi = TeamCityLogApi.Companion.getInstance();
        String tempDirectory = teamCityLogApi.getTempDirectory();
        List errors = new ArrayList();
        Sequence $this$forEach$iv = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)collectors), (Function1)dumpDataAndCollectErrors.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsDumper dumper = (StatisticsDumper)element$iv;
            boolean bl = false;
            String fileName = dumper.getFileName(platform);
            Path path = Path.of(tempDirectory, new String[0]).resolve("statistics").resolve(fileName);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathKt.createParentDirectories((Path)path), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            }
            try {
                if (dumper.dumpData(path)) {
                    teamCityLogApi.publishArtifact(((Object)path).toString());
                }
            }
            catch (IOException e) {
                OCLog.LOG.error((Throwable)e);
            }
            String error = dumper.getError(platform);
            UtilKt.addIfNotNull((List)errors, (Object)error);
        }
        return errors;
    }

    @NotNull
    public final <T extends ModuleCacheBuilderStatisticsCollector> T getCollector(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Map<Key<? extends ModuleCacheBuilderStatisticsCollector>, ModuleCacheBuilderStatisticsCollector> map2 = this.collectors.get();
        ModuleCacheBuilderStatisticsCollector moduleCacheBuilderStatisticsCollector = map2 != null ? map2.get(key) : null;
        ModuleCacheBuilderStatisticsCollector moduleCacheBuilderStatisticsCollector2 = moduleCacheBuilderStatisticsCollector instanceof ModuleCacheBuilderStatisticsCollector ? moduleCacheBuilderStatisticsCollector : null;
        if (moduleCacheBuilderStatisticsCollector2 == null) {
            throw new AssertionError((Object)("Missing collector for " + key));
        }
        return (T)moduleCacheBuilderStatisticsCollector2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsCollectorFactory;", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nModuleCacheBuilderStatisticsCollectorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleCacheBuilderStatisticsCollectorFactory.kt\ncom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,89:1\n31#2,2:90\n*S KotlinDebug\n*F\n+ 1 ModuleCacheBuilderStatisticsCollectorFactory.kt\ncom/jetbrains/cidr/lang/modulemap/symbols/impl/ModuleCacheBuilderStatisticsService$Companion\n*L\n45#1:90,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleCacheBuilderStatisticsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ModuleCacheBuilderStatisticsService> serviceClass$iv = ModuleCacheBuilderStatisticsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleCacheBuilderStatisticsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

