/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "", "()V", "moduleMapLocationsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "searchRootPath", "", "getSearchRootPath", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "buildPossibleModuleMapLocations", "headersSearchRoot", "clear", "", "getPossibleModuleMapLocations", "moduleMapRoot", "Companion", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nModuleMapLocationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1855#2,2:46\n*S KotlinDebug\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache\n*L\n29#1:46,2\n*E\n"})
public final class ModuleMapLocationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<ModuleMapRoot, Collection<HeadersSearchRoot>> moduleMapLocationsCache;

    public ModuleMapLocationCache() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.moduleMapLocationsCache = concurrentMap;
    }

    @NotNull
    public final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull ModuleMapRoot moduleMapRoot) {
        Intrinsics.checkNotNullParameter((Object)moduleMapRoot, (String)"moduleMapRoot");
        Collection collection = this.moduleMapLocationsCache.computeIfAbsent(moduleMapRoot, arg_0 -> ModuleMapLocationCache.getPossibleModuleMapLocations$lambda$0((Function1)new Function1<ModuleMapRoot, Collection<? extends HeadersSearchRoot>>(this){
            final /* synthetic */ ModuleMapLocationCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Collection<HeadersSearchRoot> invoke(ModuleMapRoot root) {
                return ModuleMapLocationCache.access$buildPossibleModuleMapLocations(this.this$0, root.getRoot());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"computeIfAbsent(...)");
        return collection;
    }

    private final Collection<HeadersSearchRoot> buildPossibleModuleMapLocations(HeadersSearchRoot headersSearchRoot) {
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Collecting possible module map locations for " + this.getSearchRootPath(headersSearchRoot));
        }
        Collection<HeadersSearchRoot> possibleLocations = ModuleMapUtil.getPossibleModuleMapLocations(headersSearchRoot);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            Iterable $this$forEach$iv = possibleLocations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeadersSearchRoot possibleLocation = (HeadersSearchRoot)element$iv;
                boolean bl = false;
                ModuleMapLog.LOG.trace("  found possible location " + this.getSearchRootPath(possibleLocation));
            }
        }
        return possibleLocations;
    }

    private final String getSearchRootPath(HeadersSearchRoot $this$searchRootPath) {
        VirtualFile virtualFile = $this$searchRootPath.getVirtualFile();
        String string = virtualFile != null ? virtualFile.getPath() : null;
        if (string == null) {
            String string2 = $this$searchRootPath.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    public final void clear() {
        this.moduleMapLocationsCache.clear();
    }

    private static final Collection getPossibleModuleMapLocations$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Collection access$buildPossibleModuleMapLocations(ModuleMapLocationCache $this, HeadersSearchRoot headersSearchRoot) {
        return $this.buildPossibleModuleMapLocations(headersSearchRoot);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nModuleMapLocationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,45:1\n31#2,2:46\n*S KotlinDebug\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion\n*L\n43#1:46,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleMapLocationCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ModuleMapLocationCache> serviceClass$iv = ModuleMapLocationCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleMapLocationCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

