/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludeImportVisitor;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a:\u0010\u0000\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\u0012"}, d2={"processImportsRecursivelySkippingNonModuleHeaders", "", "table", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable;", "context", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "visitor", "Lcom/jetbrains/cidr/lang/modulemap/resolve/IncludeImportVisitor;", "pathResolver", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPathResolver;", "headers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/preprocessor/OCImmutableInclusionContext;", "serializationSession", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "intellij.c"})
public final class ModuleMapResolveUtilKt {
    private static final void processImportsRecursivelySkippingNonModuleHeaders(FileSymbolTable table, OCInclusionContext context, IncludeImportVisitor visitor, ModuleMapPathResolver pathResolver) {
        Predicate<VirtualFile> dontGoOutOfCurrentModule = arg_0 -> ModuleMapResolveUtilKt.processImportsRecursivelySkippingNonModuleHeaders$lambda$0(pathResolver, arg_0);
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(context, true, dontGoOutOfCurrentModule, (Predicate)Predicates.alwaysFalse());
        table.processSymbols((Processor<OCSymbol>)((Processor)arg_0 -> ModuleMapResolveUtilKt.processImportsRecursivelySkippingNonModuleHeaders$processSymbol(visitor, arg_0)), null, state, null, null, null);
    }

    public static final void processImportsRecursivelySkippingNonModuleHeaders(@NotNull List<? extends VirtualFile> headers, @NotNull ModuleMapSymbol module2, @NotNull OCImmutableInclusionContext context, @Nullable SerializationSession serializationSession, @NotNull IncludeImportVisitor visitor) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        ModuleMapPathResolver pathResolver = module2.getPathResolver();
        for (VirtualFile virtualFile : headers) {
            FileSymbolTable table;
            PsiFile psiHeader;
            OCInclusionContext headerContext;
            Intrinsics.checkNotNullExpressionValue((Object)context.derive(), (String)"derive(...)");
            if (!headerContext.reserveInclude(virtualFile, true) || OCLanguageUtils.asFileWithOCResolve(psiManager2.findFile(virtualFile)) == null || FileSymbolTable.forFile(psiHeader, headerContext, serializationSession) == null) continue;
            ModuleMapResolveUtilKt.processImportsRecursivelySkippingNonModuleHeaders(table, headerContext, visitor, pathResolver);
        }
    }

    public static /* synthetic */ void processImportsRecursivelySkippingNonModuleHeaders$default(List list, ModuleMapSymbol moduleMapSymbol, OCImmutableInclusionContext oCImmutableInclusionContext, SerializationSession serializationSession, IncludeImportVisitor includeImportVisitor, int n, Object object) {
        if ((n & 8) != 0) {
            serializationSession = null;
        }
        ModuleMapResolveUtilKt.processImportsRecursivelySkippingNonModuleHeaders(list, moduleMapSymbol, oCImmutableInclusionContext, serializationSession, includeImportVisitor);
    }

    private static final boolean processImportsRecursivelySkippingNonModuleHeaders$lambda$0(ModuleMapPathResolver $pathResolver, VirtualFile targetFile) {
        Intrinsics.checkNotNullParameter((Object)$pathResolver, (String)"$pathResolver");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        return $pathResolver.containsHeader(targetFile);
    }

    private static final boolean processImportsRecursivelySkippingNonModuleHeaders$processSymbol(IncludeImportVisitor $visitor, OCSymbol symbol) {
        OCSymbol oCSymbol = symbol;
        if (oCSymbol instanceof OCModuleImportSymbol) {
            $visitor.visitImport((OCModuleImportSymbol)symbol);
        } else if (oCSymbol instanceof OCIncludeSymbol) {
            $visitor.visitInclude((OCIncludeSymbol)symbol);
        }
        return true;
    }
}

