/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSplitFunctionIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.split.function", (Object[])new Object[0]);
        if (string == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)file)) {
            return false;
        }
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file);
        return function != null && function.getNamespaceQualifier() == null;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(3);
        }
        if (file == null || editor == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final Ref result = Ref.create();
        new Task.Modal(project, OCInspectionsBundle.message((String)"intentions.split.function.progress.text", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> result.set((Object)OCSplitFunctionIntentionAction.prepareData(project, editor, file)), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/intentions/OCSplitFunctionIntentionAction$1", "run"));
            }
        }.queue();
        if (result.isNull()) {
            throw new ProcessCanceledException();
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>(2);
        files.add(file);
        files.add(((SplitFunctionData)result.get()).pos.file);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> OCSplitFunctionIntentionAction.doSplit(project, (SplitFunctionData)result.get()), (PsiFile[])files.toArray(PsiFile.EMPTY_ARRAY));
    }

    @Nullable
    private static SplitFunctionData prepareData(@NotNull Project project, Editor editor, PsiFile file) {
        OCFunctionSymbol symbol;
        if (project == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file);
        OCFunctionSymbol oCFunctionSymbol = symbol = function != null ? function.getSymbol() : null;
        if (symbol == null) {
            return null;
        }
        Document declarationDocument = psiDocumentManager.getDocument(function.getContainingFile());
        if (declarationDocument == null) {
            return null;
        }
        TextRange oldBodyRange = OCSplitFunctionIntentionAction.getBodyRange(function);
        if (oldBodyRange == null) {
            return null;
        }
        OCGenerateUtil.ReplacePosition pos = OCCppDefinitionsUtil.getOutsidePreferredPosition(file, OCCppDefinitionsUtil.getFunctionParent(symbol, project), Collections.singletonList(symbol));
        if (pos == null) {
            return null;
        }
        Document definitionDocument = psiDocumentManager.getDocument(pos.file);
        if (definitionDocument == null) {
            return null;
        }
        String definitionSignature = (OCGenerateUtil.shouldInsertNewLineBefore(definitionDocument.getCharsSequence(), pos.range.getStartOffset()) ? "\n" : "") + OCCppDefinitionsUtil.functionSignature(symbol, true, pos.context);
        String bodyText = declarationDocument.getText(oldBodyRange) + (OCGenerateUtil.shouldInsertNewLineAfter(definitionDocument.getCharsSequence(), pos.range.getEndOffset()) ? "\n" : "");
        return new SplitFunctionData(declarationDocument, oldBodyRange, pos, definitionDocument, definitionSignature, bodyText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSplit(@NotNull Project project, @NotNull SplitFunctionData d) {
        if (project == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(5);
        }
        if (d == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(6);
        }
        RangeMarker newLocation = null;
        RangeMarker signature2 = null;
        RangeMarker body = null;
        try {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(d.declarationDocument);
            if (d.declarationDocument != d.definitionDocument) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(d.definitionDocument);
            }
            newLocation = d.definitionDocument.createRangeMarker(d.pos.range);
            d.declarationDocument.replaceString(d.oldBodyRange.getStartOffset(), d.oldBodyRange.getEndOffset(), (CharSequence)";");
            int definitionOffset = newLocation.getStartOffset();
            d.definitionDocument.deleteString(newLocation.getStartOffset(), newLocation.getEndOffset());
            signature2 = d.definitionDocument.createRangeMarker(definitionOffset, definitionOffset);
            signature2.setGreedyToRight(true);
            d.definitionDocument.insertString(definitionOffset, (CharSequence)d.definitionSignature);
            signature2.setGreedyToRight(false);
            body = d.definitionDocument.createRangeMarker(signature2.getEndOffset(), signature2.getEndOffset());
            body.setGreedyToRight(true);
            d.definitionDocument.insertString(body.getStartOffset(), (CharSequence)d.bodyText);
            body.setGreedyToRight(false);
            psiDocumentManager.commitDocument(d.definitionDocument);
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, signature2.getStartOffset(), signature2.getEndOffset());
            psiDocumentManager.commitDocument(d.definitionDocument);
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, body.getStartOffset(), body.getStartOffset() + 1);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(d.pos.file, TextRange.create((int)body.getStartOffset(), (int)body.getEndOffset()));
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, body.getEndOffset(), CharArrayUtil.shiftForward((CharSequence)d.definitionDocument.getCharsSequence(), (int)body.getEndOffset(), (String)" \t\n"));
            psiDocumentManager.commitDocument(d.declarationDocument);
            OCFunctionDeclaration func = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)d.pos.file.findElementAt(signature2.getEndOffset()), OCFunctionDeclaration.class);
            PsiElement identifier = func != null ? func.getNameIdentifier() : null;
            OCCodeInsightUtil.openInEditor((PsiElement)ObjectUtils.notNull((Object)identifier, (Object)d.pos.file));
        }
        finally {
            if (body != null) {
                body.dispose();
            }
            if (signature2 != null) {
                signature2.dispose();
            }
            if (newLocation != null) {
                newLocation.dispose();
            }
        }
    }

    @Nullable
    private static TextRange getBodyRange(@NotNull OCFunctionDefinition function) {
        OCDeclarator lastElementToKeep;
        OCConstructorInitializationList initializationList;
        if (function == null) {
            OCSplitFunctionIntentionAction.$$$reportNull$$$0(7);
        }
        if ((initializationList = function.getConstructorInitializationList()) != null) {
            PsiElement cur;
            for (cur = initializationList.getPrevSibling(); !(cur == null || OCElementUtil.isElementSignificant(cur) && OCElementUtil.getElementType(cur) != OCTokenTypes.COLON); cur = cur.getPrevSibling()) {
            }
            lastElementToKeep = cur;
        } else {
            lastElementToKeep = function.getDeclarator();
        }
        if (lastElementToKeep == null) {
            return null;
        }
        return TextRange.create((int)OCElementUtil.getRangeWithMacros(lastElementToKeep).getEndOffset(), (int)function.getTextRange().getEndOffset());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static OCFunctionDefinition getFunction(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDefinition.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSplitFunctionIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSplitFunctionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSplit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBodyRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static final class SplitFunctionData {
        public final Document declarationDocument;
        public final TextRange oldBodyRange;
        public final OCGenerateUtil.ReplacePosition pos;
        public final Document definitionDocument;
        public final String definitionSignature;
        public final String bodyText;

        private SplitFunctionData(Document declarationDocument, TextRange oldBodyRange, OCGenerateUtil.ReplacePosition pos, Document definitionDocument, String definitionSignature, String bodyText) {
            this.declarationDocument = declarationDocument;
            this.oldBodyRange = oldBodyRange;
            this.pos = pos;
            this.definitionDocument = definitionDocument;
            this.definitionSignature = definitionSignature;
            this.bodyText = bodyText;
        }
    }
}

