/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCRemoveSuppressionIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.remove.suppression", (Object[])new Object[0]);
        if (string == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static OCPragma getPragma(PsiElement element) {
        OCPragma pragma = OCElementUtil.getPragmaAt(element);
        return pragma == null || pragma.parsePragma() == null ? null : pragma;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(3);
        }
        return element.isValid() && OCRemoveSuppressionIntentionAction.getPragma(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(5);
        }
        OCFile file = (OCFile)element.getContainingFile();
        Document document = editor.getDocument();
        OCPragma pragma = OCRemoveSuppressionIntentionAction.getPragma(element);
        if (pragma == null) {
            return;
        }
        Pair<OCPragma.Mode, String> pair = pragma.parsePragma();
        int pragmaTextOffset = OCElementUtil.getRangeWithMacros(pragma).getStartOffset();
        OCPragmaSuppressionUtils.Scope scope = OCPragmaSuppressionUtils.findScope(file, pragmaTextOffset);
        if (pair != null) {
            if (pair.first == OCPragma.Mode.PUSH || pair.first == OCPragma.Mode.POP || !scope.isTopLevel() && scope.getOwnSettingsCnt() <= 1) {
                OCRemoveSuppressionIntentionAction.removeScope(document, scope);
            } else {
                OCRemoveSuppressionIntentionAction.removePragma(document, pragmaTextOffset, scope);
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    private static void removePragma(Document document, int pragmaTextOffset, OCPragmaSuppressionUtils.Scope scope) {
        for (Pair pair : scope.getSettings().values()) {
            if (((TextRange)pair.first).getStartOffset() != pragmaTextOffset) continue;
            document.deleteString(((TextRange)pair.first).getStartOffset(), ((TextRange)pair.first).getEndOffset());
            return;
        }
    }

    private static void removeScope(Document document, OCPragmaSuppressionUtils.Scope scope) {
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        TextRange push2 = scope.getPush();
        TextRange pop = scope.getPop();
        if (push2 != null) {
            ranges.add(push2);
        }
        if (pop != null) {
            ranges.add(pop);
        }
        for (Pair pair : scope.getSettings().values()) {
            if (push2 != null && ((TextRange)pair.first).getStartOffset() <= push2.getStartOffset()) continue;
            ranges.add((TextRange)pair.first);
        }
        ContainerUtil.sort(ranges, Comparator.comparingInt(TextRange::getStartOffset));
        for (int i = ranges.size() - 1; i >= 0; --i) {
            TextRange range = (TextRange)ranges.get(i);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCRemoveSuppressionIntentionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCRemoveSuppressionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

