/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public final class OCMergeElseIfIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCStatement statement;
        if (project == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(1);
        }
        if ((statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class)) == null) {
            return false;
        }
        if (this.checkStatement(statement)) {
            return OCMergeElseIfIntention.checkCursorAtElseKeyword(editor, (OCIfStatement)statement);
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, OCStatement.class);
        if (parentStatement instanceof OCBlockStatement) {
            while (parentStatement instanceof OCBlockStatement) {
                parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCStatement.class);
            }
            return this.checkStatement(parentStatement) && OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.merge.if.else", (Object[])new Object[0]);
        if (string == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement parentStatement;
        if (project == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(4);
        }
        if ((parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class)) == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getElseBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        parentIfStatement.getElseBranch().replace(childStatement);
    }

    public static boolean checkCursorInAppropriatePosition(@NotNull Editor editor, OCStatement statement) {
        if (editor == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(5);
        }
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode elseKeyword = ifStatement.getElseKeyword();
            int offset = editor.getCaretModel().getOffset();
            return rParenth != null && offset <= rParenth.getStartOffset() || elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
        }
        return false;
    }

    public static boolean checkCursorAtElseKeyword(@NotNull Editor editor, OCIfStatement statement) {
        if (editor == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(6);
        }
        ASTNode elseKeyword = statement.getElseKeyword();
        int offset = editor.getCaretModel().getOffset();
        return elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
    }

    private boolean checkStatement(OCStatement statement) {
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement;
            this.setText(this.getFamilyName());
            OCStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch instanceof OCIfStatement) {
                return false;
            }
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            return elseBranch instanceof OCIfStatement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCursorInAppropriatePosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCursorAtElseKeyword";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

