/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCSimplifyUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OCConvertToIfIntentionActionBase
extends PsiElementBaseIntentionAction {
    protected void invoke(OCExpression expression, OCExpression condition, OCExpression positiveExpression, OCExpression negativeExpression) {
        Document document;
        PsiElement element;
        condition = OCParenthesesUtils.diveIntoParentheses(condition);
        positiveExpression = OCParenthesesUtils.diveIntoParentheses(positiveExpression);
        negativeExpression = OCParenthesesUtils.diveIntoParentheses(negativeExpression);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{OCStatement.class, OCDeclarator.class});
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCStatement.class, (boolean)false);
        if (expression == null || statement == null) {
            return;
        }
        @NlsSafe StringBuilder builder2 = new StringBuilder("if (");
        OCExpression conditionalExprWithParens = OCParenthesesUtils.topmostParenthesized(expression);
        if (condition != null) {
            builder2.append(condition.getTextWithMacros());
        }
        builder2.append(") {\n");
        if (parent instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)parent;
            OCExpression initializer = declarator.getInitializer();
            builder2.append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder2, initializer, conditionalExprWithParens, positiveExpression);
            builder2.append(";\n}\nelse {\n").append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder2, initializer, conditionalExprWithParens, negativeExpression);
            builder2.append(";\n}");
            OCChangeUtil.delete(initializer);
        } else {
            OCConvertToIfIntentionActionBase.appendElementText(builder2, statement, conditionalExprWithParens, positiveExpression);
            builder2.append("}\nelse {\n");
            OCConvertToIfIntentionActionBase.appendElementText(builder2, statement, conditionalExprWithParens, negativeExpression);
            builder2.append("\n}");
        }
        OCIfStatement ifStatement = (OCIfStatement)OCElementFactory.statementFromText(builder2.toString(), expression, true);
        PsiElement psiElement = element = parent instanceof OCDeclarator ? OCChangeUtil.addAfter(statement.getParent(), ifStatement, statement) : OCChangeUtil.replaceHandlingMacros(statement, ifStatement);
        if (element instanceof OCIfStatement && (document = element.getContainingFile().getViewProvider().getDocument()) != null) {
            PsiDocumentManager.getInstance((Project)element.getProject()).doPostponedOperationsAndUnblockDocument(document);
            OCConvertToIfIntentionActionBase.simplify(((OCIfStatement)element).getThenBranch());
            OCConvertToIfIntentionActionBase.simplify(((OCIfStatement)element).getElseBranch());
        }
    }

    private static void simplify(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        IntentionAction fix = OCSimplifyUtil.getSimplifyFix(element);
        if (fix != null) {
            fix.invoke(element.getProject(), null, element.getContainingFile());
        }
    }

    private static void appendElementText(StringBuilder builder2, PsiElement element, OCExpression elementToReplace, OCExpression replacement) {
        if (element == elementToReplace) {
            if (OCParenthesesUtils.isParenthesesNeededInReplacing(elementToReplace, replacement)) {
                builder2.append('(').append(OCElementUtil.getTextWithMacros(replacement)).append(')');
            } else {
                builder2.append(OCElementUtil.getTextWithMacros(replacement));
            }
        } else {
            List<PsiElement> children = OCElementUtil.getAllChildren(element);
            if (children.size() > 0) {
                for (PsiElement child : children) {
                    OCConvertToIfIntentionActionBase.appendElementText(builder2, child, elementToReplace, replacement);
                }
            } else if (!OCElementUtil.isPartOfMacroSubstitution(element)) {
                builder2.append(OCElementUtil.getTextWithMacros(element));
            }
        }
    }
}

