/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCProblemRegister {
    protected static void registerProblems(@NotNull ProblemConsumer consumer, List<? extends PsiElement> elements, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes) {
        if (consumer == null) {
            OCProblemRegister.$$$reportNull$$$0(0);
        }
        for (PsiElement psiElement : elements) {
            if (psiElement.getTextLength() <= 0) continue;
            OCProblemRegister.registerProblem(consumer, psiElement, message, clangID, highlightType, inspection, quickFixes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerProblem(@NotNull ProblemConsumer consumer, @Nullable PsiElement element, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes) {
        OCMacroRange range;
        if (consumer == null) {
            OCProblemRegister.$$$reportNull$$$0(1);
        }
        if (element == null) {
            return;
        }
        if (element.getTextLength() == 0) {
            range = OCElementUtil.getRangeInMacroCall(element);
            if (range == null) return;
            OCMacroCall macroCall = range.getMacroCall();
            if (macroCall != element.getPrevSibling()) return;
            element = macroCall;
        }
        range = OCElementUtil.getRangeWithMacros(element);
        OCProblemRegister.registerProblem(consumer, element, null, message, clangID, highlightType, (TextRange)range, inspection, quickFixes);
    }

    public static void registerProblem(@NotNull ProblemConsumer consumer, @Nullable OCElementsRange elementsRange, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes) {
        if (consumer == null) {
            OCProblemRegister.$$$reportNull$$$0(2);
        }
        if (elementsRange == null) {
            return;
        }
        TextRange textRange = elementsRange.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        OCProblemRegister.registerProblem(consumer, elementsRange.getFirstElement(), elementsRange.getLastElement(), message, clangID, highlightType, textRange, inspection, quickFixes);
    }

    public static void registerProblem(@NotNull ProblemConsumer consumer, PsiElement startElement, @Nullable PsiElement endElement, @InspectionMessage String message, String clangID, ProblemHighlightType highlightType, TextRange range, Class<? extends OCInspection> inspection, IntentionAction[] quickFixes) {
        if (consumer == null) {
            OCProblemRegister.$$$reportNull$$$0(3);
        }
        OCProblemRegister.registerProblem(consumer, startElement, endElement, message, clangID, highlightType, range, inspection, quickFixes, null);
    }

    public static void registerProblem(@NotNull ProblemConsumer consumer, PsiElement startElement, @Nullable PsiElement endElement, @InspectionMessage String message, String clangID, ProblemHighlightType highlightType, TextRange range, Class<? extends OCInspection> inspection, IntentionAction[] quickFixes, @Nullable HighlightSeverity forcedSeverity) {
        HighlightSeverity highlightSeverity;
        if (consumer == null) {
            OCProblemRegister.$$$reportNull$$$0(4);
        }
        while (startElement instanceof OCMacroForeignLeafElement) {
            startElement = startElement.getParent();
        }
        while (endElement instanceof OCMacroForeignLeafElement) {
            endElement = endElement.getParent();
        }
        if (endElement != null && startElement.getTextOffset() >= endElement.getTextRange().getEndOffset()) {
            return;
        }
        HighlightSeverity highlightSeverity2 = highlightSeverity = forcedSeverity != null ? forcedSeverity : OCInspectionUtil.getHighlightSeverity(inspection, (InspectionProfile)consumer.inspectionProfile, (PsiElement)startElement, (HighlightSeverity)HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file = (OCFile)startElement.getContainingFile();
        List wrappers = ContainerUtil.mapNotNull((Object[])quickFixes, action -> action instanceof SuppressIntentionAction ? null : new IntentionWrapper(action));
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, clangID, inspection);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        InspectionManager manager = InspectionManager.getInstance((Project)startElement.getProject());
        ProblemDescriptor problem = endElement == null ? manager.createProblemDescriptor(startElement, message, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]), highlightType, consumer.isOnTheFly, false) : manager.createProblemDescriptor(startElement, endElement, message, highlightType, consumer.isOnTheFly, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]));
        if (problemGroup != null) {
            problem.setProblemGroup((ProblemGroup)problemGroup);
            for (IntentionAction fix : quickFixes) {
                if (!(fix instanceof SuppressIntentionAction)) continue;
                problemGroup.addSuppressAction((SuppressIntentionAction)fix);
            }
        }
        if (consumer.processor == null) {
            ProblemDescriptionsProcessor problemDescriptionsProcessor = consumer.processor = file != null ? (ProblemDescriptionsProcessor)file.getProject().getUserData(OCInspection.TEST_PROBLEMS_PROCESSOR_KEY) : null;
        }
        if (consumer.processor != null) {
            consumer.processor.addProblemElement((RefEntity)(consumer.globalContext != null ? GlobalInspectionContextUtil.retrieveRefElement((PsiElement)startElement, (GlobalInspectionContext)consumer.globalContext) : null), new CommonProblemDescriptor[]{problem});
        }
        if (consumer.holder != null) {
            consumer.holder.registerProblem(problem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "consumer";
        objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCProblemRegister";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ProblemConsumer {
        @Nullable
        private ProblemsHolder holder;
        @Nullable
        private ProblemDescriptionsProcessor processor;
        @Nullable
        private GlobalInspectionContext globalContext;
        @Nullable
        private InspectionProfile inspectionProfile;
        private boolean isOnTheFly;

        public ProblemConsumer(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly) {
            this.holder = holder;
            this.processor = processor2;
            this.globalContext = globalContext;
            this.inspectionProfile = globalContext != null ? ((GlobalInspectionContextBase)globalContext).getCurrentProfile() : null;
            this.isOnTheFly = isOnTheFly;
        }

        public ProblemConsumer(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                ProblemConsumer.$$$reportNull$$$0(0);
            }
            this.holder = holder;
            this.isOnTheFly = holder.isOnTheFly();
        }

        public void clearInspectionProfile() {
            this.inspectionProfile = null;
        }

        public ProblemsHolder getHolder() {
            return this.holder;
        }

        public ProblemDescriptionsProcessor getProcessor() {
            return this.processor;
        }

        public GlobalInspectionContext getGlobalContext() {
            return this.globalContext;
        }

        public InspectionProfile getInspectionProfile() {
            return this.inspectionProfile;
        }

        public boolean isOnTheFly() {
            return this.isOnTheFly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/inspections/OCProblemRegister$ProblemConsumer", "<init>"));
        }
    }
}

