/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCGlobalUnusedInspection
extends GlobalSimpleInspectionTool {
    private static Key<Set<VirtualFile>> ANALYZED_FILES = Key.create((String)"ANALYSIS_SCOPE");
    private ProblemsHolder myProblemsHolder;

    @TestOnly
    public OCGlobalUnusedInspection(ProblemsHolder problemsHolder) {
        this.myProblemsHolder = problemsHolder;
    }

    public OCGlobalUnusedInspection() {
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.global.unused.analysis", (Object[])new Object[0]);
        if (string == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.group.name.general", (Object[])new Object[0]);
        if (string == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        String[] stringArray = new String[]{CidrLangBundle.message((String)"objective.c", (Object[])new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Set analysisScope;
        if (file == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(5);
        }
        if (globalContext == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(6);
        }
        if (problemDescriptionsProcessor == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(7);
        }
        if ((analysisScope = (Set)file.getProject().getUserData(ANALYZED_FILES)) != null && file instanceof OCFile) {
            analysisScope.add(file.getVirtualFile());
        }
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(8);
        }
        if (globalContext == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(9);
        }
        if (problemDescriptionsProcessor == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(10);
        }
        manager.getProject().putUserData(ANALYZED_FILES, new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(11);
        }
        if (globalContext == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(12);
        }
        if (problemDescriptionsProcessor == null) {
            OCGlobalUnusedInspection.$$$reportNull$$$0(13);
        }
        Project project = manager.getProject();
        Set analyzedFiles = (Set)project.getUserData(ANALYZED_FILES);
        try {
            ArrayList<OCUnusedVisitor> visitors = new ArrayList<OCUnusedVisitor>();
            if (analyzedFiles == null) {
                return;
            }
            OCGlobalSearchScopeForUnusedCode searchScope = new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(manager.getProject()));
            for (Class clazz : CidrInspectionToolProvider.getStandaloneInspectionClasses()) {
                OCUnusedVisitor unusedVisitor = null;
                try {
                    if (OCUnusedCppInspection.class.isAssignableFrom(clazz)) {
                        unusedVisitor = ((OCUnusedCppInspection)((Object)clazz.newInstance())).buildVisitor();
                    } else if (OCUnusedObjCInspection.class.isAssignableFrom(clazz)) {
                        unusedVisitor = ((OCUnusedObjCInspection)((Object)clazz.newInstance())).buildVisitor();
                    }
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
                if (unusedVisitor == null) continue;
                unusedVisitor.setUpForBatchMode(problemDescriptionsProcessor, globalContext, (SearchScope)searchScope);
                unusedVisitor.setHolder(this.myProblemsHolder);
                visitors.add(unusedVisitor);
            }
            MultiMap<VirtualFile, OCSymbol> unusedSymbolsPerFile = new MultiMap<VirtualFile, OCSymbol>(){

                @NotNull
                protected Collection<OCSymbol> createCollection() {
                    return new SortedList(Comparator.comparingLong(OCSymbol::getComplexOffset));
                }
            };
            Processor collector = arg_0 -> OCGlobalUnusedInspection.lambda$inspectionFinished$0(analyzedFiles, (MultiMap)unusedSymbolsPerFile, arg_0);
            ApplicationManager.getApplication().runReadAction(() -> OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)collector, null));
            ProgressManager.progress((String)OCInspectionsBundle.message((String)"progress.text.evaluating.unused.symbols", (Object[])new Object[0]));
            for (VirtualFile eachAnalyzedFile : analyzedFiles) {
                for (OCSymbol symbol : unusedSymbolsPerFile.get((Object)eachAnalyzedFile)) {
                    Ref prevElement = new Ref();
                    ApplicationManager.getApplication().runReadAction(() -> {
                        ProgressManager.checkCanceled();
                        PsiElement definition = symbol.locateDefinition(project);
                        if (definition != null && !definition.equals(prevElement.get())) {
                            prevElement.set((Object)definition);
                            for (OCUnusedVisitor visitor : visitors) {
                                visitor.checkFromBatchMode(symbol, definition);
                            }
                        }
                    });
                }
            }
        }
        finally {
            project.putUserData(ANALYZED_FILES, null);
        }
    }

    @Nullable
    public String getMainToolId() {
        return "Annotator";
    }

    private static /* synthetic */ boolean lambda$inspectionFinished$0(Set analyzedFiles, MultiMap unusedSymbolsPerFile, OCSymbol symbol) {
        ProgressManager.checkCanceled();
        if (analyzedFiles.contains(symbol.getContainingFile())) {
            unusedSymbolsPerFile.putValue((Object)symbol.getContainingFile(), (Object)symbol);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCGlobalUnusedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCGlobalUnusedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

