/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hmap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.jetbrains.cidr.lang.hmap.OCHeaderMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001:\u0002\r\u000eJ\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005H\u00a6\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005H&R\u001c\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/lang/hmap/MapsCache;", "Lcom/intellij/openapi/Disposable$Default;", "keys", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/hmap/MapsCacheKey;", "getKeys", "()Ljava/util/Set;", "get", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMap;", "key", "getPointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Builder", "Empty", "intellij.c"})
public interface MapsCache
extends Disposable.Default {
    @NotNull
    public Set<VirtualFile> getKeys();

    @Nullable
    public OCHeaderMap get(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFilePointer getPointer(@NotNull VirtualFile var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\n\u0010\u0013\u001a\u00060\u0007j\u0002`\bH\u0096\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0013\u001a\u00060\u0007j\u0002`\bH\u0016R\u001e\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u001e\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/hmap/MapsCache$Builder;", "Lcom/jetbrains/cidr/lang/hmap/MapsCache;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "keys", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/hmap/MapsCacheKey;", "getKeys", "()Ljava/util/Set;", "map", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMap;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "getMap", "()Ljava/util/Map;", "get", "key", "getPointer", "intellij.c"})
    public static final class Builder
    implements MapsCache {
        @NotNull
        private final Map<VirtualFile, Pair<OCHeaderMap, VirtualFilePointer>> map;

        public Builder(@NotNull Disposable disposableParent) {
            Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
            this.map = new HashMap();
            Disposer.register((Disposable)disposableParent, (Disposable)((Disposable)this));
        }

        @NotNull
        public final Map<VirtualFile, Pair<OCHeaderMap, VirtualFilePointer>> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getKeys() {
            return this.map.keySet();
        }

        @Override
        @Nullable
        public OCHeaderMap get(@NotNull VirtualFile key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Pair<OCHeaderMap, VirtualFilePointer> pair = this.map.get(key);
            return pair != null ? (OCHeaderMap)pair.getFirst() : null;
        }

        @Override
        @Nullable
        public VirtualFilePointer getPointer(@NotNull VirtualFile key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Pair<OCHeaderMap, VirtualFilePointer> pair = this.map.get(key);
            return pair != null ? (VirtualFilePointer)pair.getSecond() : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006H\u0096\u0002J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006H\u0016R\u001e\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/hmap/MapsCache$Empty;", "Lcom/jetbrains/cidr/lang/hmap/MapsCache;", "()V", "keys", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/hmap/MapsCacheKey;", "getKeys", "()Ljava/util/Set;", "get", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMap;", "key", "getPointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "intellij.c"})
    public static final class Empty
    implements MapsCache {
        @NotNull
        public static final Empty INSTANCE = new Empty();
        @NotNull
        private static final Set<VirtualFile> keys = SetsKt.emptySet();

        private Empty() {
        }

        @Override
        @NotNull
        public Set<VirtualFile> getKeys() {
            return keys;
        }

        @Override
        @Nullable
        public OCHeaderMap get(@NotNull VirtualFile key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return null;
        }

        @Override
        @Nullable
        public VirtualFilePointer getPointer(@NotNull VirtualFile key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return null;
        }
    }
}

