/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementMethodsHandlerBase;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementOCMethodsHandler
extends OCOverrideImplementMethodsHandlerBase {
    private static final OCBooleanOption SHOW_OPTIONAL = new OCBooleanOption(OCGenerateBundle.message("override.implement.show.optional.members", new Object[0]));
    private static final OCBooleanOption SHOW_SYNTHESIZED_ACCESSORS = new OCBooleanOption(OCGenerateBundle.message("override.implement.show.synthesized.accessors", new Object[0]));

    @Override
    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull OCOverrideImplementActionContext context) {
        if (context == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(0);
        }
        String parentName = context.getParentNameUppercase();
        return OCGenerateBundle.message("implement.methods.handler.no.members.message", parentName);
    }

    protected boolean defaultShowOptional() {
        return false;
    }

    protected boolean defaultShowSynthesizedAccessors() {
        return false;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCOverrideImplementActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(1);
        }
        if (options == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(2);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_OPTIONAL, (Object)this.defaultShowOptional()));
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)this.defaultShowSynthesizedAccessors()));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, final @NotNull PsiElement element) {
        if (element == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(3);
        }
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                final HashSet names = new HashSet();
                CommonProcessors.CollectProcessor<OCMethodSymbol> processor2 = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

                    protected boolean accept(OCMethodSymbol symbol) {
                        if (names.add(symbol.getName())) {
                            myAbstractMethods.add(symbol);
                            return true;
                        }
                        return false;
                    }
                };
                if (this.getType().getClassSymbol() == null) {
                    List<OCMethodSymbol> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                this.getType().processInterfaceMethods(this.getInterfaceSymbol(), null, (Processor<OCMethodSymbol>)processor2, element, true);
                Collection collection = processor2.getResults();
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/implement/OCImplementOCMethodsHandler$1", "getMemberCandidates"));
            }
        };
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(@NotNull OCOverrideImplementActionContext actionContext, Editor editor, @NotNull PsiFile file, @NotNull List<OCMethodSymbol> candidates) {
        if (actionContext == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(6);
        }
        if (this.selectAllCandidates()) {
            ArrayList<OCMethodSymbol> result = new ArrayList<OCMethodSymbol>();
            for (OCMethodSymbol method : actionContext.getMemberCandidates()) {
                if (method.isOptional()) continue;
                result.add(method);
            }
            ArrayList<OCMethodSymbol> arrayList = result;
            if (arrayList == null) {
                OCImplementOCMethodsHandler.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        Collection<OCMethodSymbol> collection = super.getSelectedCandidates(actionContext, editor, file, candidates);
        if (collection == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(8);
        }
        return collection;
    }

    protected boolean selectAllCandidates() {
        return true;
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("implement.methods.handler.members.chooser.title", new Object[0]);
    }

    @Override
    protected String generateMethodText(OCMethodSymbol baseMethod, PsiElement context, OCOverrideImplementActionContext actionContext) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        if (property != null) {
            map2.put("IVAR_IS_AVAILABLE", actionContext.isIvarAvailable(property) ? "true" : "false");
        }
        return OCCallableUtil.methodFromTemplate(baseMethod, "OC Implemented Method Body.m", context, map2, actionContext.getProject());
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCMethodSymbol> candidates, OCOverrideImplementActionContext actionContext, int moreNodesLevel) {
        ArrayList<OCMethodSymbol> filteredCandidates = new ArrayList<OCMethodSymbol>();
        if (moreNodesLevel > 0) {
            chooser.setOptionSelection(SHOW_OPTIONAL, true);
        }
        if (moreNodesLevel > 1) {
            chooser.setOptionSelection(SHOW_SYNTHESIZED_ACCESSORS, true);
        }
        Boolean showOptionalMethods = OCClassActionHandlerBase.getOption(chooser.getOptionSelections(), SHOW_OPTIONAL);
        Boolean showSynthesizedAccessors = OCClassActionHandlerBase.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED_ACCESSORS);
        if (candidates.isEmpty()) {
            return super.getChooserNodes(chooser, filteredCandidates, actionContext, moreNodesLevel);
        }
        Project project = actionContext.getProject();
        OCImplementationSymbol parent = candidates.iterator().next().getParent().getImplementation(project);
        HashSet synthesizedProperties = new HashSet();
        if (parent != null) {
            parent.processMembers(OCSynthesizeSymbol.class, symbol -> {
                synthesizedProperties.add(symbol.getName());
                return true;
            });
        }
        int optionalSize = 0;
        int synthesizedSize = 0;
        for (OCMethodSymbol candidate : candidates) {
            OCPropertySymbol property = candidate.getGeneratedFromProperty();
            if (candidate.isOptional()) {
                ++optionalSize;
                if (!showOptionalMethods.booleanValue()) continue;
            }
            if (property != null && (synthesizedProperties.contains(property.getName()) || OCCompilerFeaturesHelper.supportsAutosynthesis(property.getContainingOCFile(project))) && !(property.getParent() instanceof OCProtocolSymbol)) {
                ++synthesizedSize;
                if (!showSynthesizedAccessors.booleanValue()) continue;
            }
            filteredCandidates.add(candidate);
        }
        OCBooleanOption.setStates(chooser.getOptionComponent(SHOW_OPTIONAL), optionalSize == 0, "override.implement.show.no.optional.members", optionalSize == candidates.size(), "override.implement.show.only.optional.members");
        OCBooleanOption.setStates(chooser.getOptionComponent(SHOW_SYNTHESIZED_ACCESSORS), synthesizedSize == 0, "override.implement.show.no.synthesized.accessors", synthesizedSize == candidates.size(), "override.implement.show.only.synthesized.accessors");
        Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        OCMemberChooserObject[] nodes = (OCMemberChooserObject[])ContainerUtil.map2Array(filteredCandidates, OCMemberChooserObject.class, m -> {
            Icon icon2 = m.getIcon(project);
            if (!icon2.equals(OCSymbolKind.PROPERTY.getIcon())) {
                icon2 = OCIcons.getMethodIcon(m.isStatic(), m.isOptional(), actionContext.isAbstract((OCMethodSymbol)m));
            }
            return new OCMemberChooserObject((OCSymbol)m, icon2, parentsMap, project);
        });
        return nodes;
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCMethodSymbol> candidates, OCOption option, OCOverrideImplementActionContext actionContext) {
        if (SHOW_OPTIONAL.equals(option) || SHOW_SYNTHESIZED_ACCESSORS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCOverrideImplementActionContext actionContext, @NotNull List<OCMethodSymbol> chosenCandidates) {
        if (project == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(10);
        }
        if (actionContext == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(11);
        }
        if (chosenCandidates == null) {
            OCImplementOCMethodsHandler.$$$reportNull$$$0(12);
        }
        if (actionContext.evaluateAvailableIvars(file, chosenCandidates, this.getActionTitle())) {
            super.performAction(project, editor, file, actionContext, chosenCandidates);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCImplementOCMethodsHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCImplementOCMethodsHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNoMembersMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCandidates";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

