/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateConstructorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateConstructorContext> {
    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("generate.constructor.action.title", new Object[0]);
        if (string == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.constructor.members.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        if (context == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(1);
        }
        return new OCGenerateConstructorContext(parent, context);
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(final @NotNull OCCaretLocation location, @NotNull OCGenerateConstructorContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        OCSymbol foundSymbol;
        List<OCFunctionSymbol> chosenCtors;
        if (location == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(2);
        }
        if (actionContext == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(4);
        }
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        OCStructSymbol parent = (OCStructSymbol)actionContext.getParent();
        PsiElement element = parent.locateDefinition(location.getProject());
        if (!(element instanceof OCStructLike)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateConstructorHandler.$$$reportNull$$$0(5);
            }
            return list;
        }
        OCStructLike structLike = (OCStructLike)element;
        final OCResolveContext context = location.createContext();
        if (this.addParametersForBaseClasses()) {
            parent.processBaseClasses(OCResolveContext.forSymbol(parent, location.getProject()), (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                    ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)collector, context);
                    if (!collector.getResults().isEmpty()) {
                        baseConstructors.add(collector.getResults());
                    }
                }
                return true;
            });
        }
        if ((chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, location.getProject())) == null) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateConstructorHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        HashSet<String> existingNames = new HashSet<String>();
        ArrayList<Object> initList = new ArrayList<Object>();
        boolean hasConstevalBaseCtor = false;
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            OCDeclaratorSymbol param;
            OCType type;
            if (baseConstructor.getType().hasNoParameters()) continue;
            hasConstevalBaseCtor = hasConstevalBaseCtor || baseConstructor.isConsteval();
            StringBuilder callBase = new StringBuilder(baseConstructor.getName()).append("(");
            boolean first = true;
            Iterator<OCDeclaratorSymbol> iterator2 = baseConstructor.getParameterSymbols().iterator();
            while (iterator2.hasNext() && !((type = (param = iterator2.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
                String paramName = param.isUnnamed() ? OCNameSuggester.suggestForType(param.getType(), null, "", context).iterator().next() : param.getName();
                String name = OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, paramName, null, existingNames, actionContext.getProject());
                existingNames.add(name);
                paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
                paramNames.add(name);
                if (!first) {
                    callBase.append(",");
                }
                callBase.append(name);
                first = false;
            }
            callBase.append(")");
            initList.add(callBase.toString());
        }
        for (OCDeclaratorSymbol field : fields) {
            String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, actionContext.getProject());
            name = OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, name, null, existingNames, actionContext.getProject());
            existingNames.add(name);
            OCType type = field.getType();
            paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
            paramNames.add(name);
            initList.add(field.getName() + "(" + name + ")");
        }
        OCFunctionType funcType = new OCFunctionType(OCVoidType.instance(), paramTypes, paramNames);
        final OCType resolved = funcType.resolve(context);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                OCType type;
                return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && (type = symbol.getResolvedType(context)) instanceof OCFunctionType && new OCTypeEqualityVisitor(type, false, OCResolveContext.forPsi((PsiElement)location.getFile())).isFunctionSignatureEqual(resolved);
            }
        };
        parent.processMembers((String)null, (Processor<? super OCSymbol>)finder);
        if (finder.isFound() && (foundSymbol = (OCSymbol)finder.getFoundValue()) instanceof OCFunctionSymbol) {
            int code;
            String signature2 = ((OCFunctionSymbol)finder.getFoundValue()).getSignatureWithoutParamNames();
            String message = OCGenerateBundle.message("generate.constructor.already.defined.message", signature2);
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 1 : MessageDialogBuilder.yesNo((String)this.getActionTitle(), (String)message).show();
            if (code != 0) {
                List<OCGenerateUtil.Replacement> list = Collections.emptyList();
                if (list == null) {
                    OCGenerateConstructorHandler.$$$reportNull$$$0(7);
                }
                return list;
            }
        }
        OCFakeFunctionSymbolBuilder builder2 = new OCFakeFunctionSymbolBuilder(parent.getName()).setIsCtorOrDtor(true).setContainer(parent).setIsExplicit(paramTypes.size() == 1).setIsConsteval(hasConstevalBaseCtor).setVisibility(OCVisibility.PUBLIC);
        for (OCDeclaratorSymbol param : ContainerUtil.zip(paramTypes, paramNames)) {
            builder2.addParam((OCType)((Pair)param).first, (String)((Pair)param).second);
        }
        String body = (String)(initList.isEmpty() ? "" : ":" + StringUtil.join(initList, (String)",")) + "{}";
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, parent, Collections.singletonList(builder2.get()), Collections.singletonList(body), this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateConstructorContext context) {
        return true;
    }

    @Override
    protected boolean allowMultiSelection(OCGenerateConstructorContext context) {
        return ((OCStructSymbol)context.getParent()).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    public static List<OCFunctionSymbol> chooseBaseConstructors(List<Collection<OCFunctionSymbol>> allBaseConstructors, Project project) {
        ArrayList<OCFunctionSymbol> chosenCtors = new ArrayList<OCFunctionSymbol>();
        for (Collection<OCFunctionSymbol> ctors : allBaseConstructors) {
            if (ctors.size() > 1) {
                OCFunctionSymbol ctr = OCGenerateConstructorHandler.chooseConstructor(ctors, project);
                if (ctr != null) {
                    chosenCtors.add(ctr);
                    continue;
                }
                return null;
            }
            OCFunctionSymbol ctor = (OCFunctionSymbol)ContainerUtil.getFirstItem(ctors);
            if (ctor == null || ctor.canBeCalledWithoutArguments()) continue;
            chosenCtors.add(ctor);
        }
        return chosenCtors;
    }

    @Nullable
    private static OCFunctionSymbol chooseConstructor(Collection<OCFunctionSymbol> constructors, Project project) {
        OCMemberChooser chooser = new OCMemberChooser((OCMemberChooserObject[])ContainerUtil.map2Array(constructors, OCMemberChooserObject.class, symbol -> new OCMemberChooserObject((OCSymbol)symbol, null, project, (OCFunctionSymbol)symbol, project){
            final /* synthetic */ OCFunctionSymbol val$symbol;
            final /* synthetic */ Project val$project;
            {
                this.val$symbol = oCFunctionSymbol;
                this.val$project = project2;
                super(symbol, parentsMap, project);
            }

            @Override
            @Nullable
            public MemberChooserObject getParentNodeDelegate() {
                return new OCMemberChooserObject(this.val$symbol.getParent(), null, this.val$project);
            }
        }), false, false, Collections.emptyList(), null, project);
        chooser.setTitle(OCGenerateBundle.message("generate.constructor.choose.base.class.constructor", new Object[0]));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        List<OCMemberChooserObject> chosenElements = chooser.getChosenElements();
        assert (chosenElements != null && chosenElements.size() == 1);
        return (OCFunctionSymbol)chosenElements.get(0).getSymbol();
    }

    protected boolean addParametersForBaseClasses() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateConstructorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateConstructorHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

