/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.formatting.alignment.AlignmentInColumnsHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.formatting.OCFormatProcessor;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCLocalFormatterData;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCWrappingProcessor
extends OCFormatProcessor {
    protected static final Key<Boolean> IS_TABLE = new Key("IS_TABLE");
    private static final AlignmentInColumnsConfig VARS_ALIGNMENT_CONFIG = new AlignmentInColumnsConfig(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER, OCElementTypes.STRUCTURED_BINDING_LIST}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.COMMA, OCElementTypes.MACRO_CALL})}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCTokenTypes.TYPE_MODIFIERS}), TokenSet.EMPTY, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.ASSIGNMENT_EXPRESSION, OCElementTypes.DECLARATOR, OCElementTypes.STRUCTURED_BINDING_DECLARATOR}));
    public static final OCElementType CHAINED_CALL_PSEUDOTYPE = new OCElementType("CHAINED_CALL_PSEUDOTYPE");
    public static final OCElementType BINARY_EXPRESSION_PSEUDOTYPE = new OCElementType("BINARY_EXPRESSION_PSEUDOTYPE");
    public static final OCElementType LITERAL_EXPRESSION_PSEUDOTYPE = new OCElementType("LITERAL_EXPRESSION_PSEUDOTYPE");
    @NonNls
    private static final String KEY_METHOD_ARGUMENTS = "method arguments";
    @NonNls
    private static final String KEY_METHOD_FIRST_ARGUMENT = "first method argument";
    @NonNls
    private static final String KEY_METHOD_ARGUMENT_VALUES = "method argument values";
    @NonNls
    private static final String KEY_METHOD_CHAIN = "method argument alignment";
    @NonNls
    private static final String KEY_CALL_ARGUMENT_COLUMNS = "call argument columns";
    @NonNls
    private static final String KEY_PARAMETER_COLUMNS = "parameter columns";
    @NonNls
    private static final String KEY_ASSIGNMENT_WRAP = "assignment wrap";
    @NonNls
    private static final String KEY_ASSIGNMENT_ALIGNMENT = "assignment alignment";
    @NonNls
    private static final String KEY_GROUP_ASSIGNMENT = "group assignment";
    @NonNls
    private static final String KEY_GROUP_VARIABLE_NAME = "group variable name";
    @NonNls
    private static final String KEY_GROUP_INIT_LIST = "group initialization list";
    @NonNls
    private static final String KEY_GROUP_DICTIONARY_PAIRS = "group dictionary pairs";
    @NonNls
    private static final String KEY_TERNARY_ALIGNMENT = "ternary alignment";
    @NonNls
    private static final String KEY_TERNARY_OPERATOR_ALIGNMENT = "ternary operator alignment";
    @NonNls
    private static final String KEY_TERNARY_WRAP = "ternary wrap";
    @NonNls
    private static final String KEY_TERNARY_OPERATOR_WRAP = "ternary operator wrap";
    @NonNls
    private static final String KEY_TEMPLATE_DECLARATION_WRAP = "template declaration wrap";
    @NonNls
    private static final String KEY_NEVER_WRAP = "Never wrap";
    @NonNls
    private static final String KEY_ALWAYS_WRAP = "Always wrap";
    @NonNls
    private static final String KEY_IF_LONG_WRAP = "If long wrap";
    @NonNls
    private static final String KEY_SHIFT_OPERATION = "Shift operations";
    private static final TokenSet COMMENTS_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCElementTypes.EXPRESSIONS});
    private static final TokenSet TYPE_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.TYPE_ELEMENT}), OCElementTypes.EXPRESSIONS});
    private static final TokenSet LAMBDA_LIST_CAPTURE = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.TYPE_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.EQ, OCTokenTypes.THIS_CPP_KEYWORD, OCTokenTypes.ELLIPSIS, OCElementTypes.REFERENCE_ELEMENT})});
    private static final TokenSet MACRO_ARG_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_ARGUMENT}), OCElementTypes.EXPRESSIONS});
    private final OCLocalFormatterData myData;
    private ASTNode childNode;
    private IElementType childType;

    OCWrappingProcessor(CommonCodeStyleSettings settings, OCCodeStyleSettings ocSettings, ASTNode node, OCLocalFormatterData data) {
        super(settings, ocSettings, node);
        this.myData = data;
    }

    public Wrap getTemplateWrap(IElementType ancestorType) {
        OCFormatterInfo formatInfo;
        OCLocalFormatterData upData;
        OCLocalFormatterData oCLocalFormatterData = upData = ancestorType == null ? this.myData : this.myData.getAncestor(ancestorType);
        if (upData != null && (formatInfo = upData.get(KEY_TEMPLATE_DECLARATION_WRAP)) != null) {
            return formatInfo.wrap;
        }
        return null;
    }

    public OCFormatterInfo calculate(ASTNode child, IElementType childType) {
        this.childNode = child;
        this.childType = childType;
        return this.doCalculate();
    }

    private boolean shouldAlignAsElementOrComma(@NotNull IElementType elementType, boolean commaOnNextLine) {
        if (elementType == null) {
            OCWrappingProcessor.$$$reportNull$$$0(0);
        }
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementType);
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && this.childType != elementType || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, (IElementType)OCTokenTypes.COMMA));
    }

    private boolean shouldAlignAsElementOrComma(@NotNull TokenSet elementTypes, boolean commaOnNextLine) {
        if (elementTypes == null) {
            OCWrappingProcessor.$$$reportNull$$$0(1);
        }
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementTypes);
        }
        if (elementTypes.contains(this.childType) && OCFormatterUtil.isPrecededBy(this.childNode, elementTypes)) {
            return false;
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && !elementTypes.contains(this.childType) || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, (IElementType)OCTokenTypes.COMMA));
    }

    @NotNull
    @Contract(value="_ -> new")
    private static Pair<Object, ASTNode> getAssignGroupKey(@NotNull ASTNode node) {
        IElementType pType;
        if (node == null) {
            OCWrappingProcessor.$$$reportNull$$$0(2);
        }
        int nestLevel = -1;
        ASTNode topContainer = node;
        for (ASTNode p = node; p != null && !OCWrappingProcessor.isVariableScope(pType = OCElementUtil.getElementType(p)); p = p.getTreeParent()) {
            if (pType != OCElementTypes.ASSIGNMENT_EXPRESSION && pType != OCElementTypes.DECLARATOR && pType != OCElementTypes.STRUCTURED_BINDING_DECLARATOR) continue;
            topContainer = p;
            ++nestLevel;
        }
        if (nestLevel < 0) {
            nestLevel = 0;
        }
        return new Pair((Object)new Pair((Object)KEY_GROUP_ASSIGNMENT, (Object)nestLevel), (Object)topContainer);
    }

    @NotNull
    private static String getInitListGroupKey(@NotNull ASTNode node) {
        if (node == null) {
            OCWrappingProcessor.$$$reportNull$$$0(3);
        }
        StringBuilder path = new StringBuilder();
        int oldSiblingOrder = 0;
        for (ASTNode p = node; p != null && OCElementUtil.getElementType(p.getTreeParent()) == OCElementTypes.COMPOUND_INITIALIZER; p = p.getTreeParent()) {
            int siblingOrder = 0;
            ASTNode s = p;
            while (s != null) {
                ++siblingOrder;
                s = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(s);
            }
            if (oldSiblingOrder > 0) {
                path.insert(0, "/" + oldSiblingOrder);
            }
            oldSiblingOrder = siblingOrder;
        }
        String string = KEY_GROUP_INIT_LIST + path;
        if (string == null) {
            OCWrappingProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private OCFormatterInfo doCalculate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static OCFormatterInfo getJoinFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(59);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_NEVER_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)0, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(60);
        }
        return oCFormatterInfo;
    }

    public OCFormatterInfo getJoinFormatting() {
        return OCWrappingProcessor.getJoinFormatting(this.myData);
    }

    @NotNull
    public static OCFormatterInfo getNewLineFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(61);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_ALWAYS_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)2, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(62);
        }
        return oCFormatterInfo;
    }

    @NotNull
    public static OCFormatterInfo getIfLongFormatting(@NotNull OCLocalFormatterData data) {
        if (data == null) {
            OCWrappingProcessor.$$$reportNull$$$0(63);
        }
        OCFormatterInfo oCFormatterInfo = data.get(KEY_IF_LONG_WRAP, (Computable<OCFormatterInfo>)((Computable)() -> OCFormatterInfo.createInfo(Wrap.createWrap((int)5, (boolean)true), null)));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(64);
        }
        return oCFormatterInfo;
    }

    private boolean isInTableLikeInitList() {
        ASTNode topList = null;
        ASTNode nextList = this.thisNode;
        while (OCElementUtil.getElementType(nextList) == OCElementTypes.COMPOUND_INITIALIZER) {
            topList = nextList;
            nextList = nextList.getTreeParent();
        }
        if (topList == null) {
            return false;
        }
        Boolean isTable = (Boolean)IS_TABLE.get((UserDataHolder)topList);
        if (isTable == null) {
            isTable = OCWrappingProcessor.isInTableLikeInitListReal(topList);
            IS_TABLE.set((UserDataHolder)topList, (Object)isTable);
        }
        return isTable;
    }

    private static boolean isInTableLikeInitListReal(@NotNull ASTNode topList) {
        if (topList == null) {
            OCWrappingProcessor.$$$reportNull$$$0(65);
        }
        int cellCount = 0;
        for (ASTNode child = topList.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType cType = child.getElementType();
            if (OCWrappingProcessor.isInessential(child) || cType instanceof OCPunctuatorElementType || cType == OCElementTypes.COMPOUND_INITIALIZER) {
                if (cType != OCElementTypes.COMPOUND_INITIALIZER) continue;
                ++cellCount;
                continue;
            }
            return false;
        }
        return cellCount > 1;
    }

    @NotNull
    OCFormatterInfo wrapOnly(Object key, int wrap) {
        OCFormatterInfo oCFormatterInfo = this.wrapOnly(key, wrap, false);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(66);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapOnly(Object key, int wrapType, boolean wrapFirstElement) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, false, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(67);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo alignOnly(Object key, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.alignOnly(key, align, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(68);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo alignOnly(Object key, boolean align, Object keyParent) {
        OCFormatterInfo formatInfo;
        Alignment parentAlignment = null;
        if (keyParent != null && (formatInfo = this.myData.get(keyParent)) != null) {
            parentAlignment = formatInfo.alignment;
        }
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, false, -1, false, null, align, parentAlignment);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(69);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, wrapType, false, align);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(70);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean wrapFirstElement, boolean align) {
        OCFormatterInfo oCFormatterInfo = this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, align, null);
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(71);
        }
        return oCFormatterInfo;
    }

    @NotNull
    OCFormatterInfo wrapAndAlign(Object key, boolean wrap, int wrapType, boolean wrapFirstElement, @Nullable Wrap parentWrap, boolean align, @Nullable Alignment parentAlignment) {
        OCFormatterInfo oCFormatterInfo = this.myData.get(key, (Computable<OCFormatterInfo>)((Computable)() -> {
            Wrap wrapping = wrap ? Wrap.createChildWrap((Wrap)parentWrap, (WrapType)WrappingUtil.getWrapType((int)wrapType), (boolean)wrapFirstElement) : null;
            Alignment alignment = null;
            if (align) {
                alignment = parentAlignment != null ? Alignment.createChildAlignment((Alignment)parentAlignment) : Alignment.createAlignment();
            }
            return OCFormatterInfo.createInfo(wrapping, alignment);
        }));
        if (oCFormatterInfo == null) {
            OCWrappingProcessor.$$$reportNull$$$0(72);
        }
        return oCFormatterInfo;
    }

    private static boolean isVariableScope(@Nullable IElementType type) {
        return OCWrappingProcessor.isBlock(type) || OCWrappingProcessor.isVariablesListOrStructure(type) || OCWrappingProcessor.isGlobalDeclarationScope(type);
    }

    @Nullable
    private Alignment varsGroupAlignment(@NotNull Object key, @Nullable ASTNode node) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(73);
        }
        if (!this.settings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            return null;
        }
        return this.groupAlignment(this.findVarGroupParentData(), key, node, VARS_ALIGNMENT_CONFIG);
    }

    @Nullable
    private Alignment pairsGroupAlignment(@NotNull Object key, @Nullable OCLocalFormatterData parentData, @Nullable ASTNode node) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(74);
        }
        if (!this.ocSettings.ALIGN_DICTIONARY_PAIR_VALUES) {
            return null;
        }
        return this.groupAlignment(parentData, key, node, null);
    }

    @Contract(value="null, _, _, _ -> null")
    private Alignment groupAlignment(@Nullable OCLocalFormatterData parentData, @NotNull Object key, @Nullable ASTNode node, @Nullable AlignmentInColumnsConfig config) {
        if (key == null) {
            OCWrappingProcessor.$$$reportNull$$$0(75);
        }
        if (parentData == null) {
            return null;
        }
        Computable factory = () -> OCFormatterInfo.createInfo(Alignment.createAlignment((boolean)true));
        if (config != null && AlignmentInColumnsHelper.INSTANCE.useDifferentVarDeclarationAlignment(node, config, this.settings.KEEP_BLANK_LINES_IN_DECLARATIONS)) {
            parentData.put(key, (OCFormatterInfo)factory.compute());
        }
        return parentData.get((Object)key, (Computable<OCFormatterInfo>)factory).alignment;
    }

    @NotNull
    private OCLocalFormatterData findVarGroupParentData() {
        OCLocalFormatterData data = this.myData;
        while (!OCWrappingProcessor.isVariableScope(data.getType()) && !data.isNull()) {
            data = data.getParent();
        }
        OCLocalFormatterData oCLocalFormatterData = data;
        if (oCLocalFormatterData == null) {
            OCWrappingProcessor.$$$reportNull$$$0(76);
        }
        return oCLocalFormatterData;
    }

    @NotNull
    private OCLocalFormatterData findTopInitListData() {
        OCLocalFormatterData data = this.myData;
        while (true) {
            if (data.getParent().getType() != OCElementTypes.COMPOUND_INITIALIZER) {
                OCLocalFormatterData oCLocalFormatterData = data;
                if (oCLocalFormatterData == null) {
                    OCWrappingProcessor.$$$reportNull$$$0(77);
                }
                return oCLocalFormatterData;
            }
            data = data.getParent();
        }
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$6() {
        return OCFormatterInfo.createInfo(Wrap.createWrap((int)(this.parentType != OCElementTypes.COMPOUND_INITIALIZER ? 2 : 0), (boolean)false), Alignment.createAlignment((boolean)true));
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$5() {
        return OCFormatterInfo.createInfo(this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null);
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$4(OCFormatterInfo argBasePositionF) {
        return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)argBasePositionF.wrap, (WrapType)WrappingUtil.getWrapType((int)this.ocSettings.METHOD_CALL_ARGUMENTS_WRAP), (boolean)true), this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE ? Alignment.createChildAlignment((Alignment)argBasePositionF.alignment) : null);
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$3() {
        return OCFormatterInfo.createInfo(Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.settings.METHOD_CALL_CHAIN_WRAP), (boolean)true), Alignment.createAlignment());
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$2() {
        return OCFormatterInfo.createInfo(this.ocSettings.METHOD_PARAMETERS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null);
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$1() {
        return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)this.myData).wrap, (WrapType)WrapType.byLegacyRepresentation((int)this.ocSettings.SUPERCLASS_LIST_WRAP), (boolean)true), (Alignment)(this.ocSettings.SUPERCLASS_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null));
    }

    private /* synthetic */ OCFormatterInfo lambda$doCalculate$0(OCLocalFormatterData dataStorage) {
        return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)dataStorage).wrap, (WrapType)WrapType.byLegacyRepresentation((int)this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP), (boolean)true), (Alignment)(this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 62, 64, 66, 67, 68, 69, 70, 71, 72, 76, 77 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCWrappingProcessor";
                break;
            }
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topList";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCWrappingProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitListGroupKey";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "doCalculate";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinFormatting";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewLineFormatting";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfLongFormatting";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapOnly";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "alignOnly";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAndAlign";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "findVarGroupParentData";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopInitListData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldAlignAsElementOrComma";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAssignGroupKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitListGroupKey";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: {
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getJoinFormatting";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getNewLineFormatting";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getIfLongFormatting";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isInTableLikeInitListReal";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "varsGroupAlignment";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "pairsGroupAlignment";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "groupAlignment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 62, 64, 66, 67, 68, 69, 70, 71, 72, 76, 77 -> new IllegalStateException(string);
        };
    }
}

