/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public final class OCSuggestVariableNameMacro
extends Macro {
    @NlsSafe
    private static final String MACRO_NAME = "suggestVariableName";

    public String getName() {
        return MACRO_NAME;
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        Collection<String> names;
        if (params == null) {
            OCSuggestVariableNameMacro.$$$reportNull$$$0(0);
        }
        return (names = OCSuggestVariableNameMacro.getNames(context)).isEmpty() ? null : new TextResult(names.iterator().next());
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        Collection<String> names;
        if (params == null) {
            OCSuggestVariableNameMacro.$$$reportNull$$$0(1);
        }
        if ((names = OCSuggestVariableNameMacro.getNames(context)).size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.size()];
        int i = 0;
        for (String name : names) {
            items[i++] = LookupElementBuilder.create((Object)name, (String)name);
        }
        return items;
    }

    private static Collection<String> getNames(ExpressionContext context) {
        Collection<String> names = OCTemplatesUtil.getNames(context);
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        names = new LinkedHashSet<String>(names);
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        String safeName = place.getText();
        Iterator<String> it = names.iterator();
        String firstNotUnique = null;
        while (it.hasNext()) {
            String name = it.next();
            if (name.equals(safeName) || OCCodeInsightUtil.isUniqueInScope(null, name, place, context.getProject())) continue;
            it.remove();
            if (firstNotUnique != null) continue;
            firstNotUnique = name;
        }
        if (names.isEmpty()) {
            return Collections.singleton(OCUniqueNameGenerator.suggestUniqueName(null, firstNotUnique, place, context.getProject()));
        }
        return names;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

