/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class OCEnterInDirectiveAndNoncompiledHandler
extends EnterHandlerDelegateAdapter {
    private static final TokenSet WHITE_SPACE_OR_COMMENT = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, OCTokenTypes.BLOCK_COMMENT, OCTokenTypes.EOL_COMMENT});

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        IElementType maybeDirectiveType;
        Language language;
        if (file == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(4);
        }
        if (!OCLanguageUtils.isSupported(language = EnterHandler.getLanguage((DataContext)dataContext)) || originalHandler == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        CharSequence documentChars = document.getCharsSequence();
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
        boolean skipCurrentEOLEsc = true;
        if (!it.atEnd() && WHITE_SPACE_OR_COMMENT.contains(it.getTokenType()) && !OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), Math.min(it.getEnd(), caretOffset))) {
            if (it.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                return EnterHandlerDelegate.Result.Continue;
            }
            skipCurrentEOLEsc = false;
            it.retreat();
        }
        ArrayList<Integer> eolPositions = new ArrayList<Integer>();
        while (!(it.atEnd() || !OCTokenTypes.RAW_STRING_LITERALS.contains(it.getTokenType()) && it.getTokenType() != OCTokenTypes.BLOCK_COMMENT && it.getTokenType() != OCTokenTypes.EOL_ESCAPE && OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd()))) {
            if (!(it.getTokenType() != OCTokenTypes.EOL_ESCAPE || skipCurrentEOLEsc && it.getEnd() != caretOffset)) {
                eolPositions.add(it.getStart() - DocumentUtil.getLineStartOffset((int)it.getStart(), (Document)document));
            }
            skipCurrentEOLEsc = false;
            it.retreat();
        }
        it.advance();
        IElementType iElementType = maybeDirectiveType = it.atEnd() || OCLineIndentProvider.containsNewLine(documentChars, caretOffset, it.getStart()) ? null : it.getTokenType();
        if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(maybeDirectiveType)) {
            if (OCTokenTypes.END_IF_DIRECTIVES.contains(maybeDirectiveType)) {
                it.retreat();
                if (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE && OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                    int endOffset = it.getEnd();
                    String ordinalIndent = (String)OCMultilineNodeFormatter.splitIndent((String)documentChars.subSequence((int)it.getStart(), (int)it.getEnd()).toString()).second;
                    String newIndent = OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(it, file, false);
                    if (newIndent != null && !newIndent.equals(ordinalIndent)) {
                        document.replaceString(endOffset - ordinalIndent.length(), endOffset, (CharSequence)newIndent);
                        caretOffset += newIndent.length() - ordinalIndent.length();
                    }
                }
            }
            boolean generateNewLine = true;
            if (!it.atEnd()) {
                Pair<Integer, Boolean> offsetNewLine = OCEnterInDirectiveAndNoncompiledHandler.processEOLGeneration(editor, caretOffset, maybeDirectiveType, it.getEnd(), eolPositions);
                caretOffset = (Integer)offsetNewLine.first;
                generateNewLine = (Boolean)offsetNewLine.second;
            }
            Caret caret = editor.getCaretModel().getCurrentCaret();
            caret.moveToOffset(caretOffset);
            if (generateNewLine) {
                originalHandler.execute(editor, caret, dataContext);
                int indentNoCommit = EnterHandler.adjustLineIndentNoCommit((Language)language, (Document)document, (Editor)editor, (int)caret.getOffset());
                if (indentNoCommit >= 0) {
                    caret.moveToOffset(indentNoCommit);
                }
            }
            caretOffsetRef.set((Object)caret.getOffset());
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @NotNull
    private static Pair<Integer, Boolean> processEOLGeneration(@NotNull Editor editor, int caretOffset, @NotNull IElementType maybeDirectiveType, int endOfDirective, @NotNull ArrayList<Integer> eolPositions) {
        if (editor == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(5);
        }
        if (maybeDirectiveType == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(6);
        }
        if (eolPositions == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        CharSequence documentChars = document.getCharsSequence();
        boolean generateNewLine = true;
        boolean caretJustAfterNewLineOfEOLEsc = false;
        int shiftInlineRightPosition = 0;
        int replacementForEOLSuffixStart = caretOffset;
        int replacementForEOLSuffixEnd = caretOffset;
        if (OCEnterInDirectiveAndNoncompiledHandler.hasBackSlashBefore(EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset))) {
            Pair pair = Pair.create((Object)caretOffset, (Object)true);
            if (pair == null) {
                OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(8);
            }
            return pair;
        }
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)(caretOffset + 1));
        if (!it.atEnd() && it.getTokenType() == OCTokenTypes.EOL_ESCAPE && caretOffset != it.getStart()) {
            replacementForEOLSuffixStart = it.getStart();
            boolean hasNewLine = documentChars.charAt(it.getEnd() - 1) == '\n';
            replacementForEOLSuffixEnd = hasNewLine ? it.getEnd() - 1 : it.getEnd();
            it.retreat();
            generateNewLine = false;
            if (!hasNewLine) {
                document.insertString(replacementForEOLSuffixEnd, (CharSequence)"\n");
                shiftInlineRightPosition = 1;
                eolPositions.clear();
            } else if (replacementForEOLSuffixEnd + 1 == documentChars.length()) {
                document.insertString(documentChars.length(), (CharSequence)"\n");
                shiftInlineRightPosition = caretOffset + 1 == documentChars.length() ? 2 : 1;
            } else {
                int lineEndOffset = CharArrayUtil.shiftForwardUntil((CharSequence)documentChars, (int)caretOffset, (String)"\n");
                shiftInlineRightPosition = CharArrayUtil.shiftForward((CharSequence)documentChars, (int)(lineEndOffset + 1), (String)" \t") - lineEndOffset;
            }
        } else if (it.atEnd() || caretOffset == documentChars.length() || OCTokenTypes.WHITESPACES.contains(it.getTokenType())) {
            if (it.atEnd() || caretOffset == documentChars.length()) {
                Pair pair = Pair.create((Object)caretOffset, (Object)true);
                if (pair == null) {
                    OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(9);
                }
                return pair;
            }
            if (it.getEnd() == documentChars.length() || OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                Pair pair = Pair.create((Object)caretOffset, (Object)true);
                if (pair == null) {
                    OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(10);
                }
                return pair;
            }
            it.advance();
            if (it.atEnd() || OCTokenTypes.WHITESPACES.contains(it.getTokenType()) && OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                Pair pair = Pair.create((Object)caretOffset, (Object)true);
                if (pair == null) {
                    OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(11);
                }
                return pair;
            }
            it.retreat();
        } else if (!OCTokenTypes.WHITESPACES.contains(it.getTokenType()) && caretOffset > 0 && caretOffset == it.getStart()) {
            it.retreat();
            boolean bl = caretJustAfterNewLineOfEOLEsc = it.getTokenType() == OCTokenTypes.EOL_ESCAPE;
        }
        if (!it.atEnd() && (OCTokenTypes.WHITESPACES.contains(it.getTokenType()) || caretJustAfterNewLineOfEOLEsc)) {
            int newLinePos;
            if (generateNewLine) {
                replacementForEOLSuffixEnd = it.getEnd();
            }
            if ((newLinePos = StringUtil.lastIndexOf((CharSequence)documentChars, (char)'\n', (int)it.getStart(), (int)it.getEnd())) >= 0 && !caretJustAfterNewLineOfEOLEsc) {
                replacementForEOLSuffixStart = newLinePos + 1;
            } else {
                if (caretJustAfterNewLineOfEOLEsc) {
                    replacementForEOLSuffixStart = caretOffset;
                } else {
                    replacementForEOLSuffixStart = it.getStart();
                    it.retreat();
                }
                if (!it.atEnd() && it.getTokenType() == OCTokenTypes.EOL_ESCAPE && generateNewLine) {
                    replacementForEOLSuffixEnd = replacementForEOLSuffixStart;
                    generateNewLine = false;
                    shiftInlineRightPosition = caretOffset - DocumentUtil.getLineStartOffset((int)caretOffset, (Document)document) + 1;
                    document.insertString(replacementForEOLSuffixStart, (CharSequence)"\n");
                }
            }
        }
        if (replacementForEOLSuffixStart >= endOfDirective && (OCTokenTypes.IF_DIRECTIVES.contains(maybeDirectiveType) || maybeDirectiveType == OCTokenTypes.DEFINE_DIRECTIVE)) {
            String tailStub;
            int inlineEnterOffset = replacementForEOLSuffixStart - DocumentUtil.getLineStartOffset((int)replacementForEOLSuffixStart, (Document)document);
            int inlineEOLOffset = -1;
            if (!eolPositions.isEmpty()) {
                for (int i = eolPositions.size() - 1; i >= 0; --i) {
                    int eolPos = eolPositions.get(i);
                    if (eolPos < inlineEnterOffset) continue;
                    inlineEOLOffset = eolPos;
                    break;
                }
            }
            int caretLineOffset = DocumentUtil.getLineStartOffset((int)caretOffset, (Document)document);
            if (generateNewLine && inlineEOLOffset < 0 && caretLineOffset == DocumentUtil.getLineStartOffset((int)endOfDirective, (Document)document)) {
                inlineEOLOffset = caretOffset - caretLineOffset;
                char c = documentChars.charAt(caretOffset == 0 ? 0 : caretOffset - 1);
                if (c != '\\' && !StringUtil.isWhiteSpace((char)c)) {
                    ++inlineEOLOffset;
                }
            }
            String string = tailStub = inlineEOLOffset < 0 ? " \\" : StringUtil.repeat((String)" ", (int)Math.max(0, inlineEOLOffset - inlineEnterOffset)) + "\\";
            if (replacementForEOLSuffixStart == replacementForEOLSuffixEnd) {
                document.insertString(replacementForEOLSuffixStart, (CharSequence)tailStub);
            } else {
                document.replaceString(replacementForEOLSuffixStart, replacementForEOLSuffixEnd, (CharSequence)tailStub);
            }
            caretOffset = replacementForEOLSuffixStart + tailStub.length() + shiftInlineRightPosition;
        }
        Pair pair = Pair.create((Object)caretOffset, (Object)generateNewLine);
        if (pair == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(12);
        }
        return pair;
    }

    private static boolean hasBackSlashBefore(@NotNull HighlighterIterator it) {
        if (it == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(13);
        }
        if (!it.atEnd() && OCTokenTypes.WHITESPACES.contains(it.getTokenType())) {
            it.retreat();
        }
        return !it.atEnd() && it.getTokenType() == TokenType.BAD_CHARACTER;
    }

    public boolean invokeInsideIndent(int newLineCharOffset, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Language language;
        if (editor == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(14);
        }
        if (dataContext == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(15);
        }
        if (!OCLanguageUtils.isSupported(language = EnterHandler.getLanguage((DataContext)dataContext)) || newLineCharOffset < 1) {
            return false;
        }
        Document document = editor.getDocument();
        CharSequence documentChars = document.getCharsSequence();
        int maybeEOLEscOffset = CharArrayUtil.shiftBackward((CharSequence)documentChars, (int)(newLineCharOffset - 1), (String)" \t");
        return maybeEOLEscOffset >= 0 && documentChars.charAt(maybeEOLEscOffset) == '\\';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeDirectiveType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eolPositions";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processEOLGeneration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processEOLGeneration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasBackSlashBefore";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invokeInsideIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

