/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers;
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        if (codeFragment == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(0);
        }
        this(new PsiElement[]{codeFragment}, parentAnalyzer, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @Nullable TextRange selection) {
        if (codeFragments == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this(codeFragments, null, selection);
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        if (codeFragment == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(2);
        }
        this(new PsiElement[]{codeFragment}, null, selection);
    }

    private OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @Nullable OCDataFlowAnalyzer parentAnalyzer, @Nullable TextRange selection) {
        if (codeFragments == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this.myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myParentAnalyzer = parentAnalyzer;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        OCControlFlowGraph oCControlFlowGraph = this.myGraph;
        if (oCControlFlowGraph == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(4);
        }
        return oCControlFlowGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (element == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(5);
        }
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        OCUnreachableCodeFinder oCUnreachableCodeFinder = this.myUnreachableCodeFinder;
        if (oCUnreachableCodeFinder == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(6);
        }
        return oCUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        List<OCSymbol> list = this.myInputVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        List<OCSymbol> list = this.myOutputVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        List<OCSymbol> list = this.myWrittenVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        List<OCSymbol> list = this.myEscapedDeclarators;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
    }

    public void analyze() {
        for (OCSymbol symbol : this.myGraph.getLocalSymbols()) {
            if (symbol.isUnnamed()) continue;
            this.analyzeInputOutput(symbol);
        }
        for (OCSymbol symbol : this.myGraph.getClosureSymbols()) {
            if (symbol.isUnnamed()) continue;
            this.analyzeInputOutput(symbol);
        }
        for (OCDataFlowAnalyzer kid : this.myChildAnalyzers) {
            kid.analyze();
            this.myInputVariables.addAll(kid.getInputVariables());
            this.myOutputVariables.addAll(kid.getOutputVariables());
            this.myEscapedDeclarators.addAll(kid.getEscapedDeclarators());
            this.myWrittenVariables.addAll(kid.getWrittenVariables());
            for (OCSymbol symbol : kid.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, kid.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator<OCSymbol> comparator = Comparator.comparingInt(OCSymbol::getOffset);
            this.myInputVariables.sort(comparator);
            this.myOutputVariables.sort(comparator);
            this.myWrittenVariables.sort(comparator);
            this.myEscapedDeclarators.sort(comparator);
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(11);
        }
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(12);
        }
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragments";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnreachableCodeFinder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenVariables";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedDeclarators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findGraph";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "analyzeInputOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariableUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

