/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSRecentCache;", "Lcom/intellij/openapi/Disposable;", "()V", "cache", "Lcom/google/common/cache/Cache;", "", "dispose", "", "getLastUsedTargetIfExists", "Lcom/intellij/openapi/vfs/VirtualFile;", "source", "putTarget", "target", "intellij.c"})
public final class OCSwitchHSRecentCache
implements Disposable {
    @NotNull
    private final Cache<String, String> cache;

    public OCSwitchHSRecentCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(200L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    public final void putTarget(@NotNull VirtualFile source, @NotNull VirtualFile target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.cache.put((Object)source.getUrl(), (Object)target.getUrl());
    }

    @Nullable
    public final VirtualFile getLastUsedTargetIfExists(@NotNull VirtualFile source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = (String)this.cache.getIfPresent((Object)source.getUrl());
        if (string == null) {
            return null;
        }
        String url = string;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    public void dispose() {
        this.cache.invalidateAll();
    }
}

