/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSDebugListener;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandlerImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSDebugAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "calcAllFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "checkFile", "file", "processed", "Ljava/util/concurrent/atomic/AtomicInteger;", "total", "", "processProject", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCSwitchHSDebugAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCSwitchHSDebugAction.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSDebugAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,67:1\n1477#2:68\n1502#2,3:69\n1505#2,3:79\n372#3,7:72\n*S KotlinDebug\n*F\n+ 1 OCSwitchHSDebugAction.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSDebugAction\n*L\n57#1:68\n57#1:69,3\n57#1:79,3\n57#1:72,7\n*E\n"})
public final class OCSwitchHSDebugAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.processProject(project2);
    }

    private final void processProject(Project project) {
        List<VirtualFile> files = this.calcAllFiles(project);
        int nThreads = 8;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        int total = files.size();
        AtomicInteger processed = new AtomicInteger(0);
        for (VirtualFile file : files) {
            if (!OCLanguageUtils.isSupported((VirtualFile)file)) continue;
            executorService.submit(() -> OCSwitchHSDebugAction.processProject$lambda$0(this, file, project, processed, total));
        }
    }

    private final List<VirtualFile> calcAllFiles(Project project) {
        List result = new ArrayList();
        FileBasedIndex.getInstance().iterateIndexableFiles(arg_0 -> OCSwitchHSDebugAction.calcAllFiles$lambda$1(project, result, arg_0), project, (ProgressIndicator)new EmptyProgressIndicator());
        return result;
    }

    private final void checkFile(VirtualFile file, Project project, AtomicInteger processed, int total) {
        OCSwitchHSDebugListener sink = new OCSwitchHSDebugListener();
        OCSwitchHSHandlerImpl handler = new OCSwitchHSHandlerImpl(file, project);
        handler.invoke(sink);
        List<VirtualFile> result = sink.getResult().get();
        String severity = switch (result.size()) {
            case 0 -> "S1";
            case 1 -> "S0";
            default -> {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNull(result);
                Iterable $this$groupBy$iv = result;
                boolean $i$f$groupBy = false;
                Iterable var11_10 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object v1;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean $i$a$-groupBy-OCSwitchHSDebugAction$checkFile$severity$1 = false;
                    String key$iv$iv = it.getCanonicalPath();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v1 = answer$iv$iv$iv;
                    } else {
                        v1 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)v1;
                    list$iv$iv.add(element$iv$iv);
                }
                yield destination$iv$iv.size() == 1 ? "S2" : "S3";
            }
        };
        processed.incrementAndGet();
        if (Intrinsics.areEqual((Object)severity, (Object)"S3")) {
            System.out.println((Object)("[" + processed.get() + "/" + total + "]: " + file + " " + result + " " + severity));
        }
    }

    private static final void processProject$lambda$0(OCSwitchHSDebugAction this$0, VirtualFile $file, Project $project, AtomicInteger $processed, int $total) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$processed, (String)"$processed");
        this$0.checkFile($file, $project, $processed, $total);
    }

    private static final boolean calcAllFiles$lambda$1(Project $project, List $result, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (OCSearchScope.isInProjectSources($project, it) && OCLanguageUtils.isSupported((VirtualFile)it)) {
            $result.add(it);
        }
        return true;
    }
}

