/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageKindContributor;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.light.psi.OCLightFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageUtils
extends OCLanguageUtilsBase {
    private OCLanguageUtils() {
    }

    @NotNull
    public static Language getConfigLanguage() {
        Language language = OCLanguageUtilsBase.getConfigLanguage();
        if (language == null) {
            OCLanguageUtils.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public static Language getLightLanguage() {
        Language language = OCLanguageUtilsBase.getLightLanguage();
        if (language == null) {
            OCLanguageUtils.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    public static Language getSlowLanguage() {
        Language language = OCLanguageUtilsBase.getSlowLanguage();
        if (language == null) {
            OCLanguageUtils.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    public static FileType getBaseFileType() {
        FileType fileType = OCLanguageUtilsBase.getBaseFileType();
        if (fileType == null) {
            OCLanguageUtils.$$$reportNull$$$0(3);
        }
        return fileType;
    }

    public static boolean isSupported(@Nullable Language language) {
        return OCLanguageUtilsBase.isSupported((Language)language);
    }

    @Contract(value="null -> false")
    public static boolean isSupported(@Nullable PsiFile file) {
        return file instanceof OCFile || file instanceof OCLightFile && OCLanguageUtils.assertLightPsiOn((Object)file);
    }

    public boolean isSupportedFile(@Nullable PsiFile file) {
        return OCLanguageUtils.isSupported(file);
    }

    public boolean isSupportedFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            OCLanguageUtils.$$$reportNull$$$0(4);
        }
        return FileTypeManager.getInstance().isFileOfType(virtualFile, (FileType)OCFileType.INSTANCE) || virtualFile.getName().equals("c_cpp_properties.json") || virtualFile.getName().equals("CppProperties.json");
    }

    public boolean isSupportedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            OCLanguageUtils.$$$reportNull$$$0(5);
        }
        return fileType == OCFileType.INSTANCE;
    }

    @Contract(value="null -> false")
    public static boolean supportsResolve(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return true;
        }
        return file != null && OCLanguageKindContributor.isSupported(file);
    }

    @Contract(value="null -> null")
    public static OCPsiFile asOCPsiFile(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return (OCPsiFile)file;
        }
        return null;
    }

    @Contract(value="_, null -> null")
    public static OCPsiFile asOCPsiFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(6);
        }
        if (file == null) {
            return null;
        }
        return OCLanguageUtils.asOCPsiFile(OCLanguageUtils.asPsiFile(file, project));
    }

    @Nullable
    public static PsiFile asPsiFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCLanguageUtils.$$$reportNull$$$0(7);
        }
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return PsiManager.getInstance((Project)project).findFile(file);
        }
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file));
    }

    @Contract(value="null -> null")
    public static OCFile asOCFile(@Nullable PsiFile file) {
        OCPsiFile opf = OCLanguageUtils.asOCPsiFile(file);
        return opf == null ? null : opf.getOCFile();
    }

    @Contract(value="_, null -> null")
    public static OCFile asOCFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(9);
        }
        return OCLanguageUtils.asOCFile(OCLanguageUtils.asOCPsiFile(project, file));
    }

    @Contract(value="!null -> !null; null -> null")
    public static PsiFile tryGetOCFile(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile == null ? file : ocFile;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile != null ? ocFile : (OCLanguageUtils.supportsResolve(file) ? file : null);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(10);
        }
        return file != null ? OCLanguageUtils.asFileWithOCResolve(OCLanguageUtils.asPsiFile(file, project)) : null;
    }

    @NotNull
    public static CidrLexerSettings createLexerSettingsForContext(@NotNull OCInclusionContext context) {
        if (context == null) {
            OCLanguageUtils.$$$reportNull$$$0(11);
        }
        CidrLexerSettings.Builder builder2 = new CidrLexerSettings.Builder((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE, context.getLanguageKind());
        if (OCCompilerFeaturesHelper.supportsNullability(context)) {
            builder2.allowNullabilityKeywords();
        }
        if (OCCompilerFeaturesHelper.supportsNullabilityNullableResult(context)) {
            builder2.allowNullabilityNullableResultKeywords();
        }
        if (OCCompilerFeaturesHelper.supportsGccAutoType(context)) {
            builder2.allowGccAutoType();
        }
        if (OCCompilerFeaturesHelper.supportsAvailableExpression(context)) {
            builder2.allowAvailabilityExpression();
        }
        if (OCCompilerFeaturesHelper.supportsMsvcExtensions(context)) {
            builder2.allowMsvcExtensions();
        }
        builder2.setLanguageStandard(OCCompilerFeaturesHelper.getLanguageStandard(context, null));
        CidrLexerSettings cidrLexerSettings = builder2.build();
        if (cidrLexerSettings == null) {
            OCLanguageUtils.$$$reportNull$$$0(12);
        }
        return cidrLexerSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCLanguageUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSlowLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCLanguageUtils";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexerSettingsForContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFileType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asOCPsiFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asPsiFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "asOCFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "asFileWithOCResolve";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLexerSettingsForContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

