/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementForCacheImpl;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrTestScopeSerialization {
    @NotNull
    @Contract(value="_ -> new")
    public static CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> getTestSerializer(Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        return new CidrTestWithScopeElementsSerializer(generator);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForCaching(final @Nullable String testName, final @Nullable String suiteName, final long offsetAsNaturalOrder, final @Nullable String uniqueTestBodyElementId, @NotNull PsiFile pfile, final @Nullable OCSymbolKind kind, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function) {
        void generator;
        if (pfile == null) {
            CidrTestScopeSerialization.$$$reportNull$$$0(0);
        }
        if (function == null) {
            CidrTestScopeSerialization.$$$reportNull$$$0(1);
        }
        return new CidrTestScopeElementWithSerializerImpl(pfile, offsetAsNaturalOrder, suiteName, testName, (Function)generator){

            @Override
            public void write(@NotNull Output output) {
                if (output == null) {
                    1.$$$reportNull$$$0(0);
                }
                output.writeString(testName);
                output.writeString(suiteName);
                output.writeLong(offsetAsNaturalOrder);
                output.writeString(uniqueTestBodyElementId);
                output.writeString(kind == null ? null : kind.toString());
            }

            protected void verify(@Nullable PsiFile psiFile2, @NotNull VirtualFile vFile) {
                if (vFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.verify(psiFile2, vFile);
                if (OCLanguageUtils.tryGetOCFile(psiFile2) == null) {
                    CidrTestLog.LOG.error("File is not C/C++/ObjC/ObjC++", new String[]{vFile.getPath()});
                }
            }

            @Contract(pure=true)
            protected PsiElement findFromOrderInFile(@NotNull PsiFile psiFile2) {
                if (psiFile2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiFile2.findElementAt(OCSymbolOffsetUtil.getTextOffset(offsetAsNaturalOrder));
            }

            @Nullable
            protected PsiElement getElementSlow(@NotNull PsiFile psiFile2) {
                OCFile realSource;
                OCFile source;
                block9: {
                    block8: {
                        if (psiFile2 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (!(psiFile2 instanceof OCFile)) break block8;
                        source = (OCFile)psiFile2;
                        if (uniqueTestBodyElementId != null) break block9;
                    }
                    return null;
                }
                OCSymbolReference.GlobalReference bodyRef = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.parse(uniqueTestBodyElementId));
                if (OCRootKind.getRootKind(psiFile2) == OCRootKind.Include && (realSource = ((OCFile)psiFile2).getAssociatedFile()) != null) {
                    source = realSource;
                }
                List<OCSymbol> symbols = bodyRef.resolveToSymbols(OCResolveContext.forPsi(source));
                OCSymbol preDeclaration = null;
                for (OCSymbol symbol : symbols) {
                    PsiElement element = this.extractElement(symbol);
                    if (element != null) {
                        return element;
                    }
                    if (preDeclaration != null || symbol.getKind() != OCSymbolKind.FUNCTION_PREDECLARATION) continue;
                    preDeclaration = symbol;
                }
                if (preDeclaration != null) {
                    return this.extractElement(preDeclaration.getDefinitionSymbol(source.getProject()));
                }
                return null;
            }

            @Nullable
            public String getId() {
                return uniqueTestBodyElementId;
            }

            @Contract(value="null -> null")
            @Nullable
            private PsiElement extractElement(@Nullable OCSymbol symbol) {
                if (symbol != null && symbol.getKind() == kind) {
                    return OCSymbolHolderVirtualPsiElement.create(symbol, this.myProject);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "vFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "write";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verify";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findFromOrderInFile";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getElementSlow";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "generator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization";
        objectArray[2] = "createTestScopeElementForCaching";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CidrTestWithScopeElementsSerializer
    implements CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator;
        private static final int SKIP_WATERMARK = -1;
        private static final int TEST_WITH_SCOPE_ELEMENTS_SERIALIZER = 0;

        public CidrTestWithScopeElementsSerializer() {
            this.myGenerator = null;
        }

        public CidrTestWithScopeElementsSerializer(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (generator == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(0);
            }
            this.myGenerator = generator;
        }

        public void setGenerator(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (generator == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(1);
            }
            this.myGenerator = generator;
        }

        @Override
        public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestScopeElement testScope) {
            if (kryo == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(2);
            }
            if (output == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(3);
            }
            if (testScope == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(4);
            }
            if (testScope instanceof CidrTestScopeElementWithSerializerImpl) {
                output.writeInt(0);
                ((CidrTestScopeElementWithSerializerImpl)testScope).write(output);
                return;
            }
            output.writeInt(-1);
        }

        @Override
        @Nullable
        public CidrTestScopeElement read(@NotNull Kryo kryo, @NotNull Input input, @NotNull PsiFile psiFileWithTest) {
            int watermark;
            if (kryo == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(5);
            }
            if (input == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(6);
            }
            if (psiFileWithTest == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(7);
            }
            if ((watermark = input.readInt()) == 0) {
                return CidrTestScopeElementWithSerializerImpl.read(input, psiFileWithTest, this.getGenerator());
            }
            return null;
        }

        @NotNull
        @Contract(pure=true)
        public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
            assert (this.myGenerator != null);
            Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function = this.myGenerator;
            if (function == null) {
                CidrTestWithScopeElementsSerializer.$$$reportNull$$$0(8);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kryo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testScope";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFileWithTest";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestWithScopeElementsSerializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestWithScopeElementsSerializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setGenerator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class CidrTestScopeElementWithSerializerImpl
    extends CidrTestScopeElementForCacheImpl {
        /*
         * WARNING - void declaration
         */
        CidrTestScopeElementWithSerializerImpl(@NotNull PsiFile psiFile2, long offsetAsNaturalOrder, @Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function) {
            void generator;
            if (psiFile2 == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(0);
            }
            if (function == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(1);
            }
            super(psiFile2, offsetAsNaturalOrder, suiteName, testName, (Function)generator);
        }

        public abstract void write(@NotNull Output var1);

        @NotNull
        public static CidrTestScopeElement read(@NotNull Input input, @NotNull PsiFile psiFileWithTest, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            if (input == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(2);
            }
            if (psiFileWithTest == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(3);
            }
            if (generator == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(4);
            }
            String testName = input.readString();
            String suiteName = input.readString();
            long offsetAsNaturalOrder = input.readLong();
            String uniqueTestBodyElementId = input.readString();
            String name = input.readString();
            OCSymbolKind kind = StringUtil.isEmpty((String)name) ? null : OCSymbolKind.valueOf(name);
            CidrTestScopeElement cidrTestScopeElement = CidrTestScopeSerialization.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, uniqueTestBodyElementId, psiFileWithTest, kind, generator);
            if (cidrTestScopeElement == null) {
                CidrTestScopeElementWithSerializerImpl.$$$reportNull$$$0(5);
            }
            return cidrTestScopeElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFileWithTest";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestScopeElementWithSerializerImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeSerialization$CidrTestScopeElementWithSerializerImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

