/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.InfoItemImpl;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DoxygenCommentTagImpl
implements TagItem,
ComplexItemBuilder {
    private final String name;
    private final String options;
    private final List<String> params;
    private final List<InfoItem> items;

    public DoxygenCommentTagImpl(@NotNull DxDocTag tag) {
        if (tag == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(0);
        }
        this.items = new ArrayList<InfoItem>();
        this.name = tag.getName();
        this.options = tag.getOptions().isEmpty() ? "" : "[" + StringUtil.join(tag.getOptions(), (String)", ") + "]";
        this.params = ContainerUtil.map(tag.getParamList(), p -> p.getName());
    }

    public DoxygenCommentTagImpl(String tagName, String options, String paramName, String description) {
        this.items = new ArrayList<InfoItem>();
        this.name = tagName;
        this.options = options;
        this.params = Collections.singletonList(paramName);
        this.addText(description);
    }

    @Override
    public void addText(@NotNull String text) {
        if (text == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(1);
        }
        if (text.isEmpty()) {
            return;
        }
        this.items.add(new InfoItemImpl(text));
    }

    @Override
    public void addTag(@NotNull TagItem item) {
        if (item == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(2);
        }
        this.items.add(item);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getOptions() {
        String string = this.options;
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List<String> list = this.params;
        if (list == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public String getDescription() {
        String description = "";
        if (DoxygenCmd.ESCAPE_TAGS.contains(this.name)) {
            description = "--".equals(this.name) ? "&#8211;" : ("---".equals(this.name) ? "&#8212;" : ("n".equals(this.name) ? "<br/>" : StringUtil.escapeXmlEntities((String)this.name)));
        }
        String string = description + StringUtil.join(this.items, InfoItem::getDescription, (String)" ");
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public List<InfoItem> getContent() {
        return new ArrayList<InfoItem>(this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoxygenCommentTagImpl tag = (DoxygenCommentTagImpl)o;
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(tag.options) : tag.options != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(tag.params) : tag.params != null) {
            return false;
        }
        return this.items.equals(tag.items);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + this.items.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentTagImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentTagImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTag";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

