/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.push.GitPushListener;
import git4idea.push.GitPushNotificationCustomizer;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushResultNotification;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitVcsPushOptionValue;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.HashRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J:\u0010\u000e\u001a\u00020\r2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JN\u0010\u000e\u001a\u00020\r2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00110\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgit4idea/push/GitPusher;", "Lcom/intellij/dvcs/push/Pusher;", "Lgit4idea/repo/GitRepository;", "Lgit4idea/push/GitPushSource;", "Lgit4idea/push/GitPushTarget;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lgit4idea/config/GitVcsSettings;", "pushSupport", "Lgit4idea/push/GitPushSupport;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/config/GitVcsSettings;Lgit4idea/push/GitPushSupport;)V", "expireExistingErrorsAndWarnings", "", "push", "pushSpecs", "", "Lcom/intellij/dvcs/push/PushSpec;", "additionalOption", "Lcom/intellij/dvcs/push/VcsPushOptionValue;", "force", "", "optionValue", "customParams", "", "Companion", "intellij.vcs.git"})
public final class GitPusher
extends Pusher<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitVcsSettings settings;
    @NotNull
    private final GitPushSupport pushSupport;

    public GitPusher(@NotNull Project project, @NotNull GitVcsSettings settings, @NotNull GitPushSupport pushSupport) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)((Object)pushSupport), (String)"pushSupport");
        this.project = project;
        this.settings = settings;
        this.pushSupport = pushSupport;
    }

    public void push(@NotNull Map<GitRepository, ? extends PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable VcsPushOptionValue additionalOption, boolean force) {
        Intrinsics.checkNotNullParameter(pushSpecs, (String)"pushSpecs");
        this.push(pushSpecs, additionalOption, force, MapsKt.emptyMap());
    }

    public void push(@NotNull Map<GitRepository, ? extends PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable VcsPushOptionValue optionValue, boolean force, @NotNull Map<String, ? extends VcsPushOptionValue> customParams) {
        Intrinsics.checkNotNullParameter(pushSpecs, (String)"pushSpecs");
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        this.expireExistingErrorsAndWarnings();
        Pair pair = optionValue instanceof GitVcsPushOptionValue ? TuplesKt.to((Object)((Object)((GitVcsPushOptionValue)optionValue).getPushTagMode()), (Object)((GitVcsPushOptionValue)optionValue).isSkipHook()) : TuplesKt.to(null, (Object)false);
        GitPushTagMode pushTagMode = (GitPushTagMode)((Object)pair.component1());
        boolean skipHook = (Boolean)pair.component2();
        this.settings.setPushTagMode(pushTagMode);
        GitPushOperation pushOperation = new GitPushOperation(this.project, this.pushSupport, pushSpecs, pushTagMode, force, skipHook);
        Companion.pushAndNotify(this.project, pushOperation, customParams);
    }

    private final void expireExistingErrorsAndWarnings() {
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(GitPushResultNotification.class, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        for (GitPushResultNotification notification2 : (GitPushResultNotification[])notificationArray) {
            if (notification2.getType() == NotificationType.INFORMATION) continue;
            notification2.expire();
        }
    }

    @JvmStatic
    public static final void pushAndNotify(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull Map<String, ? extends VcsPushOptionValue> customParams) {
        Companion.pushAndNotify(project, pushOperation, customParams);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007\u00a8\u0006\r"}, d2={"Lgit4idea/push/GitPusher$Companion;", "", "()V", "pushAndNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "pushOperation", "Lgit4idea/push/GitPushOperation;", "customParams", "", "", "Lcom/intellij/dvcs/push/VcsPushOptionValue;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitPusher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPusher.kt\ngit4idea/push/GitPusher$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n215#2,2:102\n1855#3,2:104\n*S KotlinDebug\n*F\n+ 1 GitPusher.kt\ngit4idea/push/GitPusher$Companion\n*L\n69#1:102,2\n95#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void pushAndNotify(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull Map<String, ? extends VcsPushOptionValue> customParams) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pushOperation, (String)"pushOperation");
            Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
            GitPushResult gitPushResult = pushOperation.execute();
            Intrinsics.checkNotNullExpressionValue((Object)gitPushResult, (String)"execute(...)");
            GitPushResult pushResult = gitPushResult;
            GitPushListener pushListener = (GitPushListener)project.getMessageBus().syncPublisher(GitPushListener.Companion.getTOPIC());
            Map<GitRepository, GitPushRepoResult> map2 = pushResult.getResults();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getResults(...)");
            Map<GitRepository, GitPushRepoResult> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<GitRepository, GitPushRepoResult>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GitRepository, GitPushRepoResult> element$iv;
                Map.Entry<GitRepository, GitPushRepoResult> entry = element$iv = iterator.next();
                boolean bl = false;
                GitRepository gitRepository = entry.getKey();
                GitPushRepoResult pushRepoResult = entry.getValue();
                Intrinsics.checkNotNull((Object)gitRepository);
                Intrinsics.checkNotNull((Object)pushRepoResult);
                pushListener.onCompleted(gitRepository, pushRepoResult, customParams);
            }
            Map<GitRepository, HashRange> map3 = pushResult.getUpdatedRanges();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getUpdatedRanges(...)");
            Map<GitRepository, HashRange> updatedRanges = map3;
            GitUpdateInfoAsLog.NotificationData notificationData = !updatedRanges.isEmpty() ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
            List actions2 = (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends AnAction>>, Object>(project, pushResult, customParams, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitPushResult $pushResult;
                final /* synthetic */ Map<String, VcsPushOptionValue> $customParams;
                {
                    this.$project = $project;
                    this.$pushResult = $pushResult;
                    this.$customParams = $customParams;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block7: {
                        var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = GitPushNotificationCustomizer.Companion.getEP_NAME().getExtensions((AreaInstance)this.$project);
                                var3_4 = this.$pushResult;
                                var4_5 = this.$customParams;
                                $i$f$flatMap = false;
                                var6_7 = $this$flatMap$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$flatMapTo = false;
                                var9_10 = $this$flatMapTo$iv$iv.iterator();
lbl13:
                                // 2 sources

                                while (var9_10.hasNext()) {
                                    element$iv$iv = var9_10.next();
                                    extension = (GitPushNotificationCustomizer)element$iv$iv;
                                    $i$a$-flatMap-GitPusher$Companion$pushAndNotify$actions$1$1 = false;
                                    Intrinsics.checkNotNullExpressionValue(var3_4.getResults(), (String)"getResults(...)");
                                    $i$f$flatMap = false;
                                    var15_16 = $this$flatMap$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$flatMapTo = false;
                                    var18_19 = $this$flatMapTo$iv$iv.entrySet().iterator();
lbl23:
                                    // 2 sources

                                    while (var18_19.hasNext()) {
                                        var20_21 = element$iv$iv = (Map.Entry)var18_19.next();
                                        $i$a$-flatMap-GitPusher$Companion$pushAndNotify$actions$1$1$1 = false;
                                        gitRepository = (GitRepository)var20_21.getKey();
                                        pushRepoResult = (GitPushRepoResult)var20_21.getValue();
                                        Intrinsics.checkNotNull((Object)gitRepository);
                                        Intrinsics.checkNotNull((Object)pushRepoResult);
                                        this.L$0 = var3_4;
                                        this.L$1 = var4_5;
                                        this.L$2 = destination$iv$iv;
                                        this.L$3 = var9_10;
                                        this.L$4 = extension;
                                        this.L$5 = destination$iv$iv;
                                        this.L$6 = var18_19;
                                        this.label = 1;
                                        v0 = extension.getActions(gitRepository, pushRepoResult, var4_5, (Continuation<? super List<? extends AnAction>>)this);
                                        if (v0 == var24_2) {
                                            return var24_2;
                                        }
                                        ** GOTO lbl60
                                    }
                                    break block0;
                                }
                                break block7;
                            }
                            case 1: {
                                $i$f$flatMap = false;
                                $i$f$flatMapTo = false;
                                $i$a$-flatMap-GitPusher$Companion$pushAndNotify$actions$1$1 = false;
                                $i$f$flatMap = false;
                                $i$f$flatMapTo = false;
                                $i$a$-flatMap-GitPusher$Companion$pushAndNotify$actions$1$1$1 = false;
                                var18_19 = (Iterator<Map.Entry<K, V>>)this.L$6;
                                destination$iv$iv = (Collection)this.L$5;
                                extension = (GitPushNotificationCustomizer)this.L$4;
                                var9_10 = (Iterator<T>)this.L$3;
                                destination$iv$iv = (Collection)this.L$2;
                                var4_5 = (Map)this.L$1;
                                var3_4 = (GitPushResult)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl60:
                                // 2 sources

                                list$iv$iv = (List)v0;
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                ** GOTO lbl23
                            }
                        }
                        list$iv$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        ** GOTO lbl13
                    }
                    return (List)destination$iv$iv;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends AnAction>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            ApplicationManager.getApplication().invokeLater(() -> Companion.pushAndNotify$lambda$2(project, pushResult, pushOperation, notificationData, customParams, actions2));
        }

        private static final void pushAndNotify$lambda$2(Project $project, GitPushResult $pushResult, GitPushOperation $pushOperation, GitUpdateInfoAsLog.NotificationData $notificationData, Map $customParams, List $actions) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$pushResult, (String)"$pushResult");
            Intrinsics.checkNotNullParameter((Object)$pushOperation, (String)"$pushOperation");
            Intrinsics.checkNotNullParameter((Object)$customParams, (String)"$customParams");
            Intrinsics.checkNotNullParameter((Object)$actions, (String)"$actions");
            boolean multiRepoProject = GitUtil.getRepositoryManager($project).moreThanOneRoot();
            GitPushResultNotification gitPushResultNotification = GitPushResultNotification.create($project, $pushResult, $pushOperation, multiRepoProject, $notificationData, $customParams);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitPushResultNotification), (String)"create(...)");
            GitPushResultNotification notification2 = gitPushResultNotification;
            Iterable $this$forEach$iv = $actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction action = (AnAction)element$iv;
                boolean bl = false;
                notification2.addAction(action);
            }
            notification2.notify($project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

