/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtilObsolete;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateTestHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateTestHandler(@NlsContexts.Command @NotNull String actionTitle, @NonNls @NotNull String templateName) {
        if (actionTitle == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(1);
        }
        super(actionTitle, templateName);
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return !editor.isDisposed() && CidrGoogleTestFramework.getInstance().isAvailable(file) && super.isValidFor(editor, file);
    }

    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(2);
        }
        return this.evaluateActionContext(null, (PsiElement)file);
    }

    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        PsiElement at;
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(3);
        }
        if (rangeMarker == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(4);
        }
        if (!((at = OCGoogleGenerateTestHandler.getFirstInsertedElement(file, rangeMarker)) instanceof OCMacroCall)) {
            at = PsiTreeUtil.getNextSiblingOfType((PsiElement)at, OCMacroCall.class);
        }
        if (at != null) {
            OCReferenceElement referenceElement = ((OCMacroCall)at).getMacroReferenceElement();
            List arguments = ((OCMacroCall)at).getArguments();
            if (referenceElement != null && referenceElement.getName().equals("TEST") && arguments.size() == 2) {
                String suiteName = CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(0));
                String testName = CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(1));
                if (OCGoogleGenerateTestHandler.migrateToParameterized(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTyped(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTypeParameterized(referenceElement, suiteName, testName)) {
                    return;
                }
                OCGoogleGenerateTestHandler.migrateToFixture(referenceElement, suiteName);
            }
        }
    }

    private static void migrateToFixture(@NotNull OCReferenceElement referenceElement, String suiteName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(5);
        }
        OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_F", (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.isGoogleTestClass((OCStructSymbol)symbol, referenceElement.getProject())), null);
    }

    private static boolean migrateToTypeParameterized(@NotNull OCReferenceElement referenceElement, String suiteName, String testName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(6);
        }
        Consumer consumer = symbol -> {
            OCReferenceElement macroReferenceElement;
            OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)symbol.locateDefinition(referenceElement.getProject()), OCDeclaration.class);
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getPrevSiblingOfType((PsiElement)declaration, OCMacroCall.class);
            if (macroCall != null && (macroReferenceElement = macroCall.getMacroReferenceElement()) != null && "REGISTER_TYPED_TEST_CASE_P".equals(macroReferenceElement.getName())) {
                List arguments = macroCall.getArguments();
                OCMacroCallArgument lastArgument = (OCMacroCallArgument)arguments.get(arguments.size() - 1);
                PsiElement newElement = OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, (PsiElement)macroCall);
                PsiElement added = OCChangeUtil.addAfter((PsiElement)macroCall, (PsiElement)newElement, (PsiElement)lastArgument);
                OCExpression element = OCElementFactory.expressionFromText((String)testName, (PsiElement)macroCall);
                if (element != null) {
                    OCChangeUtil.addAfter((PsiElement)macroCall, (PsiElement)element, (PsiElement)added);
                }
            }
        };
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_registered_test_names_" + suiteName + "_", referenceElement, "TYPED_TEST_P", null, (Consumer<OCSymbol>)consumer);
    }

    private static boolean migrateToTyped(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_type_params_" + suiteName + "_", referenceElement, "TYPED_TEST", null, null);
    }

    private static boolean migrateToParameterized(@NotNull OCReferenceElement referenceElement, String suiteName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(7);
        }
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_P", (Condition<OCSymbol>)((Condition)symbol -> {
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)referenceElement);
            return symbol instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.isGoogleTestClassWithAnyAncestor((OCStructSymbol)symbol, context, "TestWithParam", "WithParamInterface");
        }), null);
    }

    private static boolean correctMacroNameIfNeeded(@NlsSafe @NotNull String suiteName, @NotNull OCReferenceElement referenceElement, @NonNls @NotNull String correctMacroName, final @Nullable Condition<OCSymbol> condition, @Nullable Consumer<OCSymbol> onCorrection) {
        if (suiteName == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(8);
        }
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(9);
        }
        if (correctMacroName == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(10);
        }
        final OCFile file = referenceElement.getContainingOCFile();
        final Project project = referenceElement.getProject();
        CommonProcessors.FindFirstProcessor<OCSymbol> processor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return file.equals(symbol.getContainingOCFile(project)) && (condition == null || condition.value((Object)symbol));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)project, (Processor)processor, (String)suiteName);
        if (processor.isFound()) {
            WriteAction.runAndWait(() -> OCGoogleGenerateTestHandler.lambda$correctMacroNameIfNeeded$3(onCorrection, (CommonProcessors.FindFirstProcessor)processor, referenceElement, correctMacroName, file));
        }
        return processor.isFound();
    }

    @Nullable
    private static PsiElement getFirstInsertedElement(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(11);
        }
        if (rangeMarker == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(12);
        }
        PsiElement at = file.findElementAt(rangeMarker.getStartOffset());
        while (at instanceof PsiWhiteSpace) {
            at = at.getNextSibling();
        }
        at = PsiTreeUtil.getContextOfType((PsiElement)at, (boolean)false, (Class[])new Class[]{OCMacroCall.class, OCDeclaration.class});
        return at;
    }

    protected int getInsertPos(@NotNull PsiElement element, int caretOffset, @Nullable PsiElement at, @NotNull List<OCFunctionSymbol> members, @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        if (element == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(13);
        }
        if (members == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(14);
        }
        if (actionContext == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(15);
        }
        boolean insertAfter = false;
        Condition condition = element1 -> element1.getParent() instanceof OCFile || element1.getParent() instanceof OCCppNamespace;
        if (condition.value((Object)at)) {
            assert (at != null);
            return at.getTextRange().getEndOffset();
        }
        OCStruct struct = (OCStruct)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class});
        if (struct != null) {
            insertAfter = CidrGoogleTestUtilObsolete.isGoogleTestFixture((OCStructSymbol)struct.getSymbol(), false, element.getProject());
        }
        at = PsiTreeUtil.findFirstParent((PsiElement)at, (boolean)true, (Condition)condition);
        at = insertAfter ? PsiTreeUtil.getNextSiblingOfType((PsiElement)at, PsiWhiteSpace.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)at, PsiWhiteSpace.class);
        if (at != null) {
            return at.getTextRange().getEndOffset();
        }
        return -1;
    }

    private static /* synthetic */ void lambda$correctMacroNameIfNeeded$3(Consumer onCorrection, CommonProcessors.FindFirstProcessor processor, OCReferenceElement referenceElement, String correctMacroName, OCFile file) throws RuntimeException {
        if (onCorrection != null) {
            onCorrection.consume((Object)((OCSymbol)processor.getFoundValue()));
        }
        referenceElement.setNameOfIdentifier(correctMacroName);
        FileSymbolTablesCache.getInstance((Project)file.getProject()).scheduleReparseFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correctMacroName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateActionContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onTemplateFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToFixture";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToTypeParameterized";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToParameterized";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "correctMacroNameIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstInsertedElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getInsertPos";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

