/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.rider.utils.ConnectionException;
import com.jetbrains.rider.utils.DownloadHelperKt;
import com.jetbrains.rider.utils.DownloadStatusHandler;
import com.jetbrains.rider.utils.DownloadStatusHandlerSus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a:\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u001a$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u001a*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u0018\u001a\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u001a*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002\u001a8\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\u0018H\u0007\u001a4\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\"\u001a6\u0010#\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a<\u0010#\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010'\u001a.\u0010(\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a4\u0010(\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0007\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"downloadUrlToFile", "", "url", "", "file", "Ljava/io/File;", "authToken", "handler", "Lcom/jetbrains/rider/utils/DownloadStatusHandler;", "retryCount", "", "downloadUrlToFileSus", "Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;", "(Ljava/lang/String;Ljava/io/File;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchUrlSize", "", "getFilesCountFromArchive", "", "archiveFile", "excludeFileList", "getFilesFromTarGz", "tagGzFile", "getFilesFromZip", "isFileDownloadedAndConsistent", "", "cleanup", "isUrlReachable", "tryEstablishConnection", "Ljava/net/URLConnection;", "currentSize", "size", "unarchive", "destinationFolder", "unarchiveHere", "(Ljava/io/File;Ljava/io/File;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "untar", "tempFolder", "Ljava/nio/file/Path;", "symlinkBase", "(Ljava/io/File;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unzip", "outputFolder", "(Ljava/io/File;Ljava/lang/String;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDownloadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadHelper.kt\ncom/jetbrains/rider/utils/DownloadHelperKt\n+ 2 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,577:1\n31#2,2:578\n31#2,2:580\n31#2,2:583\n1#3:582\n*S KotlinDebug\n*F\n+ 1 DownloadHelper.kt\ncom/jetbrains/rider/utils/DownloadHelperKt\n*L\n143#1:578,2\n402#1:580,2\n520#1:583,2\n*E\n"})
public final class DownloadHelperKt {
    public static final boolean isFileDownloadedAndConsistent(@NotNull String url2, @NotNull File file2, @Nullable String authToken, boolean cleanup) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2.exists() && DownloadHelperKt.fetchUrlSize(url2, authToken) == file2.length()) {
            return true;
        }
        if (cleanup) {
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Files.deleteIfExists(path);
        }
        return false;
    }

    public static /* synthetic */ boolean isFileDownloadedAndConsistent$default(String string, File file2, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return DownloadHelperKt.isFileDownloadedAndConsistent(string, file2, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use suspend one")
    public static final void downloadUrlToFile(@NotNull String url2, @NotNull File file2, @Nullable String authToken, @NotNull DownloadStatusHandler handler2, int retryCount) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        if (handler2.isCancelled()) {
            return;
        }
        if (file2.exists()) {
            throw new Error("File " + file2 + " already exists");
        }
        long currentSize = 0L;
        long startTime = System.currentTimeMillis();
        int i = 1;
        if (i <= retryCount) {
            while (true) {
                Logger logger = handler2.getLogger();
                if (logger != null) {
                    logger.info("DownloadHelper: Attempt " + i + " to download url: " + url2);
                }
                try {
                    long size = DownloadHelperKt.fetchUrlSize(url2, authToken);
                    if (currentSize > size) {
                        currentSize = 0L;
                        Path path = file2.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        Files.deleteIfExists(path);
                    }
                    handler2.reportProgress(size, currentSize);
                    Logger logger2 = handler2.getLogger();
                    if (logger2 != null) {
                        logger2.info("DownloadHelper: Downloading " + url2 + " -> " + file2.getCanonicalPath());
                    }
                    Closeable closeable = new FileOutputStream(file2, currentSize > 0L);
                    Throwable throwable = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable;
                        boolean bl = false;
                        URLConnection conn = new URL(url2).openConnection();
                        if (currentSize > 0L) {
                            conn.setRequestProperty("Range", "bytes=" + currentSize + "-" + size);
                        }
                        if (authToken != null) {
                            conn.setRequestProperty("Authorization", "Bearer " + authToken);
                        }
                        conn.connect();
                        InputStream inputStream = conn.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        Closeable closeable2 = inputStream;
                        int n = 8192;
                        closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                        Throwable throwable2 = null;
                        try {
                            int len;
                            BufferedInputStream input = (BufferedInputStream)closeable2;
                            boolean bl2 = false;
                            int bufferSize = 0x100000;
                            byte[] buffer = new byte[bufferSize];
                            while ((len = input.read(buffer)) >= 1 && !handler2.isCancelled()) {
                                output.write(buffer, 0, len);
                                handler2.reportProgress(size, currentSize += (long)len);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        output = Unit.INSTANCE;
                    }
                    catch (Throwable output) {
                        throwable = output;
                        throw output;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (handler2.isCancelled()) {
                        return;
                    }
                    if (file2.length() != size) {
                        throw new Exception("DownloadHelper: Downloaded " + file2.length() + " bytes from " + url2 + " but expected " + size);
                    }
                    long downloadTime = System.currentTimeMillis() - startTime;
                    double speed = downloadTime <= 0L ? 0.0 : (double)size * 1000.0 / (double)downloadTime / 1048576.0;
                    double sizeMB = (double)size / 1048576.0;
                    Logger logger3 = handler2.getLogger();
                    if (logger3 != null) {
                        long l = downloadTime / (long)1000;
                        String string = "%.1f";
                        Object[] objectArray = new Object[]{sizeMB};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        string = "%.2f";
                        objectArray = new Object[]{speed};
                        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        logger3.info("DownloadHelper: Downloaded " + url2 + " in " + l + "s, size " + string2 + " MB, avg " + string3 + " MB/s");
                    }
                }
                catch (Throwable e) {
                    if (i < retryCount) {
                        Logger logger4 = handler2.getLogger();
                        if (logger4 != null) {
                            logger4.warn("DownloadHelper: Cannot download file " + e.getMessage(), e);
                        }
                    } else {
                        Logger logger5 = handler2.getLogger();
                        if (logger5 != null) {
                            logger5.error("DownloadHelper: Cannot download file " + e.getMessage(), e);
                        }
                        throw e;
                    }
                    if (i == retryCount) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static final Object downloadUrlToFileSus(@NotNull String var0, @NotNull File var1_1, @NotNull DownloadStatusHandlerSus var2_2, @Nullable String var3_3, int var4_4, @NotNull Continuation<? super Unit> var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ Object downloadUrlToFileSus$default(String string, File file2, DownloadStatusHandlerSus downloadStatusHandlerSus, String string2, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        return DownloadHelperKt.downloadUrlToFileSus(string, file2, downloadStatusHandlerSus, string2, n, (Continuation<? super Unit>)continuation);
    }

    private static final URLConnection tryEstablishConnection(String url2, long currentSize, long size, String authToken) {
        try {
            URLConnection conn = new URL(url2).openConnection();
            if (currentSize > 0L) {
                conn.setRequestProperty("Range", "bytes=" + currentSize + "-" + size);
            }
            if (authToken != null) {
                conn.setRequestProperty("Authorization", "Bearer " + authToken);
            }
            conn.setConnectTimeout(5000);
            conn.connect();
            Intrinsics.checkNotNull((Object)conn);
            return conn;
        }
        catch (Throwable e) {
            throw new ConnectionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isUrlReachable(@NotNull String url2, @Nullable String authToken) {
        URLConnection connection;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            connection = new URL(url2).openConnection();
            try {
                if (!(connection instanceof HttpURLConnection)) break block9;
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
                if (authToken != null) {
                    connection.setRequestProperty("Authorization", "Bearer " + authToken);
                }
                if (((HttpURLConnection)connection).getResponseCode() == 200) break block9;
                bl = false;
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
                HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return bl2;
            }
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return bl;
        }
        HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long fetchUrlSize(String url2, String authToken) {
        long l;
        URLConnection connection = new URL(url2).openConnection();
        try {
            long len;
            if (connection instanceof HttpURLConnection) {
                int responseCode;
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
                ((HttpURLConnection)connection).setConnectTimeout(30000);
                ((HttpURLConnection)connection).setReadTimeout(30000);
                if (authToken != null) {
                    connection.setRequestProperty("Authorization", "Bearer " + authToken);
                }
                if ((responseCode = ((HttpURLConnection)connection).getResponseCode()) != 200) {
                    String msg = url2 + " returned code " + responseCode + ", accepting only 200";
                    throw new ConnectionException(msg);
                }
            }
            if ((len = connection.getContentLengthLong()) <= 0L) {
                throw new ConnectionException("Unable to get size of " + url2);
            }
            l = len;
        }
        catch (Throwable e) {
            try {
                throw new ConnectionException(e);
            }
            catch (Throwable throwable) {
                block9: {
                    HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                    if (httpURLConnection == null) break block9;
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return l;
    }

    @Deprecated(message="Use suspend one")
    public static final void unarchive(@NotNull File archiveFile, @NotNull File destinationFolder, @NotNull List<String> excludeFileList, @NotNull DownloadStatusHandler handler2, boolean unarchiveHere) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)destinationFolder, (String)"destinationFolder");
        Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        if (handler2.isCancelled()) {
            return;
        }
        File folderForExtract = unarchiveHere ? destinationFolder : new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + ".temp");
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".tar.gz", (boolean)false, (int)2, null)) {
            Path path = folderForExtract.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path2 = destinationFolder.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            DownloadHelperKt.untar(archiveFile, path, path2, excludeFileList, handler2);
        } else {
            Object[] objectArray = new String[]{"zip", "nupkg"};
            if (ArraysKt.contains((Object[])objectArray, (Object)FilesKt.getExtension((File)archiveFile))) {
                String string2 = folderForExtract.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
                DownloadHelperKt.unzip(archiveFile, string2, excludeFileList, handler2);
            } else {
                throw new Exception("Unknown archive extension: " + archiveFile);
            }
        }
        if (unarchiveHere) {
            return;
        }
        Files.move(folderForExtract.toPath(), destinationFolder.toPath(), new CopyOption[0]);
    }

    public static /* synthetic */ void unarchive$default(File file2, File file3, List list, DownloadStatusHandler downloadStatusHandler, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        DownloadHelperKt.unarchive(file2, file3, (List<String>)list, downloadStatusHandler, bl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final Object unarchive(@NotNull File var0, @NotNull File var1_1, @NotNull List<String> var2_2, @NotNull DownloadStatusHandlerSus var3_3, @NotNull Continuation<? super Unit> var4_4) {
        block15: {
            block16: {
                if (!(var4_4 instanceof unarchive.1)) ** GOTO lbl-1000
                var9_5 = var4_4;
                if ((var9_5.label & -2147483648) != 0) {
                    var9_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return DownloadHelperKt.unarchive(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = archiveFile;
                        $continuation.L$1 = destinationFolder;
                        $continuation.L$2 = excludeFileList;
                        $continuation.L$3 = handler;
                        $continuation.label = 1;
                        v0 = handler.isCancelled((Continuation<? super Boolean>)$continuation);
                        if (v0 == var10_7) {
                            return var10_7;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        handler = (DownloadStatusHandlerSus)$continuation.L$3;
                        excludeFileList = (List)$continuation.L$2;
                        destinationFolder = (File)$continuation.L$1;
                        archiveFile = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        folderForExtract = new Ref.ObjectRef();
                        folderForExtract.element = new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + ".temp");
                        i = 1;
                        while (((File)folderForExtract.element).exists() && !FilesKt.deleteRecursively((File)((File)folderForExtract.element))) {
                            folderForExtract.element = new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + i + ".temp");
                            ++i;
                        }
                        v1 = archiveFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)v1, (String)".tar.gz", (boolean)false, (int)2, null)) break;
                        var7_10 = ((File)folderForExtract.element).toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"toPath(...)");
                        v2 = destinationFolder.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toPath(...)");
                        $continuation.L$0 = destinationFolder;
                        $continuation.L$1 = folderForExtract;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.label = 2;
                        v3 = DownloadHelperKt.untar(archiveFile, var7_10, v2, excludeFileList, handler, (Continuation<? super Unit>)$continuation);
                        if (v3 == var10_7) {
                            return var10_7;
                        }
                        break block15;
                    }
                    case 2: {
                        folderForExtract = (Ref.ObjectRef)$continuation.L$1;
                        destinationFolder = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block15;
                    }
                }
                var7_11 /* !! */  = new String[]{"zip", "nupkg"};
                if (!ArraysKt.contains((Object[])var7_11 /* !! */ , (Object)FilesKt.getExtension((File)archiveFile))) break block16;
                var7_11 /* !! */  = ((File)folderForExtract.element).getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)var7_11 /* !! */ , (String)"getCanonicalPath(...)");
                $continuation.L$0 = destinationFolder;
                $continuation.L$1 = folderForExtract;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 3;
                v4 = DownloadHelperKt.unzip(archiveFile, (String)var7_11 /* !! */ , excludeFileList, handler, (Continuation<? super Unit>)$continuation);
                if (v4 == var10_7) {
                    return var10_7;
                }
                break block15;
                {
                    case 3: {
                        folderForExtract = (Ref.ObjectRef)$continuation.L$1;
                        destinationFolder = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        break block15;
                    }
                }
            }
            throw new Exception("Unknown archive extension: " + archiveFile);
        }
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.label = 4;
        v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>((Ref.ObjectRef<File>)folderForExtract, destinationFolder, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<File> $folderForExtract;
            final /* synthetic */ File $destinationFolder;
            {
                this.$folderForExtract = $folderForExtract;
                this.$destinationFolder = $destinationFolder;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Files.move(((File)this.$folderForExtract.element).toPath(), this.$destinationFolder.toPath(), new CopyOption[0]);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation);
        if (v5 == var10_7) {
            return var10_7;
        }
        ** GOTO lbl91
        {
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl91:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final List<String> getFilesCountFromArchive(@NotNull File archiveFile, @NotNull List<String> excludeFileList) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".tar.gz", (boolean)false, (int)2, null)) {
            list = DownloadHelperKt.getFilesFromTarGz(archiveFile, excludeFileList);
        } else {
            Object[] objectArray = new String[]{"zip", "nupkg"};
            if (ArraysKt.contains((Object[])objectArray, (Object)FilesKt.getExtension((File)archiveFile))) {
                list = DownloadHelperKt.getFilesFromZip(archiveFile, excludeFileList);
            } else {
                throw new Exception("Unknown archive type: " + archiveFile.getCanonicalPath());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> getFilesFromZip(File archiveFile, List<String> excludeFileList) {
        List<String> list;
        Closeable closeable = new java.util.zip.ZipFile(archiveFile);
        Throwable throwable = null;
        try {
            java.util.zip.ZipFile zipFile = (java.util.zip.ZipFile)closeable;
            boolean bl = false;
            List<String> list2 = zipFile.stream().filter(arg_0 -> DownloadHelperKt.getFilesFromZip$lambda$6$lambda$3((Function1)new Function1<ZipEntry, Boolean>(excludeFileList){
                final /* synthetic */ List<String> $excludeFileList;
                {
                    this.$excludeFileList = $excludeFileList;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(ZipEntry it) {
                    return !it.isDirectory() && !this.$excludeFileList.contains(new File(it.getName()).getName());
                }
            }, arg_0)).map(arg_0 -> DownloadHelperKt.getFilesFromZip$lambda$6$lambda$4(getFilesFromZip.1.2.INSTANCE, arg_0)).filter(arg_0 -> DownloadHelperKt.getFilesFromZip$lambda$6$lambda$5(getFilesFromZip.1.3.INSTANCE, arg_0)).sorted().collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> getFilesFromTarGz(File tagGzFile, List<String> excludeFileList) {
        List result2 = new ArrayList();
        Closeable closeable = new FileInputStream(tagGzFile);
        Throwable throwable = null;
        try {
            FileInputStream file2 = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorInputStream((InputStream)file2);
            Throwable throwable2 = null;
            try {
                GzipCompressorInputStream gzip = (GzipCompressorInputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = (Closeable)new TarArchiveInputStream((InputStream)gzip);
                Throwable throwable3 = null;
                try {
                    TarArchiveInputStream input = (TarArchiveInputStream)closeable3;
                    boolean bl3 = false;
                    while (true) {
                        TarArchiveEntry tarArchiveEntry;
                        TarArchiveEntry tarArchiveEntry2 = tarArchiveEntry = input.getNextTarEntry();
                        if (tarArchiveEntry2 == null) break;
                        Intrinsics.checkNotNull((Object)tarArchiveEntry2);
                        TarArchiveEntry entry2 = tarArchiveEntry;
                        if (entry2.isDirectory() || excludeFileList.contains(new File(entry2.getName()).getName())) continue;
                        String string = entry2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        result2.add(string);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)result2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use suspend one")
    private static final void unzip(File archiveFile, String outputFolder, List<String> excludeFileList, DownloadStatusHandler handler2) {
        try {
            int fileTotalCount = ((Collection)DownloadHelperKt.getFilesFromZip(archiveFile, excludeFileList)).size();
            if (fileTotalCount == 0) {
                return;
            }
            double fileCount = 0.0;
            handler2.reportProgress(fileTotalCount, (long)fileCount);
            Closeable closeable = (Closeable)new ZipFile(archiveFile);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                Enumeration enumeration = zipFile.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
                Iterator iterator2 = CollectionsKt.iterator((Enumeration)enumeration);
                while (iterator2.hasNext()) {
                    Object object;
                    ZipArchiveEntry entry2 = (ZipArchiveEntry)iterator2.next();
                    if (handler2.isCancelled()) break;
                    if (!entry2.isDirectory()) {
                        handler2.reportProgress(fileTotalCount, (long)(fileCount += 1.0));
                    }
                    File file2 = new File(outputFolder, entry2.getName());
                    if (entry2.isDirectory()) {
                        file2.mkdirs();
                    } else {
                        file2.getParentFile().mkdirs();
                        Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(file2));
                        object = null;
                        try {
                            BufferedOutputStream bos = (BufferedOutputStream)closeable2;
                            boolean bl2 = false;
                            long l = zipFile.getInputStream(entry2).transferTo(bos);
                        }
                        catch (Throwable throwable2) {
                            object = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                        }
                    }
                    if (!SystemInfo.isUnix) continue;
                    Set attributesSet = new LinkedHashSet();
                    if ((entry2.getUnixMode() & 0x49) != 0) {
                        object = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};
                        attributesSet.addAll(CollectionsKt.listOf((Object[])object));
                    }
                    if ((entry2.getUnixMode() & 0x92) != 0) {
                        object = new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ};
                        attributesSet.addAll(CollectionsKt.listOf((Object[])object));
                    }
                    if ((entry2.getUnixMode() & 0x124) != 0) {
                        object = new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_WRITE};
                        attributesSet.addAll(CollectionsKt.listOf((Object[])object));
                    }
                    Files.setPosixFilePermissions(file2.toPath(), attributesSet);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            throw new Exception("Can't unzip " + archiveFile, e);
        }
    }

    /*
     * Exception decompiling
     */
    private static final Object unzip(File var0, String var1_1, List<String> var2_2, DownloadStatusHandlerSus var3_3, Continuation<? super Unit> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK], 3[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use suspend one")
    private static final void untar(File archiveFile, Path tempFolder, Path symlinkBase, List<String> excludeFileList, DownloadStatusHandler handler2) {
        try {
            int fileTotalCount = ((Collection)DownloadHelperKt.getFilesFromTarGz(archiveFile, excludeFileList)).size();
            if (fileTotalCount == 0) {
                return;
            }
            double fileCount = 0.0;
            handler2.reportProgress(fileTotalCount, (long)fileCount);
            Closeable closeable = new FileInputStream(archiveFile);
            Throwable throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = stream;
                int n = 8192;
                closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                Throwable throwable2 = null;
                try {
                    BufferedInputStream buffered = (BufferedInputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new GzipCompressorInputStream((InputStream)buffered);
                    Throwable throwable3 = null;
                    try {
                        GzipCompressorInputStream gzip = (GzipCompressorInputStream)closeable3;
                        boolean bl3 = false;
                        Closeable closeable4 = (Closeable)new TarArchiveInputStream((InputStream)gzip);
                        Throwable throwable4 = null;
                        try {
                            TarArchiveInputStream input = (TarArchiveInputStream)closeable4;
                            boolean bl4 = false;
                            while (true) {
                                Path path;
                                Object object;
                                TarArchiveEntry tarArchiveEntry;
                                TarArchiveEntry tarArchiveEntry2 = tarArchiveEntry = input.getNextTarEntry();
                                if (tarArchiveEntry2 == null) break;
                                Intrinsics.checkNotNull((Object)tarArchiveEntry2);
                                TarArchiveEntry entry2 = tarArchiveEntry;
                                if (handler2.isCancelled()) break;
                                if (!entry2.isDirectory()) {
                                    handler2.reportProgress(fileTotalCount, (long)(fileCount += 1.0));
                                }
                                if (entry2.isDirectory()) {
                                    tempFolder.resolve(entry2.getName()).toFile().mkdirs();
                                    continue;
                                }
                                Path destination = tempFolder.resolve(entry2.getName());
                                Object object2 = entry2.getLinkName();
                                if (object2 == null || StringsKt.isBlank((CharSequence)object2)) {
                                    Intrinsics.checkNotNull((Object)destination);
                                    object2 = PathKt.outputStream$default((Path)destination, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
                                    object = null;
                                    try {
                                        OutputStream it = (OutputStream)object2;
                                        boolean bl5 = false;
                                        FileUtil.copy((InputStream)((InputStream)input), (int)((int)entry2.getSize()), (OutputStream)it);
                                        path = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable5) {
                                        object = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                                    }
                                    if (!SystemInfo.isUnix || (entry2.getMode() & 0x49) == 0) continue;
                                    object2 = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE};
                                    Files.setPosixFilePermissions(destination, SetsKt.setOf((Object[])object2));
                                    continue;
                                }
                                String baseLinkPath = "/Library/Frameworks";
                                if (Paths.get(entry2.getLinkName(), new String[0]).startsWith(baseLinkPath)) {
                                    Path path2;
                                    Path relLinkPath = Paths.get(baseLinkPath, new String[0]).relativize(Paths.get(entry2.getLinkName(), new String[0]));
                                    Intrinsics.checkNotNull((Object)destination);
                                    path = destination;
                                    Intrinsics.checkNotNullExpressionValue((Object)symlinkBase.resolve(relLinkPath), (String)"resolve(...)");
                                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                    Intrinsics.checkNotNullExpressionValue((Object)Files.createSymbolicLink(path, path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createSymbolicLink(...)");
                                    continue;
                                }
                                Intrinsics.checkNotNull((Object)destination);
                                object = destination;
                                Intrinsics.checkNotNullExpressionValue((Object)symlinkBase.resolve(entry2.getName()).getParent().resolve(entry2.getLinkName()), (String)"resolve(...)");
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.createSymbolicLink((Path)object, path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createSymbolicLink(...)");
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable6) {
                            throwable4 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            throw new Exception("Can't untar " + archiveFile, e);
        }
    }

    /*
     * Exception decompiling
     */
    private static final Object untar(File var0, Path var1_1, Path var2_2, List<String> var3_3, DownloadStatusHandlerSus var4_4, Continuation<? super Unit> var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 1[TRYBLOCK], 5[TRYBLOCK], 2[TRYBLOCK], 4[TRYBLOCK], 6[TRYBLOCK]], but top level block is 42[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean getFilesFromZip$lambda$6$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getFilesFromZip$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean getFilesFromZip$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$unzip(File archiveFile, String outputFolder, List excludeFileList, DownloadStatusHandlerSus handler2, Continuation $completion) {
        return DownloadHelperKt.unzip(archiveFile, outputFolder, excludeFileList, handler2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$untar(File archiveFile, Path tempFolder, Path symlinkBase, List excludeFileList, DownloadStatusHandlerSus handler2, Continuation $completion) {
        return DownloadHelperKt.untar(archiveFile, tempFolder, symlinkBase, excludeFileList, handler2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ URLConnection access$tryEstablishConnection(String url2, long currentSize, long size, String authToken) {
        return DownloadHelperKt.tryEstablishConnection(url2, currentSize, size, authToken);
    }
}

