/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.Consumer;
import com.jetbrains.rider.model.SpellCheckerTargetType;
import com.jetbrains.rider.spellChecker.RiderSpellCheckingTarget;
import com.jetbrains.rider.spellChecker.RiderSpellCheckingTargetsService;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SuppressibleSpellcheckingStrategy;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)V", "elementFitsScope", "", "element", "Lcom/intellij/psi/PsiElement;", "scope", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "name", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "", "isSuppressedFor", "TargetsDrivenTokenizer", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nBackendLanguageSpellcheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLanguageSpellcheckingStrategy.kt\ncom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,85:1\n31#2,2:86\n26#3:88\n*S KotlinDebug\n*F\n+ 1 BackendLanguageSpellcheckingStrategy.kt\ncom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy\n*L\n33#1:86,2\n44#1:88\n*E\n"})
public abstract class BackendLanguageSpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy {
    @NotNull
    private final Language language;

    public BackendLanguageSpellcheckingStrategy(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    public boolean elementFitsScope(@NotNull PsiElement element, @Nullable Set<SpellCheckingInspection.SpellCheckingScope> scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    @NotNull
    public Tokenizer<?> getTokenizer(@Nullable PsiElement element, @NotNull Set<? extends SpellCheckingInspection.SpellCheckingScope> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        if (element == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        if (element.getFirstChild() != null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Document document = PsiDocumentManager.getInstance((Project)project3).getDocument(element.getContainingFile());
        if (document == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Document document2 = document;
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<RiderSpellCheckingTargetsService> serviceClass$iv = RiderSpellCheckingTargetsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RiderSpellCheckingTargetsService service = (RiderSpellCheckingTargetsService)((Object)object);
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        List<RiderSpellCheckingTarget> list = service.getTargets(document2, textRange);
        if (list == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        List<RiderSpellCheckingTarget> targets = list;
        return new TargetsDrivenTokenizer(targets, scope);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InspectionSuppressor suppressor2 = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(this.language);
        if (suppressor2 != null) {
            SuppressQuickFix[] suppressQuickFixArray = suppressor2.getSuppressActions(element, name);
            Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray, (String)"getSuppressActions(...)");
            return suppressQuickFixArray;
        }
        boolean $i$f$emptyArray = false;
        return new SuppressQuickFix[0];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer;", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lcom/intellij/psi/PsiElement;", "targets", "", "Lcom/jetbrains/rider/spellChecker/RiderSpellCheckingTarget;", "scope", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "(Ljava/util/List;Ljava/util/Set;)V", "getHighlightingRange", "Lcom/intellij/openapi/util/TextRange;", "element", "offset", "", "textRange", "tokenize", "", "consumer", "Lcom/intellij/spellchecker/tokenizer/TokenConsumer;", "DummySplitter", "intellij.rider.rdclient.dotnet"})
    public static final class TargetsDrivenTokenizer
    extends Tokenizer<PsiElement> {
        @NotNull
        private final List<RiderSpellCheckingTarget> targets;
        @NotNull
        private final Set<SpellCheckingInspection.SpellCheckingScope> scope;

        public TargetsDrivenTokenizer(@NotNull List<RiderSpellCheckingTarget> targets, @NotNull Set<? extends SpellCheckingInspection.SpellCheckingScope> scope) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            this.targets = targets;
            this.scope = scope;
        }

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
            String text = element.getText();
            TextRange elementRange = element.getTextRange();
            for (RiderSpellCheckingTarget target : this.targets) {
                if (target.getTargetType() == SpellCheckerTargetType.IDENTIFIER && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Code) || target.getTargetType() == SpellCheckerTargetType.LITERAL && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Literals) || target.getTargetType() == SpellCheckerTargetType.COMMENT && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Comments)) continue;
                for (RangeMarker wordRangeMarker : target.getWordsRangeMarkers()) {
                    TextRange wordRangeInElement;
                    TextRange wordRange;
                    if (RangeMarkersKt.getAsTextRange((RangeMarker)wordRangeMarker) == null || !elementRange.contains(wordRange)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)wordRange.shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)element)), (String)"shiftLeft(...)");
                    consumer2.consumeToken(element, text, target.getTargetType() == SpellCheckerTargetType.IDENTIFIER, 0, wordRangeInElement, (Splitter)DummySplitter.Companion.getINSTANCE());
                }
            }
        }

        @NotNull
        public TextRange getHighlightingRange(@Nullable PsiElement element, int offset, @Nullable TextRange textRange) {
            TextRange textRange2 = super.getHighlightingRange(element, offset, textRange);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getHighlightingRange(...)");
            return textRange2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "Lcom/intellij/spellchecker/inspections/Splitter;", "()V", "split", "", "text", "", "range", "Lcom/intellij/openapi/util/TextRange;", "consumer", "Lcom/intellij/util/Consumer;", "Companion", "intellij.rider.rdclient.dotnet"})
        public static final class DummySplitter
        implements Splitter {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final DummySplitter INSTANCE = new DummySplitter();

            public void split(@Nullable String text, @NotNull TextRange range2, @NotNull Consumer<TextRange> consumer2) {
                Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
                Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
                consumer2.consume((Object)range2);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "getINSTANCE", "()Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "intellij.rider.rdclient.dotnet"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final DummySplitter getINSTANCE() {
                    return INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

