/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRule;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.ICurrentPolicyProvider;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingRuleEditor;
import com.jetbrains.rider.settings.naming.NamingRulesTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$J\b\u0010%\u001a\u00020\"H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/settings/naming/NamingPolicyEditor;", "Ljavax/swing/JPanel;", "Lcom/jetbrains/rider/settings/naming/ICurrentPolicyProvider;", "namingRuleEditor", "Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;", "namingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "(Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;)V", "inspectionsEnabled", "Ljavax/swing/JCheckBox;", "myRuleSelected", "", "myTable", "Lcom/intellij/ui/table/JBTable;", "rules", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "Lkotlin/collections/ArrayList;", "tableSelectionModel", "Ljavax/swing/ListSelectionModel;", "canChangeRuleList", "canRemove", "changeRules", "", "from", "", "to", "convertToMutable", "rule", "Lcom/jetbrains/rider/model/NamingRule;", "createPanel", "table", "fillFromPolicy", "initialValue", "Lcom/jetbrains/rider/model/NamingPolicy;", "policy", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "get", "setSelection", "k", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingPolicyEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1864#2,3:187\n1855#2,2:190\n*S KotlinDebug\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n*L\n79#1:187,3\n100#1:190,2\n*E\n"})
public final class NamingPolicyEditor
extends JPanel
implements ICurrentPolicyProvider {
    @NotNull
    private final NamingRuleEditor namingRuleEditor;
    @NotNull
    private final NamingChangeTracker namingChangeTracker;
    @NotNull
    private final JCheckBox inspectionsEnabled;
    @NotNull
    private final ArrayList<MutableNamingRule> rules;
    @NotNull
    private final ListSelectionModel tableSelectionModel;
    private boolean myRuleSelected;
    @NotNull
    private final JBTable myTable;

    public NamingPolicyEditor(@NotNull NamingRuleEditor namingRuleEditor, @NotNull NamingChangeTracker namingChangeTracker) {
        Intrinsics.checkNotNullParameter((Object)namingRuleEditor, (String)"namingRuleEditor");
        Intrinsics.checkNotNullParameter((Object)namingChangeTracker, (String)"namingChangeTracker");
        this.namingRuleEditor = namingRuleEditor;
        this.namingChangeTracker = namingChangeTracker;
        this.inspectionsEnabled = new JCheckBox();
        this.rules = new ArrayList();
        this.setLayout(new BorderLayout());
        JPanel panelInspections = new JPanel();
        panelInspections.setLayout(new FlowLayout(0));
        this.inspectionsEnabled.setText(RiderSettingsBundle.Companion.message("NamingPolicyEditor.checkbox.enable.inspection", new Object[0]));
        this.inspectionsEnabled.setAlignmentX(0.0f);
        panelInspections.setAlignmentX(0.0f);
        panelInspections.add(this.inspectionsEnabled);
        this.add((Component)panelInspections, "Last");
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)this.namingRuleEditor, "Last");
        NamingRulesTableModel model = new NamingRulesTableModel((List<MutableNamingRule>)this.rules);
        this.myTable = new JBTable((TableModel)model);
        ListSelectionModel listSelectionModel = this.myTable.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"getSelectionModel(...)");
        this.tableSelectionModel = listSelectionModel;
        this.tableSelectionModel.setSelectionMode(0);
        this.tableSelectionModel.addListSelectionListener(arg_0 -> NamingPolicyEditor._init_$lambda$0(this, arg_0));
        JPanel rulesPanel = this.createPanel(this.myTable);
        innerPanel.add(rulesPanel);
        this.add(innerPanel);
        this.inspectionsEnabled.addActionListener(arg_0 -> NamingPolicyEditor._init_$lambda$1(this, arg_0));
        this.inspectionsEnabled.setEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NamingPolicy get() {
        boolean enableInspection = this.inspectionsEnabled.isSelected();
        ArrayList<NamingRule> extraRules = new ArrayList<NamingRule>();
        MutableNamingRule firstRule = (MutableNamingRule)CollectionsKt.first((List)this.rules);
        NamingRule mainRule = new NamingRule(firstRule.getKind(), firstRule.getPrefix(), firstRule.getSuffix());
        Iterable $this$forEachIndexed$iv = this.rules;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MutableNamingRule mutableNamingRule = (MutableNamingRule)item$iv;
            int i = n;
            boolean bl = false;
            if (i == 0) continue;
            NamingRule rule = new NamingRule(it.getKind(), it.getPrefix(), it.getSuffix());
            extraRules.add(rule);
        }
        return new NamingPolicy(mainRule, (List<NamingRule>)extraRules, enableInspection);
    }

    public final void fillFromPolicy(@NotNull NamingPolicy initialValue, @NotNull IOptProperty<NamingPolicy> policy) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        Intrinsics.checkNotNullParameter(policy, (String)"policy");
        int selectedIndex = this.tableSelectionModel.getLeadSelectionIndex();
        this.tableSelectionModel.clearSelection();
        this.namingChangeTracker.stopTracking();
        NamingPolicy policyValue = initialValue;
        this.inspectionsEnabled.setSelected(policyValue.getEnableInspection());
        this.inspectionsEnabled.setEnabled(true);
        this.myRuleSelected = true;
        this.rules.clear();
        this.rules.add(this.convertToMutable(policyValue.getRule()));
        Iterable $this$forEach$iv = policyValue.getExtraRules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NamingRule it = (NamingRule)element$iv;
            boolean bl = false;
            this.rules.add(this.convertToMutable(it));
        }
        if (selectedIndex >= 0 && selectedIndex < ((Collection)this.rules).size()) {
            this.setSelection(selectedIndex);
        } else {
            this.setSelection(0);
        }
        this.validate();
        this.repaint();
        this.namingChangeTracker.startTracking((IMutablePropertyBase<NamingPolicy>)((IMutablePropertyBase)policy));
    }

    private final JPanel createPanel(JBTable table2) {
        AnActionButtonRunnable addRuleAction = arg_0 -> NamingPolicyEditor.createPanel$lambda$4(this, arg_0);
        AnActionButtonRunnable removeRuleAction = arg_0 -> NamingPolicyEditor.createPanel$lambda$5(this, arg_0);
        AnActionButtonRunnable moveUpRuleAction = arg_0 -> NamingPolicyEditor.createPanel$lambda$6(this, arg_0);
        AnActionButtonRunnable moveDownRuleAction = arg_0 -> NamingPolicyEditor.createPanel$lambda$7(this, arg_0);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)table2)).setAddAction(addRuleAction).setAddActionUpdater(arg_0 -> NamingPolicyEditor.createPanel$lambda$8(this, arg_0)).setRemoveAction(removeRuleAction).setRemoveActionUpdater(arg_0 -> NamingPolicyEditor.createPanel$lambda$9(this, arg_0)).setMoveUpAction(moveUpRuleAction).setMoveDownAction(moveDownRuleAction).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final MutableNamingRule convertToMutable(NamingRule rule) {
        return new MutableNamingRule(rule.getKind(), rule.getPrefix(), rule.getSuffix());
    }

    private final void changeRules(int from, int to) {
        MutableNamingRule mutableNamingRule = this.rules.get(from);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
        MutableNamingRule ruleI = mutableNamingRule;
        MutableNamingRule mutableNamingRule2 = this.rules.get(to);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule2, (String)"get(...)");
        MutableNamingRule ruleJ = mutableNamingRule2;
        this.rules.set(to, ruleI);
        this.rules.set(from, ruleJ);
        this.tableSelectionModel.clearSelection();
        this.setSelection(to);
        this.namingChangeTracker.handleDataChanged();
    }

    private final void setSelection(int k) {
        this.tableSelectionModel.setSelectionInterval(k, k);
    }

    private final boolean canChangeRuleList() {
        return this.myRuleSelected;
    }

    private final boolean canRemove() {
        return ((Collection)this.rules).size() > 1;
    }

    private static final void _init_$lambda$0(NamingPolicyEditor this$0, ListSelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int selectedIndex = this$0.tableSelectionModel.getLeadSelectionIndex();
        this$0.tableSelectionModel.getMaxSelectionIndex();
        if (selectedIndex >= 0) {
            MutableNamingRule mutableNamingRule = this$0.rules.get(selectedIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
            MutableNamingRule selectedRule = mutableNamingRule;
            this$0.namingChangeTracker.stopTracking();
            this$0.namingRuleEditor.fillFromRule(selectedRule);
            NamingChangeTracker.startTracking$default(this$0.namingChangeTracker, null, 1, null);
            TableUtil.updateScroller((JTable)((JTable)this$0.myTable));
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this$0.myTable));
        }
    }

    private static final void _init_$lambda$1(NamingPolicyEditor this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.namingChangeTracker.handleDataChanged();
    }

    private static final void createPanel$lambda$4(NamingPolicyEditor this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.tableSelectionModel.clearSelection();
        MutableNamingRule newRule = new MutableNamingRule(NamingStyleKinds.AaBb, "", "");
        this$0.rules.add(newRule);
        int lastIndex = ((Collection)this$0.rules).size() - 1;
        this$0.setSelection(lastIndex);
        this$0.namingChangeTracker.handleDataChanged();
    }

    private static final void createPanel$lambda$5(NamingPolicyEditor this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (((Collection)this$0.rules).size() <= 1) {
            return;
        }
        int selectedIndex = this$0.tableSelectionModel.getLeadSelectionIndex();
        if (selectedIndex >= 0) {
            this$0.tableSelectionModel.clearSelection();
            this$0.rules.remove(selectedIndex);
            int newSelectionIndex = selectedIndex > 0 ? selectedIndex - 1 : 0;
            this$0.setSelection(newSelectionIndex);
            this$0.namingChangeTracker.handleDataChanged();
        }
    }

    private static final void createPanel$lambda$6(NamingPolicyEditor this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int selectedIndex = this$0.tableSelectionModel.getLeadSelectionIndex();
        if (selectedIndex > 0) {
            this$0.changeRules(selectedIndex, selectedIndex - 1);
        }
    }

    private static final void createPanel$lambda$7(NamingPolicyEditor this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int selectedIndex = this$0.tableSelectionModel.getLeadSelectionIndex();
        if (selectedIndex < ((Collection)this$0.rules).size() - 1) {
            this$0.changeRules(selectedIndex, selectedIndex + 1);
        }
    }

    private static final boolean createPanel$lambda$8(NamingPolicyEditor this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canChangeRuleList();
    }

    private static final boolean createPanel$lambda$9(NamingPolicyEditor this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canRemove();
    }
}

