/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.CodeStyleEditorConfigNotification;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRuleItem;
import com.jetbrains.rider.model.StyleItemState;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeStyle.PreviewFactory;
import com.jetbrains.rider.settings.codeStyle.RiderCodeStyleTabPanel;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingItemCommitter;
import com.jetbrains.rider.settings.naming.NamingPageProvider;
import com.jetbrains.rider.settings.naming.NamingPolicyEditor;
import com.jetbrains.rider.settings.naming.NamingPolicySelectionHandler;
import com.jetbrains.rider.settings.naming.NamingRuleEditor;
import com.jetbrains.rider.settings.naming.NamingTreeFactory;
import com.jetbrains.rider.settings.naming.ViewRefresher;
import com.jetbrains.rider.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.renderers.Common;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005*\u0001\u0010\u0018\u0000 82\u00020\u0001:\u00018B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0005H\u0014J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020\u0007H\u0014J\b\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020\u0007H\u0014J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0012\u00101\u001a\u0002022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000704H\u0016J\u0010\u00105\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020(J\u000e\u00106\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020)J\u000e\u00106\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00069"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel;", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "language", "Lcom/intellij/lang/Language;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "title", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/lang/Language;Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "myPanel", "com/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$myPanel$1", "Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$myPanel$1;", "myTreeTable", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "searchString", "searchableKeywords", "", "getSearchableKeywords", "()Ljava/util/List;", "setSearchableKeywords", "(Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "addViewToPanel", "", "view", "Ljavax/swing/JComponent;", "apply", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "createView", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "Lcom/jetbrains/rider/model/NamingPageContentBase;", "getFileType", "getPanel", "getPreviewText", "getRightMargin", "", "getTabTitle", "highlightOptions", "isModified", "", "processListOptions", "", "resetImpl", "setContent", "codeStylePageContent", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleTabPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleTabPanel.kt\ncom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1855#2,2:323\n1#3:325\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleTabPanel.kt\ncom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel\n*L\n281#1:323,2\n*E\n"})
public final class RiderCodeStyleTabPanel
extends CodeStyleAbstractPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Language language;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String title;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final myPanel.1 myPanel;
    @Nullable
    private CodeStyleTreeTable myTreeTable;
    @Nullable
    private String searchString;
    @NotNull
    private List<String> searchableKeywords;
    @NotNull
    private static final JBDimension panelPreferredSize = new JBDimension(800, 400);

    public RiderCodeStyleTabPanel(@Nullable Language language, @NotNull FileType fileType, @NlsContexts.TabTitle @NotNull String title, @NotNull Lifetime lifetime2, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.language = language;
        this.fileType = fileType;
        this.title = title;
        this.lifetime = lifetime2;
        this.myPanel = new JPanel(){

            @NotNull
            public Dimension getMinimumSize() {
                return (Dimension)RiderCodeStyleTabPanel.access$getPanelPreferredSize$cp();
            }
        };
        this.searchableKeywords = CollectionsKt.emptyList();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                Disposer.dispose((Disposable)((Disposable)this));
            }
        });
        this.myPanel.setLayout(new GridLayout(0, 1));
        this.myPanel.setBorder((Border)JBUI.Borders.empty());
        JBLoadingPanel myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0, 4, null);
        myLoadingPanel.startLoading();
        this.myPanel.add((Component)myLoadingPanel, "Center");
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final List<String> getSearchableKeywords() {
        return this.searchableKeywords;
    }

    public final void setSearchableKeywords(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.searchableKeywords = list;
    }

    public final void setContent(@NotNull CodeStylePageContent codeStylePageContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)codeStylePageContent), (String)"codeStylePageContent");
        JComponent view = this.createView(codeStylePageContent);
        this.addViewToPanel(view);
    }

    public final void setContent(@NotNull NamingPageContentBase content) {
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        JComponent view = this.createView(content);
        this.addViewToPanel(view);
    }

    public final void setContent(@NotNull JComponent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.addViewToPanel(content);
    }

    @NotNull
    protected String getTabTitle() {
        return this.title;
    }

    protected int getRightMargin() {
        return 0;
    }

    @NotNull
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return (EditorHighlighter)new EmptyEditorHighlighter(this.getEditor().getColorsScheme().getAttributes(HighlighterColors.TEXT));
    }

    @NotNull
    protected FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    protected String getPreviewText() {
        return "preview text";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
    }

    public boolean isModified(@Nullable CodeStyleSettings settings) {
        return false;
    }

    @NotNull
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
    }

    private final JComponent createView(CodeStylePageContent content) {
        CodeStyleTreeTable treeTable2;
        CodeStyleTreeFactory treeFactory = new CodeStyleTreeFactory((Disposable)this);
        this.myTreeTable = treeTable2 = treeFactory.createTree(content, this.lifetime);
        treeTable2.setTableHeader(null);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setMinimumSize(new Dimension(JBUIScale.scale((int)10), JBUIScale.scale((int)100)));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        JPanel preview = PreviewFactory.Companion.build(this.lifetime, this.language, content.getPreview());
        JSplitPane splitPanel = new JSplitPane(0);
        splitPanel.setBorder((Border)JBUI.Borders.empty());
        splitPanel.setTopComponent((Component)scrollPanel);
        splitPanel.setBottomComponent(preview);
        splitPanel.setResizeWeight(0.66);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder((Border)JBUI.Borders.empty());
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        Color highlightedBackgroundColor = Common.Resources.getHighlightedBackgroundColor();
        HyperlinkLabel editorConfigNotificationPanel = new HyperlinkLabel("", highlightedBackgroundColor);
        editorConfigNotificationPanel.setOpaque(true);
        HyperlinkLabel editorConfigEditPanel = new HyperlinkLabel("", highlightedBackgroundColor);
        editorConfigEditPanel.setOpaque(true);
        JPanel panelWithEditorConfigNotification = new JPanel();
        panelWithEditorConfigNotification.setBorder((Border)JBUI.Borders.empty());
        panelWithEditorConfigNotification.setLayout((LayoutManager)new MigLayout("insets 3 5 3 5", "[]push[]"));
        panelWithEditorConfigNotification.setBackground(highlightedBackgroundColor);
        panelWithEditorConfigNotification.setOpaque(true);
        panelWithEditorConfigNotification.add((Component)editorConfigNotificationPanel);
        panelWithEditorConfigNotification.add((Component)editorConfigEditPanel);
        content.getEditorConfigNotification().advise(this.lifetime, (Function1)new Function1<CodeStyleEditorConfigNotification, Unit>(editorConfigNotificationPanel, highlightedBackgroundColor, panelWithEditorConfigNotification, editorConfigEditPanel){
            final /* synthetic */ HyperlinkLabel $editorConfigNotificationPanel;
            final /* synthetic */ Color $highlightedBackgroundColor;
            final /* synthetic */ JPanel $panelWithEditorConfigNotification;
            final /* synthetic */ HyperlinkLabel $editorConfigEditPanel;
            {
                this.$editorConfigNotificationPanel = $editorConfigNotificationPanel;
                this.$highlightedBackgroundColor = $highlightedBackgroundColor;
                this.$panelWithEditorConfigNotification = $panelWithEditorConfigNotification;
                this.$editorConfigEditPanel = $editorConfigEditPanel;
                super(1);
            }

            public final void invoke(@Nullable CodeStyleEditorConfigNotification it) {
                if (it != null) {
                    this.$editorConfigNotificationPanel.setHtmlText(it.getMessage());
                    this.$editorConfigNotificationPanel.setBackground(this.$highlightedBackgroundColor);
                    this.$panelWithEditorConfigNotification.setVisible(true);
                    CodeStyleEditorConfigNotification params2 = it;
                    this.$editorConfigNotificationPanel.addHyperlinkListener(arg_0 -> createView.1.invoke$lambda$0(params2, arg_0));
                    if (it.getShouldShowEditorConfigEditLink()) {
                        this.$editorConfigEditPanel.setHtmlText(RiderCodeStyleTabPanel.access$createView$getLinkHtml(RiderSettingsBundle.Companion.message("link.label.edit", new Object[0])));
                        this.$editorConfigEditPanel.setBackground(this.$highlightedBackgroundColor);
                        this.$editorConfigEditPanel.addHyperlinkListener(arg_0 -> createView.1.invoke$lambda$1(params2, arg_0));
                    } else {
                        this.$editorConfigEditPanel.setHtmlText("");
                    }
                } else {
                    this.$editorConfigNotificationPanel.setHtmlText("");
                    this.$panelWithEditorConfigNotification.setVisible(false);
                }
            }

            private static final void invoke$lambda$0(CodeStyleEditorConfigNotification $params, HyperlinkEvent it) {
                InterfacesKt.fire($params.getNavigateToHelp());
            }

            private static final void invoke$lambda$1(CodeStyleEditorConfigNotification $params, HyperlinkEvent it) {
                block0: {
                    InterfacesKt.fire($params.getEditEditorConfig());
                    SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
                    if (settingsViewModelHost == null) break block0;
                    settingsViewModelHost.cancel();
                }
            }
        });
        JBColor jBColor = JBColor.namedColor((String)"Notification.ToolWindow.informativeForeground", (Color)UIUtil.getToolTipForeground());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor tipsFgColor = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Notification.ToolWindow.informativeBackground", (Color)((Color)new JBColor(0xBAEEBA, 3359022)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        JBColor tipsBgColor = jBColor2;
        JBLabel tipLabel = new JBLabel("");
        tipLabel.setBackground((Color)tipsBgColor);
        tipLabel.setOpaque(true);
        tipLabel.setForeground((Color)tipsFgColor);
        HyperlinkLabel learnMoreLink = new HyperlinkLabel("", (Color)tipsBgColor);
        learnMoreLink.setOpaque(true);
        HyperlinkLabel closeTipsLink = new HyperlinkLabel("", (Color)tipsBgColor);
        closeTipsLink.setOpaque(true);
        JPanel panelWithTips = new JPanel();
        panelWithTips.setBorder((Border)JBUI.Borders.empty());
        panelWithTips.setLayout((LayoutManager)new MigLayout("insets 3 5 0 5", "[]push[][]", "[]"));
        panelWithTips.setBackground((Color)tipsBgColor);
        panelWithTips.setOpaque(true);
        panelWithTips.add((Component)tipLabel, "grow");
        panelWithTips.add((Component)learnMoreLink, "aligny top");
        panelWithTips.add((Component)closeTipsLink, "wrap, aligny top");
        content.getShouldShowAutoDetectAndConfigureFormattingTip().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(tipLabel, content, closeTipsLink, learnMoreLink, panelWithTips){
            final /* synthetic */ JBLabel $tipLabel;
            final /* synthetic */ CodeStylePageContent $content;
            final /* synthetic */ HyperlinkLabel $closeTipsLink;
            final /* synthetic */ HyperlinkLabel $learnMoreLink;
            final /* synthetic */ JPanel $panelWithTips;
            {
                this.$tipLabel = $tipLabel;
                this.$content = $content;
                this.$closeTipsLink = $closeTipsLink;
                this.$learnMoreLink = $learnMoreLink;
                this.$panelWithTips = $panelWithTips;
                super(1);
            }

            public final void invoke(boolean it) {
                if (it) {
                    this.$tipLabel.setText(new HtmlBuilder().appendRaw(this.$content.getAutoDetectAndConfigureFormattingTip()).wrapWith(HtmlChunk.body().style("white-space:normal")).wrapWith("html").toString());
                    this.$closeTipsLink.setHtmlText(RiderCodeStyleTabPanel.access$createView$getLinkHtml(RiderSettingsBundle.Companion.message("link.label.close", new Object[0])));
                    this.$closeTipsLink.addHyperlinkListener(arg_0 -> createView.2.invoke$lambda$0(this.$content, arg_0));
                    this.$learnMoreLink.setHtmlText(RiderCodeStyleTabPanel.access$createView$getLinkHtml(RiderSettingsBundle.Companion.message("RiderCodeStyleTabPanel.link.label.learn.more", new Object[0])));
                    this.$learnMoreLink.addHyperlinkListener(arg_0 -> createView.2.invoke$lambda$1(this.$content, arg_0));
                    this.$panelWithTips.setVisible(true);
                } else {
                    this.$panelWithTips.setVisible(false);
                }
            }

            private static final void invoke$lambda$0(CodeStylePageContent $content, HyperlinkEvent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)$content), (String)"$content");
                $content.getShouldShowAutoDetectAndConfigureFormattingTip().set((Object)false);
            }

            private static final void invoke$lambda$1(CodeStylePageContent $content, HyperlinkEvent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)$content), (String)"$content");
                InterfacesKt.fire($content.getConfigureFormattingHelp());
            }
        });
        JPanel resPanel = new JPanel();
        resPanel.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        resPanel.setBorder((Border)JBUI.Borders.empty());
        resPanel.add((Component)panelWithTips, "north, hidemode 3");
        resPanel.add((Component)panelWithEditorConfigNotification, "north, hidemode 3");
        resPanel.add((Component)panel2, "center, grow");
        return resPanel;
    }

    private final JComponent createView(NamingPageContentBase content) {
        CodeStyleTreeTable treeTable2;
        JPanel panel2 = new JPanel();
        NamingTreeFactory treeBuilder = new NamingTreeFactory();
        ViewRefresher viewRefresher = new ViewRefresher(panel2);
        NamingItemCommitter namingItemCommitter = new NamingItemCommitter(viewRefresher);
        NamingChangeTracker namingChangeTracker = new NamingChangeTracker(namingItemCommitter);
        NamingRuleEditor ruleEditor = new NamingRuleEditor(namingChangeTracker);
        NamingPolicyEditor policyEditor = new NamingPolicyEditor(ruleEditor, namingChangeTracker);
        NamingPolicySelectionHandler handler2 = new NamingPolicySelectionHandler(policyEditor);
        namingItemCommitter.set(policyEditor);
        this.myTreeTable = treeTable2 = treeBuilder.buildTree(content, handler2);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        JSplitPane splitPanel = new JSplitPane(1);
        splitPanel.setBorder((Border)JBUI.Borders.empty());
        splitPanel.setTopComponent((Component)scrollPanel);
        splitPanel.setBottomComponent(policyEditor);
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder((Border)JBUI.Borders.empty());
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        Iterable $this$forEach$iv = content.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NamingRuleItem it = (NamingRuleItem)((Object)element$iv);
            boolean bl = false;
            it.getPolicy().getChange().advise(this.lifetime, (Function1)new Function1<NamingPolicy, Unit>(content, treeTable2, handler2, viewRefresher){
                final /* synthetic */ NamingPageContentBase $content;
                final /* synthetic */ CodeStyleTreeTable $treeTable;
                final /* synthetic */ NamingPolicySelectionHandler $handler;
                final /* synthetic */ ViewRefresher $viewRefresher;
                {
                    this.$content = $content;
                    this.$treeTable = $treeTable;
                    this.$handler = $handler;
                    this.$viewRefresher = $viewRefresher;
                    super(1);
                }

                public final void invoke(@NotNull NamingPolicy it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    NamingRuleItem selectedItem = (NamingRuleItem)((Object)CollectionsKt.getOrNull(this.$content.getItems(), (int)this.$treeTable.getSelectedRow()));
                    if (selectedItem != null) {
                        this.$handler.handle(selectedItem);
                    }
                    this.$viewRefresher.refresh();
                }
            });
            it.getState().getChange().advise(this.lifetime, (Function1)new Function1<StyleItemState, Unit>(viewRefresher){
                final /* synthetic */ ViewRefresher $viewRefresher;
                {
                    this.$viewRefresher = $viewRefresher;
                    super(1);
                }

                public final void invoke(@NotNull StyleItemState it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    this.$viewRefresher.refresh();
                }
            });
            it.getPreview().getChange().advise(this.lifetime, (Function1)new Function1<String, Unit>(viewRefresher){
                final /* synthetic */ ViewRefresher $viewRefresher;
                {
                    this.$viewRefresher = $viewRefresher;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$viewRefresher.refresh();
                }
            });
            it.isAutoDetected().getChange().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(viewRefresher){
                final /* synthetic */ ViewRefresher $viewRefresher;
                {
                    this.$viewRefresher = $viewRefresher;
                    super(1);
                }

                public final void invoke(boolean it) {
                    this.$viewRefresher.refresh();
                }
            });
            it.getPreviewPolicy().getChange().advise(this.lifetime, (Function1)new Function1<NamingPolicy, Unit>(viewRefresher){
                final /* synthetic */ ViewRefresher $viewRefresher;
                {
                    this.$viewRefresher = $viewRefresher;
                    super(1);
                }

                public final void invoke(@NotNull NamingPolicy it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    this.$viewRefresher.refresh();
                }
            });
        }
        for (NamingPageProvider provider2 : (NamingPageProvider[])NamingPageProvider.Companion.getEP_NAME().getExtensions()) {
            if (!Intrinsics.areEqual((Object)provider2.getLanguage(), (Object)this.language)) continue;
            return provider2.createPage(this.lifetime, viewRefresher, panel2, content);
        }
        return panel2;
    }

    private final void addViewToPanel(JComponent view) {
        block0: {
            this.myPanel.removeAll();
            this.myPanel.add((Component)view, "North");
            this.myPanel.validate();
            this.myPanel.repaint();
            String string = this.searchString;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.highlightOptions(it);
        }
    }

    public void highlightOptions(@NotNull String searchString) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
            this.searchString = searchString;
            CodeStyleTreeTable codeStyleTreeTable = this.myTreeTable;
            if (codeStyleTreeTable == null || (codeStyleTreeTable = codeStyleTreeTable.getSearchHelper()) == null) break block0;
            codeStyleTreeTable.find(searchString);
        }
    }

    @NotNull
    public Set<String> processListOptions() {
        return new HashSet(this.searchableKeywords);
    }

    private static final String createView$getLinkHtml(String label) {
        String string = new HtmlBuilder().append(label).wrapWith("a").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ String access$createView$getLinkHtml(String label) {
        return RiderCodeStyleTabPanel.createView$getLinkHtml(label);
    }

    public static final /* synthetic */ JBDimension access$getPanelPreferredSize$cp() {
        return panelPreferredSize;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$Companion;", "", "()V", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

